//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//  based on icap-client from Rainer Link (OpenAntiVirus.org)
//  adapted by m4d.
//

#include "ICAPScan.hpp"


extern OptionContainer o;


// Constructor
ICAPEngine::ICAPEngine ()
{
}

// Deconstructor
ICAPEngine::~ICAPEngine ()
{
};


int
ICAPEngine::scanFile (const char *_fname)
{
  int rc = VirusEngine::AV_FAIL;

  if (_fname)
    {
      struct stat stat_buf;
      off_t file_size;
      int sockfd;

      FILE *input_file = NULL, *fpin, *fpout;
      char icap_header_str[BUFLEN];
      char http_response_header_str[BUFLEN];
      char encapsulated_header_str[BUFLEN];
      char file_length_hex[BUFLEN];
      char buf[BUFLEN];
      char recvline[MAXLINE + 1];
      char *str;
      bool first_line = false, infected = false;
      size_t nread, nwritten;

      if (stat (_fname, &stat_buf) != 0)
        {
          setErrString (strerror (errno));
          return VirusEngine::AV_FAIL;
        }

      file_size = stat_buf.st_size;

#ifdef DGDEBUG
      cout << "Before connect" << endl;
#endif
      if ((sockfd = dconnect ()) < 0)
        {
          setErrString (strerror (errno));
          return VirusEngine::AV_FAIL;
        }

      /* create the headers */

      /* create Enculapsed header */
      snprintf (encapsulated_header_str, sizeof (encapsulated_header_str), "%s %u\r\n\r\n", ENC_HEADER_S, (unsigned int) file_size);

      /* create length information line */
      snprintf (file_length_hex, sizeof (file_length_hex), "%x\r\n", (unsigned int) file_size);

      /* create "faked" HTTP Request Header */
      snprintf (http_response_header_str, sizeof (http_response_header_str), "%s %s %s\r\n\r\n", "GET", _fname, "HTTP/1.1");

      /* create ICAP HEADER */
      snprintf (icap_header_str, sizeof (icap_header_str),
                "%s %s %s req-hdr=0, res-hdr=%u, res-body=%u\r\n\r\n", ICAP_HEADER_S1, o.icapservice.c_str (), ICAP_HEADER_S2, strlen (http_response_header_str), strlen (http_response_header_str) + strlen (encapsulated_header_str));

      /* open stream for reading */
      fpin = fdopen (sockfd, "r");
      if (fpin == NULL)
        {
          setErrString (strerror (errno));
          return VirusEngine::AV_FAIL;
        }

      /* open stream for writing */
      fpout = fdopen (sockfd, "w");
      if (fpout == NULL)
        {
          setErrString (strerror (errno));
          fclose (fpin);
          return VirusEngine::AV_FAIL;
        }

#ifdef DGDEBUG
      cout << "Send ICAP header" << endl;
#endif
      /* send the headers */
      if (fputs (icap_header_str, fpout) == EOF)
        {
          setErrString (strerror (errno));
          fclose (fpout);
          fclose (fpin);
          return VirusEngine::AV_FAIL;
        }
      if (fputs (http_response_header_str, fpout) == EOF)
        {
          setErrString (strerror (errno));
          fclose (fpout);
          fclose (fpin);
          return VirusEngine::AV_FAIL;
        }
      if (fputs (encapsulated_header_str, fpout) == EOF)
        {
          setErrString (strerror (errno));
          fclose (fpout);
          fclose (fpin);
          return VirusEngine::AV_FAIL;
        }
      /* send length information in hex */
      if (fputs (file_length_hex, fpout) == EOF)
        {
          setErrString (strerror (errno));
          fclose (fpout);
          fclose (fpin);
          return VirusEngine::AV_FAIL;
        }
      fflush (fpout);

#ifdef DGDEBUG
      cout << "Send Data" << endl;
#endif
      /* now send the file ... */
      input_file = fopen (_fname, "r");
      if (input_file == NULL)
        {
          setErrString (strerror (errno));
          fclose (fpout);
          fclose (fpin);
          return VirusEngine::AV_FAIL;
        }
      while ((!feof (input_file)) && (!ferror (input_file)))
        {
          nread = fread (buf, 1, sizeof (buf), input_file);
          nwritten = fwrite (buf, 1, nread, fpout);
          if (nread != nwritten)
            {
              setErrString (strerror (errno));
              fclose (input_file);
              fclose (fpout);
              fclose (fpin);
              return VirusEngine::AV_FAIL;
            }
        }

      if (ferror (input_file))
        {
          setErrString (strerror (errno));
          fclose (input_file);
          fclose (fpout);
          fclose (fpin);
          return VirusEngine::AV_FAIL;
        }
      if (fclose (input_file) == EOF)
        {
          setErrString (strerror (errno));
          fclose (fpout);
          fclose (fpin);
          return VirusEngine::AV_FAIL;
        }

      /* now send the 'end marker' */
      if (fputs ("\r\n0\r\n\r\n", fpout) == EOF)
        {
          setErrString (strerror (errno));
          fclose (fpout);
          fclose (fpin);
          return VirusEngine::AV_FAIL;
        }

      if (fflush (fpout) == EOF)
        {
          setErrString (strerror (errno));
          fclose (fpout);
          fclose (fpin);
          return VirusEngine::AV_FAIL;
        }

      /* OK, now get the response from the ICAP server ... */

#ifdef DGDEBUG
      cout << "Receive response" << endl;
#endif

      /* set line buffering */
      setvbuf (fpin, (char *) NULL, _IOLBF, 0);

      first_line = true;
      while ((fgets (recvline, MAXLINE, fpin)) != NULL)
        {
          str = recvline;
          if (first_line)
            {
              if (strncmp ("ICAP", str, 4) == 0)
                {
                  if (strlen (str) > 11)
                    {
                      str += 9;
                      if (strncmp ("204", str, 3) == 0)
                        {
#ifdef DGDEBUG
                          cout << "File is clean" << endl;
#endif
                          dclose (sockfd);
                          fclose (fpout);
                          fclose (fpin);
                          return VirusEngine::AV_CLEAN;
                        }
                      else if (strncmp ("200", str, 3) == 0)
                        {
                          infected = true;
#ifdef DGDEBUG
                          cout << "File is infected" << endl;
#endif
                        }
                      else
                        {
                          fclose (fpout);
                          fclose (fpin);
                          return VirusEngine::AV_CLEAN;
                        }
                    }
                  else
                    {
                      fclose (fpout);
                      fclose (fpin);
                      return VirusEngine::AV_CLEAN;
                    }
                }
              else
                {
                  fclose (fpout);
                  fclose (fpin);
                  return VirusEngine::AV_CLEAN;
                }
              first_line = false;
            }

          if (infected)
            {
              if (strncmp ("X-Infection-Found", str, 17) == 0)
                {
                  parseVirusName (strstr (str, "Threat="));
                  dclose (sockfd);
                  fclose (fpout);
                  fclose (fpin);
                  return VirusEngine::AV_VIRUS;
                }
            }
        }
      dclose (sockfd);
    }
  return rc;
}

int
ICAPEngine::dconnect ()
{
  int sockfd;
  struct sockaddr_in servaddr;
  struct hostent *he;

  /* create socket */
  if ((sockfd = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
      return -1;
    }

  string socketstr = o.icapsocket;
  string host;
  string port;

  string::size_type p = socketstr.find (':');
  if (p == string::npos)
    {
      host = socketstr;
      port = "1344";
    }
  else
    {
      host = socketstr.substr (0, p);
      port = socketstr.substr (p + 1, socketstr.length ());
    }

  bzero (&servaddr, sizeof (servaddr));
  servaddr.sin_family = AF_INET;
  servaddr.sin_port = htons (atoi (port.c_str ()));

  if ((he = gethostbyname (host.c_str ())) == 0)
    {
      close (sockfd);
      return -1;
    }
  servaddr.sin_addr = *(struct in_addr *) he->h_addr_list[0];

  /* connect to socket */
  if (connect (sockfd, (struct sockaddr *) &servaddr, sizeof (servaddr)) < 0)
    {
      close (sockfd);
      return -1;
    }

  return sockfd;
}

void
ICAPEngine::dclose (int sockfd)
{
  /* sockfd == -1 indicates an error while connecting to socket */
  if (sockfd >= 0)
    {
      close (sockfd);
    }
}

void
ICAPEngine::parseVirusName (const char *_line)
{
  size_t len;
  char *str = NULL;

  str = strstr (_line, "Threat=");
  if (str != NULL)
    {
      if (strlen (str) > 7)
        {
          str += 7;
          len = strlen (strstr (str, ";\r\n"));
          str[strlen (str) - len] = '\0';
          setVirusName (str);
        }
      else
        {
          setVirusName ("UNKNOWN");
        }
    }
  else
    {
      setVirusName ("UNKNOWN");
    }
}
