/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xalan.res.XSLMessages;

public final class WriterToUTF8Buffered
extends Writer {
    private OutputStream m_os;
    private byte[] buf;
    private int count;

    public WriterToUTF8Buffered(OutputStream outputStream) throws UnsupportedEncodingException {
        this(outputStream, 8192);
    }

    public WriterToUTF8Buffered(OutputStream outputStream, int n) {
        this.m_os = outputStream;
        if (n <= 0) {
            throw new IllegalArgumentException(XSLMessages.createMessage(136, null));
        }
        this.buf = new byte[n];
        this.count = 0;
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }

    public void write(int n) throws IOException {
        if (n < 128) {
            if (this.count >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)n;
        } else if (n < 2048) {
            if (this.count + 1 >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)(192 + (n >> 6));
            this.buf[this.count++] = (byte)(128 + (n & 0x3F));
        } else {
            if (this.count + 2 >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)(224 + (n >> 12));
            this.buf[this.count++] = (byte)(128 + (n >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (n & 0x3F));
        }
    }

    public void write(String string) throws IOException {
        int n = string.length();
        int n2 = (n << 1) + n;
        if (n2 >= this.buf.length) {
            this.flushBuffer();
            this.writeDirect(string);
            return;
        }
        if (n2 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        OutputStream outputStream = this.m_os;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
            } else if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c >> 12));
                this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            }
            ++n3;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = (n2 << 1) + n2;
        if (n3 >= this.buf.length) {
            this.flushBuffer();
            this.writeDirect(cArray, n, n2);
            return;
        }
        if (n3 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        OutputStream outputStream = this.m_os;
        int n4 = n2 + n;
        int n5 = n;
        while (n5 < n4) {
            char c = cArray[n5];
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
            } else if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c >> 12));
                this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            }
            ++n5;
        }
    }

    private final void writeDirect(String string) throws IOException {
        int n = string.length();
        OutputStream outputStream = this.m_os;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '\u0080') {
                outputStream.write(c);
            } else if (c < '\u0800') {
                outputStream.write(192 + (c >> 6));
                outputStream.write(128 + (c & 0x3F));
            } else {
                outputStream.write(224 + (c >> 12));
                outputStream.write(128 + (c >> 6 & 0x3F));
                outputStream.write(128 + (c & 0x3F));
            }
            ++n2;
        }
    }

    private final void writeDirect(char[] cArray, int n, int n2) throws IOException {
        OutputStream outputStream = this.m_os;
        int n3 = n2 + n;
        int n4 = n;
        while (n4 < n3) {
            char c = cArray[n4];
            if (c < '\u0080') {
                outputStream.write(c);
            } else if (c < '\u0800') {
                outputStream.write(192 + (c >> 6));
                outputStream.write(128 + (c & 0x3F));
            } else {
                outputStream.write(224 + (c >> 12));
                outputStream.write(128 + (c >> 6 & 0x3F));
                outputStream.write(128 + (c & 0x3F));
            }
            ++n4;
        }
    }
}

