/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef REPORTWIZARDBASEIMPL_H
#define REPORTWIZARDBASEIMPL_H

#include "reportwizard.h"

class Project;
class DataTable;
class DataReport;

class ReportWizard : public ReportWizardBase
{
    Q_OBJECT

public:
    ReportWizard( Project* project, DataReport *report, DataTable* parentTable = 0, bool configure = false );
    ~ReportWizard();

    void accept();

protected slots:
    void reportTemplateChanged( const QString &temp );
    void reportLabelChanged( const QString &label );
    void reportIconChanged();

    void addSortField();
    void reSortSortField();
    void removeSortField();
    void sortFieldUp();
    void sortFieldDown();

    void nextPageClicked();

private:
    void enableAllReportPage( bool b );
    void enableAllSortPage( bool b );

private:
    Project *m_project;
    DataReport *m_report;
    DataTable *m_parentTable;
    bool m_configure;

private:
    void setupFirstPage();
    void setupReportPage();
    void setupSortPage();
};

#endif
