#!/bin/sh

# Fake the system time

dat="$1"

if [ "$dat" = "-v" -o "$dat" = "--version" ] ; then
	echo "$0: Version @VERSION@"
	echo ""
	echo "For usage information, use '$0 --help'."
	exit 0
fi
if [ -z "$dat" -o "$dat" = "-h" -o "$dat" = "-?" -o "$dat" = "--help" ] ; then
	echo "Usage: $0 date program args..."
	echo ""
	echo "Run 'program' with 'args'."
	echo "The program will believe that the current time is 'date'."
	if [ -z "$dat" ] ; then exit 1; else exit 0; fi
fi

shift

# Assume that 'date' already printed an error message
sec=$(date -d "$dat" '+%s')
if [ $? -ne 0 ] ; then exit 1 ; fi

sec=$(expr $(date '+%s') - $sec)
if [ $? -ne 0 ] ; then exit 1 ; fi

export LD_PRELOAD="${LD_PRELOAD}${LD_PRELOAD:+:}/usr/lib/datefudge/datefudge.so"
export DATEFUDGE=$sec

exec "$@"
