/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Config
{
	public class ObjectTranslatorTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public class Thing
		{
			public string name;

			public Thing(string name)
			{
				this.name = name;
			}
		}

		public class ThingCounterTranslator : Db4objects.Db4o.Config.IObjectConstructor
		{
			private Db4objects.Db4o.Foundation.Hashtable4 _countCache = new Db4objects.Db4o.Foundation.Hashtable4
				();

			public virtual void OnActivate(Db4objects.Db4o.IObjectContainer container, object
				 applicationObject, object storedObject)
			{
			}

			public virtual object OnStore(Db4objects.Db4o.IObjectContainer container, object 
				applicationObject)
			{
				Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase.Thing t = (Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase.Thing
					)applicationObject;
				AddToCache(t);
				return t.name;
			}

			private void AddToCache(Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase.Thing
				 t)
			{
				object o = (object)_countCache.Get(t.name);
				if (o == null)
				{
					o = 0;
				}
				_countCache.Put(t.name, ((int)o) + 1);
			}

			public virtual int GetCount(Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase.Thing
				 t)
			{
				object o = (int)_countCache.Get(t.name);
				if (o == null)
				{
					return 0;
				}
				return ((int)o);
			}

			public virtual object OnInstantiate(Db4objects.Db4o.IObjectContainer container, object
				 storedObject)
			{
				string name = (string)storedObject;
				return new Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase.Thing(name
					);
			}

			public virtual System.Type StoredClass()
			{
				return typeof(string);
			}
		}

		private Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase.ThingCounterTranslator
			 _trans;

		protected override void Configure(Db4objects.Db4o.Config.IConfiguration config)
		{
			config.ObjectClass(typeof(Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase.Thing)
				).Translate(_trans = new Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase.ThingCounterTranslator
				());
		}

		protected override void Store()
		{
			Db().Set(new Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase.Thing("jbe"
				));
		}

		public virtual void _testTranslationCount()
		{
			Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase.Thing t = (Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase.Thing
				)RetrieveOnlyInstance(typeof(Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase.Thing)
				);
			Db4oUnit.Assert.IsNotNull(t);
			Db4oUnit.Assert.AreEqual("jbe", t.name);
			Db4oUnit.Assert.AreEqual(1, _trans.GetCount(t));
		}

		public static void Main(string[] args)
		{
			new Db4objects.Db4o.Tests.Common.Config.ObjectTranslatorTestCase().RunSolo();
		}
	}
}
