/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Defragment
{
	public class SlotDefragmentTestCase : Db4oUnit.ITestLifeCycle
	{
		public virtual void TestPrimitiveIndex()
		{
			Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentFixture.AssertIndex(Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentFixture
				.PRIMITIVE_FIELDNAME);
		}

		public virtual void TestWrapperIndex()
		{
			Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentFixture.AssertIndex(Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentFixture
				.WRAPPER_FIELDNAME);
		}

		public virtual void TestTypedObjectIndex()
		{
			Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentFixture.ForceIndex();
			Db4objects.Db4o.Defragment.Defragment.Defrag(Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentTestConstants
				.FILENAME, Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentTestConstants.BACKUPFILENAME
				);
			Db4objects.Db4o.IObjectContainer db = Db4objects.Db4o.Db4oFactory.OpenFile(Db4objects.Db4o.Db4oFactory
				.NewConfiguration(), Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentTestConstants
				.FILENAME);
			Db4objects.Db4o.Query.IQuery query = db.Query();
			query.Constrain(typeof(Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentFixture.Data)
				);
			query.Descend(Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentFixture.TYPEDOBJECT_FIELDNAME
				).Descend(Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentFixture.PRIMITIVE_FIELDNAME
				).Constrain(Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentFixture.VALUE);
			Db4objects.Db4o.IObjectSet result = query.Execute();
			Db4oUnit.Assert.AreEqual(1, result.Size());
			db.Close();
		}

		public virtual void TestNoForceDelete()
		{
			Db4objects.Db4o.Defragment.Defragment.Defrag(Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentTestConstants
				.FILENAME, Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentTestConstants.BACKUPFILENAME
				);
			Db4oUnit.Assert.Expect(typeof(System.IO.IOException), new _AnonymousInnerClass37(
				this));
		}

		private sealed class _AnonymousInnerClass37 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass37(SlotDefragmentTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run()
			{
				Db4objects.Db4o.Defragment.Defragment.Defrag(Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentTestConstants
					.FILENAME, Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentTestConstants.BACKUPFILENAME
					);
			}

			private readonly SlotDefragmentTestCase _enclosing;
		}

		public virtual void SetUp()
		{
			new Sharpen.IO.File(Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentTestConstants
				.FILENAME).Delete();
			new Sharpen.IO.File(Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentTestConstants
				.BACKUPFILENAME).Delete();
			Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentFixture.CreateFile(Db4objects.Db4o.Tests.Common.Defragment.SlotDefragmentTestConstants
				.FILENAME);
		}

		public virtual void TearDown()
		{
		}
	}
}
