/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Foundation
{
	public class ArrayIterator4TestCase : Db4oUnit.ITestCase
	{
		public virtual void TestEmptyArray()
		{
			AssertExhausted(new Db4objects.Db4o.Foundation.ArrayIterator4(new object[0]));
		}

		public virtual void TestArray()
		{
			Db4objects.Db4o.Foundation.ArrayIterator4 i = new Db4objects.Db4o.Foundation.ArrayIterator4
				(new object[] { "foo", "bar" });
			Db4oUnit.Assert.IsTrue(i.MoveNext());
			Db4oUnit.Assert.AreEqual("foo", i.Current);
			Db4oUnit.Assert.IsTrue(i.MoveNext());
			Db4oUnit.Assert.AreEqual("bar", i.Current);
			AssertExhausted(i);
		}

		private void AssertExhausted(Db4objects.Db4o.Foundation.ArrayIterator4 i)
		{
			Db4oUnit.Assert.IsFalse(i.MoveNext());
			Db4oUnit.Assert.Expect(typeof(System.IndexOutOfRangeException), new _AnonymousInnerClass29
				(this, i));
		}

		private sealed class _AnonymousInnerClass29 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass29(ArrayIterator4TestCase _enclosing, Db4objects.Db4o.Foundation.ArrayIterator4
				 i)
			{
				this._enclosing = _enclosing;
				this.i = i;
			}

			public void Run()
			{
				Sharpen.Runtime.Out.WriteLine(i.Current);
			}

			private readonly ArrayIterator4TestCase _enclosing;

			private readonly Db4objects.Db4o.Foundation.ArrayIterator4 i;
		}
	}
}
