/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.CS
{
	public class ClientTransactionPool
	{
		private Db4objects.Db4o.Foundation.Hashtable4 _transaction2Container;

		private Db4objects.Db4o.Foundation.Hashtable4 _fileName2Container;

		private readonly Db4objects.Db4o.Internal.LocalObjectContainer _mainContainer;

		public ClientTransactionPool(Db4objects.Db4o.Internal.LocalObjectContainer mainContainer
			)
		{
			Db4objects.Db4o.Internal.CS.ClientTransactionPool.ContainerCount mainEntry = new 
				Db4objects.Db4o.Internal.CS.ClientTransactionPool.ContainerCount(mainContainer, 
				1);
			_transaction2Container = new Db4objects.Db4o.Foundation.Hashtable4();
			_fileName2Container = new Db4objects.Db4o.Foundation.Hashtable4();
			_fileName2Container.Put(mainContainer.FileName(), mainEntry);
			_mainContainer = mainContainer;
		}

		public virtual Db4objects.Db4o.Internal.Transaction AcquireMain()
		{
			return Acquire(_mainContainer.FileName());
		}

		public virtual Db4objects.Db4o.Internal.Transaction Acquire(string fileName)
		{
			lock (_mainContainer.Lock())
			{
				Db4objects.Db4o.Internal.CS.ClientTransactionPool.ContainerCount entry = (Db4objects.Db4o.Internal.CS.ClientTransactionPool.ContainerCount
					)_fileName2Container.Get(fileName);
				if (entry == null)
				{
					Db4objects.Db4o.Internal.LocalObjectContainer container = (Db4objects.Db4o.Internal.LocalObjectContainer
						)Db4objects.Db4o.Db4oFactory.OpenFile(fileName);
					container.ConfigImpl().SetMessageRecipient(_mainContainer.ConfigImpl().MessageRecipient
						());
					entry = new Db4objects.Db4o.Internal.CS.ClientTransactionPool.ContainerCount(container
						);
					_fileName2Container.Put(fileName, entry);
				}
				Db4objects.Db4o.Internal.Transaction transaction = entry.NewTransaction();
				_transaction2Container.Put(transaction, entry);
				return transaction;
			}
		}

		public virtual void Release(Db4objects.Db4o.Internal.Transaction transaction, bool
			 rollbackOnClose)
		{
			transaction.Close(rollbackOnClose);
			lock (_mainContainer.Lock())
			{
				Db4objects.Db4o.Internal.CS.ClientTransactionPool.ContainerCount entry = (Db4objects.Db4o.Internal.CS.ClientTransactionPool.ContainerCount
					)_transaction2Container.Get(transaction);
				_transaction2Container.Remove(transaction);
				entry.Release();
				if (entry.IsEmpty())
				{
					_fileName2Container.Remove(entry.FileName());
					entry.Close();
				}
			}
		}

		public virtual void Close()
		{
			lock (_mainContainer.Lock())
			{
				_fileName2Container.ForEachValue(new _AnonymousInnerClass61(this));
				_transaction2Container = null;
				_fileName2Container = null;
			}
		}

		private sealed class _AnonymousInnerClass61 : Db4objects.Db4o.Foundation.IVisitor4
		{
			public _AnonymousInnerClass61(ClientTransactionPool _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Visit(object obj)
			{
				((Db4objects.Db4o.Internal.CS.ClientTransactionPool.ContainerCount)obj).Close();
			}

			private readonly ClientTransactionPool _enclosing;
		}

		public virtual int OpenFileCount()
		{
			return (_fileName2Container == null ? 0 : _fileName2Container.Size());
		}

		public virtual bool IsClosed()
		{
			return _mainContainer == null || _mainContainer.IsClosed();
		}

		public virtual void Write(Db4objects.Db4o.Internal.CS.Messages.Msg message, Db4objects.Db4o.Foundation.Network.ISocket4
			 socket)
		{
			message.Write(_mainContainer, socket);
		}

		internal Db4objects.Db4o.Internal.LocalObjectContainer Stream()
		{
			return _mainContainer;
		}

		private class ContainerCount
		{
			private Db4objects.Db4o.Internal.LocalObjectContainer _container;

			private int _count;

			public ContainerCount(Db4objects.Db4o.Internal.LocalObjectContainer container) : 
				this(container, 0)
			{
			}

			public ContainerCount(Db4objects.Db4o.Internal.LocalObjectContainer container, int
				 count)
			{
				_container = container;
				_count = count;
			}

			public virtual bool IsEmpty()
			{
				return _count <= 0;
			}

			public virtual Db4objects.Db4o.Internal.Transaction NewTransaction()
			{
				_count++;
				return _container.NewTransaction();
			}

			public virtual void Release()
			{
				if (_count == 0)
				{
					throw new System.InvalidOperationException();
				}
				_count--;
			}

			public virtual string FileName()
			{
				return _container.FileName();
			}

			public virtual void Close()
			{
				_container.Close();
				_container = null;
			}

			public override int GetHashCode()
			{
				return FileName().GetHashCode();
			}

			public override bool Equals(object obj)
			{
				if (this == obj)
				{
					return true;
				}
				if (obj == null || GetType() != obj.GetType())
				{
					return false;
				}
				Db4objects.Db4o.Internal.CS.ClientTransactionPool.ContainerCount other = (Db4objects.Db4o.Internal.CS.ClientTransactionPool.ContainerCount
					)obj;
				return FileName().Equals(other.FileName());
			}
		}
	}
}
