/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Reflect.Generic
{
	public class GenericClassBuilder : Db4objects.Db4o.Reflect.Generic.IReflectClassBuilder
	{
		private Db4objects.Db4o.Reflect.Generic.GenericReflector _reflector;

		private Db4objects.Db4o.Reflect.IReflector _delegate;

		public GenericClassBuilder(Db4objects.Db4o.Reflect.Generic.GenericReflector reflector
			, Db4objects.Db4o.Reflect.IReflector delegate_) : base()
		{
			_reflector = reflector;
			_delegate = delegate_;
		}

		public virtual Db4objects.Db4o.Reflect.IReflectClass CreateClass(string name, Db4objects.Db4o.Reflect.IReflectClass
			 superClass, int fieldCount)
		{
			Db4objects.Db4o.Reflect.IReflectClass nativeClass = _delegate.ForName(name);
			Db4objects.Db4o.Reflect.Generic.GenericClass clazz = new Db4objects.Db4o.Reflect.Generic.GenericClass
				(_reflector, nativeClass, name, (Db4objects.Db4o.Reflect.Generic.GenericClass)superClass
				);
			clazz.SetDeclaredFieldCount(fieldCount);
			return clazz;
		}

		public virtual Db4objects.Db4o.Reflect.IReflectField CreateField(Db4objects.Db4o.Reflect.IReflectClass
			 parentType, string fieldName, Db4objects.Db4o.Reflect.IReflectClass fieldType, 
			bool isVirtual, bool isPrimitive, bool isArray, bool isNArray)
		{
			if (isVirtual)
			{
				return new Db4objects.Db4o.Reflect.Generic.GenericVirtualField(fieldName);
			}
			return new Db4objects.Db4o.Reflect.Generic.GenericField(fieldName, fieldType, isPrimitive
				, isArray, isNArray);
		}

		public virtual void InitFields(Db4objects.Db4o.Reflect.IReflectClass clazz, Db4objects.Db4o.Reflect.IReflectField[]
			 fields)
		{
			((Db4objects.Db4o.Reflect.Generic.GenericClass)clazz).InitFields((Db4objects.Db4o.Reflect.Generic.GenericField[]
				)fields);
		}

		public virtual Db4objects.Db4o.Reflect.IReflectField[] FieldArray(int length)
		{
			return new Db4objects.Db4o.Reflect.Generic.GenericField[length];
		}
	}
}
