/* Copyright (C) 2004 - 2006 db4objects Inc. http://www.db4o.com */
using System;
using System.Collections;
using com.db4o;
using com.db4o.query;

namespace com.db4odoc.f1.queries
{
	public class NQExample
	{
		public readonly static string YapFileName = "formula1.yap";
		public static void Main(string[] args)
		{
			ObjectContainer db = Db4o.OpenFile(YapFileName);
			try
			{
				StorePilots(db);
				RetrieveComplexSODA(db);
				RetrieveComplexNQ(db);
				RetrieveArbitraryCodeNQ(db);
				ClearDatabase(db);
			}
			finally
			{
				db.Close();
			}
		}
		// end Main
    
		public static void PrimitiveQuery(ObjectContainer db)
		{
			IList pilots = db.Query(new PilotHundredPoints()); 
		}
		// end PrimitiveQuery

		public static void StorePilots(ObjectContainer db)
		{
			db.Set(new Pilot("Michael Schumacher", 100));
			db.Set(new Pilot("Rubens Barrichello", 99));
		}
		// end StorePilots
    
		public static void RetrieveComplexSODA(ObjectContainer db)
		{
			Query query=db.Query();
			query.Constrain(typeof(Pilot));
			Query pointQuery=query.Descend("_points");
			query.Descend("_name").Constrain("Rubens Barrichello")
				.Or(pointQuery.Constrain(99).Greater()
				.And(pointQuery.Constrain(199).Smaller()));
			ObjectSet result=query.Execute();
			ListResult(result);
		}
		// end RetrieveComplexSODA

		public static void RetrieveComplexNQ(ObjectContainer db)
		{
			ObjectSet result = db.Query(new ComplexQuery());
			ListResult(result);
		}
		// end RetrieveComplexNQ

		public static void RetrieveArbitraryCodeNQ(ObjectContainer db)
		{
			ObjectSet result = db.Query(new ArbitraryQuery(new int[]{1,100}));
			ListResult(result);
		}
		// end RetrieveArbitraryCodeNQ
    
		public static void ClearDatabase(ObjectContainer db)
		{
			ObjectSet result = db.Get(typeof(Pilot));
			while (result.HasNext())
			{
				db.Delete(result.Next());
			}
		}
		// end ClearDatabase 

		public static void ListResult(ObjectSet result)
		{
			Console.WriteLine(result.Size());
			while(result.HasNext()) 
			{
				Console.WriteLine(result.Next());
			}
		}
		// end ListResult
	}
}
