package Gtk::Symbols;

use strict;
use Gtk;

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $VERSION);
use vars qw(@FLAG @ENUM @FUNC @SYM @SIGNAL);
use vars qw(
            @GDK_AXIS_USE
            @GDK_BYTE_ORDER
            @GDK_CAP_STYLE
            @GDK_CROSSING_MODE
            @GDK_CURSOR_TYPE
            @GDK_DRAG_PROTO
            @GDK_EV_TYPE
            @GDK_EXT_MODE
            @GDK_FILL
            @GDK_FILL_RULE
            @GDK_FUNC
            @GDK_IMG_TYPE
            @GDK_INPUT_MODE
            @GDK_INPUT_SRC
            @GDK_JOIN_STYLE
            @GDK_LINE_STYLE
            @GDK_NOTIFY_TYPE
            @GDK_OVERLAP_TYPE
            @GDK_PROP_MODE
            @GDK_PROPERTY_STATE
            @GDK_RGB_DITHER
            @GDK_SELECTION
            @GDK_STATUS
            @GDK_SUBWIN_MODE
            @GDK_VISIBILITY_STATE
            @GDK_VISUAL_TYPE
            @GDK_WIN_CLASS
            @GDK_WIN_TYPE
            @ANCHOR_TYPE
            @ARROW_TYPE
            @BTN_BOX_STYLE
            @CLIST_DRAG_POS
            @CTREE_EXPANDER_STYLE
            @CTREE_EXP_TYPE
            @CTREE_LINE_STYLE
            @CTREE_POS
            @CELL_TYPE
            @CORNER_TYPE
            @CURVE_TYPE
            @DIRECTION_TYPE
            @FONT_FILTER_TYPE
            @FONT_METRIC_TYPE
            @FUNDAMENTAL_TYPE
            @JUSTIFICATION
            @MATCH_TYPE
            @MENU_FACTORY_TYPE
            @METRIC_TYPE
            @ORIENTATION
            @PACK_TYPE
            @PATH_PRIORITY_TYPE
            @PATH_TYPE
            @POL_TYPE
            @POSITION_TYPE
            @PREVIEW_TYPE
            @PROG_BAR_ORIENTATION
            @PROG_BAR_STYLE
            @RELIEF_STYLE
            @RESIZE_MODE
            @SCROLL_TYPE
            @SELECTION_MODE
            @SHADOW_TYPE
            @SIDE_TYPE
            @SORT_TYPE
            @STATE_TYPE
            @SUBMENU_DIRECTION
            @SUBMENU_PLACEMENT
            @TOOLBAR_CHILD_TYPE
            @TOOLBAR_SPACE_STYLE
            @TOOLBAR_STYLE
            @TREE_VIEW_MODE
            @TROUGH_TYPE
            @UPDATE_TYPE
            @VISIBILITY
            @WIN_POSITION
            @WIN_TYPE
            @GDK_DRAG_ACTION
            @GDK_EV_MASK
            @GDK_GCVALUES_MASK
            @GDK_INPUT_CONDITION
            @GDK_MOD_TYPE
            @GDK_WMDEC
            @GDK_WMFUNC
            @GDK_WIN_ATTRS_TYPE
            @GDK_WIN_HINTS
            @ACCEL_FLAGS
            @ARG_FLAGS
            @ATTACH_OPTS
            @BTN_ACTION
            @CAL_DISP_OPTS
            @DEBUG_FLAG
            @DEST_DEFAULTS
            @FONT_TYPE
            @OBJ_FLAGS
            @PACKER_OPTS
            @SIG_RUN_TYPE
            @SPIN_BTN_UPDATE_POL
            @TARGET_FLAGS
);

use vars qw(
            @SIG_INPUTDIALOG
            @SIG_NOTEBOOK
            @SIG_CHECKMENUITEM
            @SIG_CONTAINER
            @SIG_WIDGET
            @SIG_MENUITEM
            @SIG_CURVE
            @SIG_COLORSELECTION
            @SIG_LISTITEM
            @SIG_MENUSHELL
            @SIG_ITEM
            @SIG_TREE
            @SIG_TOOLBAR
            @SIG_CTREE
            @SIG_HANDLEBOX
            @SIG_TIPSQUERY
            @SIG_WINDOW
            @SIG_STATUSBAR
            @SIG_EDITABLE
            @SIG_DATA
            @SIG_CALENDAR
            @SIG_BUTTON
            @SIG_LIST
            @SIG_TOGGLEBUTTON
            @SIG_TREEITEM
            @SIG_CLIST
            @SIG_ADJUSTMENT
           );

#=SYM::
use constant NULL => undef();
#=FUNC::
use constant GTK__MAIN_QUIT   => sub { Gtk->main_quit() };
use constant GTK__FALSE       => sub { Gtk::false()     };
use constant GTK__TRUE        => sub { Gtk::true()      };
#=ENUM::
#=GDK_AXIS_USE
use constant GDK_AXIS_USE_IGNORE                 => 'ignore';
use constant GDK_AXIS_USE_X                      => 'x';
use constant GDK_AXIS_USE_Y                      => 'y';
use constant GDK_AXIS_USE_PRESSURE               => 'pressure';
use constant GDK_AXIS_USE_X_TILT                 => 'x-tilt';
use constant GDK_AXIS_USE_Y_TILT                 => 'y-tilt';
use constant GDK_AXIS_USE_LAST                   => 'last';
#=GDK_BYTE_ORDER
use constant GDK_BYTE_ORDER_LSB_FIRST            => 'lsb-first';
use constant GDK_BYTE_ORDER_MSB_FIRST            => 'msb-first';
#=GDK_CAP_STYLE
use constant GDK_CAP_STYLE_NOT_LAST              => 'not-last';
use constant GDK_CAP_STYLE_BUTT                  => 'butt';
use constant GDK_CAP_STYLE_ROUND                 => 'round';
use constant GDK_CAP_STYLE_PROJECTING            => 'projecting';
#=GDK_CROSSING_MODE
use constant GDK_CROSSING_MODE_NORMAL            => 'normal';
use constant GDK_CROSSING_MODE_GRAB              => 'grab';
use constant GDK_CROSSING_MODE_UNGRAB            => 'ungrab';
#=GDK_CURSOR_TYPE
use constant GDK_CURSOR_TYPE_CURSOR              => 'cursor';
#=GDK_DRAG_PROTO
use constant GDK_DRAG_PROTO_MOTIF                => 'motif';
use constant GDK_DRAG_PROTO_XDND                 => 'xdnd';
use constant GDK_DRAG_PROTO_ROOTWIN              => 'rootwin';
use constant GDK_DRAG_PROTO_NONE                 => 'none';
#=GDK_EV_TYPE
use constant GDK_EV_TYPE_NOTHING                 => 'nothing_event';
use constant GDK_EV_TYPE_DELETE                  => 'delete_event';
use constant GDK_EV_TYPE_DESTROY                 => 'destroy_event';
use constant GDK_EV_TYPE_EXPOSE                  => 'expose_event';
use constant GDK_EV_TYPE_MOTION_NOTIFY           => 'motion_notify_event';
use constant GDK_EV_TYPE_BTN_PRESS               => 'button_press_event';
use constant GDK_EV_TYPE_2BTN_PRESS              => '2button_press_event';
use constant GDK_EV_TYPE_3BTN_PRESS              => '3button_press_event';
use constant GDK_EV_TYPE_BTN_RELEASE             => 'button_release_event';
use constant GDK_EV_TYPE_KEY_PRESS               => 'key_press_event';
use constant GDK_EV_TYPE_KEY_RELEASE             => 'key_release_event';
use constant GDK_EV_TYPE_ENTER_NOTIFY            => 'enter_notify_event';
use constant GDK_EV_TYPE_LEAVE_NOTIFY            => 'leave_notify_event';
use constant GDK_EV_TYPE_FOCUS_CHANGE            => 'focus_change_event';
use constant GDK_EV_TYPE_CONFIGURE               => 'configure_event';
use constant GDK_EV_TYPE_MAP                     => 'map_event';
use constant GDK_EV_TYPE_UNMAP                   => 'unmap_event';
use constant GDK_EV_TYPE_PROPERTY_NOTIFY         => 'property_notify_event';
use constant GDK_EV_TYPE_SELECTION_CLEAR         => 'selection_clear_event';
use constant GDK_EV_TYPE_SELECTION_REQUEST       => 'selection_request_event';
use constant GDK_EV_TYPE_SELECTION_NOTIFY        => 'selection_notify_event';
use constant GDK_EV_TYPE_PROXIMITY_IN            => 'proximity_in_event';
use constant GDK_EV_TYPE_PROXIMITY_OUT           => 'proximity_out_event';
use constant GDK_EV_TYPE_DRAG_ENTER              => 'drag_enter_event';
use constant GDK_EV_TYPE_DRAG_LEAVE              => 'drag_leave_event';
use constant GDK_EV_TYPE_DRAG_MOTION             => 'drag_motion_event';
use constant GDK_EV_TYPE_DRAG_STATUS             => 'drag_status_event';
use constant GDK_EV_TYPE_DRAG_START              => 'drag_start_event';
use constant GDK_EV_TYPE_DRAG_FINISHED           => 'drag_finished_event';
use constant GDK_EV_TYPE_CLIENT_EV               => 'client_event';
use constant GDK_EV_TYPE_VISIBILITY_NOTIFY       => 'visibility_notify_event';
use constant GDK_EV_TYPE_NO_EXPOSE               => 'no_expose_event';
#=GDK_EXT_MODE
use constant GDK_EXT_MODE_NONE                   => 'none';
use constant GDK_EXT_MODE_ALL                    => 'all';
use constant GDK_EXT_MODE_CURSOR                 => 'cursor';
#=GDK_FILL
use constant GDK_FILL_SOLID                      => 'solid';
use constant GDK_FILL_TILED                      => 'tiled';
use constant GDK_FILL_STIPPLED                   => 'stippled';
use constant GDK_FILL_OPAQUE_STIPPLED            => 'opaque-stippled';
#=GDK_FILL_RULE
use constant GDK_FILL_RULE_EVEN_ODD_RULE         => 'even-odd-rule';
use constant GDK_FILL_RULE_WINDING_RULE          => 'winding-rule';
#=GDK_FUNC
use constant GDK_FUNC_COPY                       => 'copy';
use constant GDK_FUNC_INVERT                     => 'invert';
use constant GDK_FUNC_XOR                        => 'xor';
use constant GDK_FUNC_CLEAR                      => 'clear';
use constant GDK_FUNC_AND                        => 'and';
use constant GDK_FUNC_AND_REVERSE                => 'and-reverse';
use constant GDK_FUNC_AND_INVERT                 => 'and-invert';
use constant GDK_FUNC_NOOP                       => 'noop';
use constant GDK_FUNC_OR                         => 'or';
use constant GDK_FUNC_EQUIV                      => 'equiv';
use constant GDK_FUNC_OR_REVERSE                 => 'or-reverse';
use constant GDK_FUNC_COPY_INVERT                => 'copy-invert';
use constant GDK_FUNC_OR_INVERT                  => 'or-invert';
use constant GDK_FUNC_NAND                       => 'nand';
use constant GDK_FUNC_SET                        => 'set';
#=GDK_IMG_TYPE
use constant GDK_IMG_TYPE_NORMAL                 => 'normal';
use constant GDK_IMG_TYPE_SHARED                 => 'shared';
use constant GDK_IMG_TYPE_FASTEST                => 'fastest';
#=GDK_INPUT_MODE
use constant GDK_INPUT_MODE_DISABLED             => 'disabled';
use constant GDK_INPUT_MODE_SCREEN               => 'screen';
use constant GDK_INPUT_MODE_WIN                  => 'window';
#=GDK_INPUT_SRC
use constant GDK_INPUT_SRC_MOUSE                 => 'mouse';
use constant GDK_INPUT_SRC_PEN                   => 'pen';
use constant GDK_INPUT_SRC_ERASER                => 'eraser';
use constant GDK_INPUT_SRC_CURSOR                => 'cursor';
#=GDK_JOIN_STYLE
use constant GDK_JOIN_STYLE_MITER                => 'miter';
use constant GDK_JOIN_STYLE_ROUND                => 'round';
use constant GDK_JOIN_STYLE_BEVEL                => 'bevel';
#=GDK_LINE_STYLE
use constant GDK_LINE_STYLE_SOLID                => 'solid';
use constant GDK_LINE_STYLE_ON_OFF_DASH          => 'on-off-dash';
use constant GDK_LINE_STYLE_DOUBLE_DASH          => 'double-dash';
#=GDK_NOTIFY_TYPE
use constant GDK_NOTIFY_TYPE_ANCESTOR            => 'ancestor';
use constant GDK_NOTIFY_TYPE_VIRTUAL             => 'virtual';
use constant GDK_NOTIFY_TYPE_INFERIOR            => 'inferior';
use constant GDK_NOTIFY_TYPE_NONLINEAR           => 'nonlinear';
use constant GDK_NOTIFY_TYPE_NONLINEAR_VIRTUAL   => 'nonlinear-virtual';
use constant GDK_NOTIFY_TYPE_UNKNOWN             => 'unknown';
#=GDK_OVERLAP_TYPE
use constant GDK_OVERLAP_TYPE_IN                 => 'in';
use constant GDK_OVERLAP_TYPE_OUT                => 'out';
use constant GDK_OVERLAP_TYPE_PART               => 'part';
#=GDK_PROP_MODE
use constant GDK_PROP_MODE_REPLACE               => 'replace';
use constant GDK_PROP_MODE_PREPEND               => 'prepend';
use constant GDK_PROP_MODE_APPEND                => 'append';
#=GDK_PROPERTY_STATE
use constant GDK_PROPERTY_STATE_NEW_VALUE        => 'new-value';
use constant GDK_PROPERTY_STATE_DELETE           => 'delete';
#=GDK_RGB_DITHER
use constant GDK_RGB_DITHER_NONE                 => 'none';
use constant GDK_RGB_DITHER_NORMAL               => 'normal';
use constant GDK_RGB_DITHER_MAX                  => 'max';
#=GDK_SELECTION
use constant GDK_SELECTION_PRIMARY               => 'primary';
use constant GDK_SELECTION_SECONDARY             => 'secondary';
#=GDK_STATUS
use constant GDK_STATUS_OK                       => 'ok';
use constant GDK_STATUS_ERROR                    => 'error';
use constant GDK_STATUS_ERROR_PARAM              => 'error-param';
use constant GDK_STATUS_ERROR_FILE               => 'error-file';
use constant GDK_STATUS_ERROR_MEM                => 'error-mem';
#=GDK_SUBWIN_MODE
use constant GDK_SUBWIN_MODE_CLIP_BY_CHILDREN    => 'clip-by-children';
use constant GDK_SUBWIN_MODE_INCLUDE_INFERIORS   => 'include-inferiors';
#=GDK_VISIBILITY_STATE
use constant GDK_VISIBILITY_STATE_UNOBSCURED     => 'unobscured';
use constant GDK_VISIBILITY_STATE_PARTIAL        => 'partial';
use constant GDK_VISIBILITY_STATE_FULLY_OBSCURED => 'fully-obscured';
#=GDK_VISUAL_TYPE
use constant GDK_VISUAL_TYPE_STATIC_GRAY         => 'static-gray';
use constant GDK_VISUAL_TYPE_GRAYSCALE           => 'grayscale';
use constant GDK_VISUAL_TYPE_STATIC_COLOR        => 'static-color';
use constant GDK_VISUAL_TYPE_PSEUDO_COLOR        => 'pseudo-color';
use constant GDK_VISUAL_TYPE_TRUE_COLOR          => 'true-color';
use constant GDK_VISUAL_TYPE_DIRECT_COLOR        => 'direct-color';
#=GDK_WIN_CLASS
use constant GDK_WIN_CLASS_INPUT_OUTPUT          => 'input-output';
use constant GDK_WIN_CLASS_INPUT_ONLY            => 'input-only';
#=GDK_WIN_TYPE
use constant GDK_WIN_TYPE_ROOT                   => 'root';
use constant GDK_WIN_TYPE_TOPLEVEL               => 'toplevel';
use constant GDK_WIN_TYPE_CHILD                  => 'child';
use constant GDK_WIN_TYPE_DIALOG                 => 'dialog';
use constant GDK_WIN_TYPE_TEMP                   => 'temp';
use constant GDK_WIN_TYPE_PIXMAP                 => 'pixmap';
#=ANCHOR_TYPE
use constant ANCHOR_TYPE_CENTER                  => 'center';
use constant ANCHOR_TYPE_NORTH                   => 'north';
use constant ANCHOR_TYPE_NE                      => 'ne';
use constant ANCHOR_TYPE_EAST                    => 'east';
use constant ANCHOR_TYPE_SE                      => 'se';
use constant ANCHOR_TYPE_SOUTH                   => 'south';
use constant ANCHOR_TYPE_SW                      => 'sw';
use constant ANCHOR_TYPE_WEST                    => 'west';
use constant ANCHOR_TYPE_NW                      => 'nw';
#=ARROW_TYPE
use constant ARROW_TYPE_UP                       => 'up';
use constant ARROW_TYPE_DOWN                     => 'down';
use constant ARROW_TYPE_LEFT                     => 'left';
use constant ARROW_TYPE_RIGHT                    => 'right';
#=BTN_BOX_STYLE
use constant BTN_BOX_STYLE_DEFAULT_STYLE         => 'default-style';
use constant BTN_BOX_STYLE_SPREAD                => 'spread';
use constant BTN_BOX_STYLE_EDGE                  => 'edge';
use constant BTN_BOX_STYLE_START                 => 'start';
use constant BTN_BOX_STYLE_END                   => 'end';
#=CLIST_DRAG_POS
use constant CLIST_DRAG_POS_NONE                 => 'none';
use constant CLIST_DRAG_POS_BEFORE               => 'before';
use constant CLIST_DRAG_POS_INTO                 => 'into';
use constant CLIST_DRAG_POS_AFTER                => 'after';
#=CTREE_EXPANDER_STYLE
use constant CTREE_EXPANDER_STYLE_NONE           => 'none';
use constant CTREE_EXPANDER_STYLE_SQUARE         => 'square';
use constant CTREE_EXPANDER_STYLE_TRIANGLE       => 'triangle';
use constant CTREE_EXPANDER_STYLE_CIRCULAR       => 'circular';
#=CTREE_EXP_TYPE
use constant CTREE_EXP_TYPE_EXPAND               => 'expand';
use constant CTREE_EXP_TYPE_EXPAND_RECURSIVE     => 'expand-recursive';
use constant CTREE_EXP_TYPE_COLLAPSE             => 'collapse';
use constant CTREE_EXP_TYPE_COLLAPSE_RECURSIVE   => 'collapse-recursive';
use constant CTREE_EXP_TYPE_TOGGLE               => 'toggle';
use constant CTREE_EXP_TYPE_TOGGLE_RECURSIVE     => 'toggle-recursive';
#=CTREE_LINE_STYLE
use constant CTREE_LINE_STYLE_SOLID              => 'solid';
use constant CTREE_LINE_STYLE_DOTTED             => 'dotted';
use constant CTREE_LINE_STYLE_TABBED             => 'tabbed';
use constant CTREE_LINE_STYLE_NONE               => 'none';
#=CTREE_POS
use constant CTREE_POS_BEFORE                    => 'before';
use constant CTREE_POS_AS_CHILD                  => 'as-child';
use constant CTREE_POS_AFTER                     => 'after';
#=CELL_TYPE
use constant CELL_TYPE_EMPTY                     => 'empty';
use constant CELL_TYPE_TEXT                      => 'text';
use constant CELL_TYPE_PIXMAP                    => 'pixmap';
use constant CELL_TYPE_PIXTEXT                   => 'pixtext';
use constant CELL_TYPE_WIDGET                    => 'widget';
#=CORNER_TYPE
use constant CORNER_TYPE_TOP_LEFT                => 'top-left';
use constant CORNER_TYPE_BOTTOM_LEFT             => 'bottom-left';
use constant CORNER_TYPE_TOP_RIGHT               => 'top-right';
use constant CORNER_TYPE_BOTTOM_RIGHT            => 'bottom-right';
#=CURVE_TYPE
use constant CURVE_TYPE_LINEAR                   => 'linear';
use constant CURVE_TYPE_SPLINE                   => 'spline';
use constant CURVE_TYPE_FREE                     => 'free';
#=DIRECTION_TYPE
use constant DIRECTION_TYPE_TAB_FORWARD          => 'tab-forward';
use constant DIRECTION_TYPE_TAB_BACKWARD         => 'tab-backward';
use constant DIRECTION_TYPE_UP                   => 'up';
use constant DIRECTION_TYPE_DOWN                 => 'down';
use constant DIRECTION_TYPE_LEFT                 => 'left';
use constant DIRECTION_TYPE_RIGHT                => 'right';
#=FONT_FILTER_TYPE
use constant FONT_FILTER_TYPE_BASE               => 'base';
use constant FONT_FILTER_TYPE_USER               => 'user';
#=FONT_METRIC_TYPE
use constant FONT_METRIC_TYPE_PIXELS_METRIC      => 'pixels-metric';
use constant FONT_METRIC_TYPE_POINTS_METRIC      => 'points-metric';
#=FUNDAMENTAL_TYPE
use constant FUNDAMENTAL_TYPE_INVALID            => 'invalid';
use constant FUNDAMENTAL_TYPE_NONE               => 'none';
use constant FUNDAMENTAL_TYPE_CHAR               => 'char';
use constant FUNDAMENTAL_TYPE_BOOL               => 'bool';
use constant FUNDAMENTAL_TYPE_INT                => 'int';
use constant FUNDAMENTAL_TYPE_UINT               => 'uint';
use constant FUNDAMENTAL_TYPE_LONG               => 'long';
use constant FUNDAMENTAL_TYPE_ULONG              => 'ulong';
use constant FUNDAMENTAL_TYPE_FLOAT              => 'float';
use constant FUNDAMENTAL_TYPE_STRING             => 'string';
use constant FUNDAMENTAL_TYPE_ENUM               => 'enum';
use constant FUNDAMENTAL_TYPE_FLAGS              => 'flags';
use constant FUNDAMENTAL_TYPE_BOXED              => 'boxed';
use constant FUNDAMENTAL_TYPE_FOREIGN            => 'foreign';
use constant FUNDAMENTAL_TYPE_CALLBACK           => 'callback';
use constant FUNDAMENTAL_TYPE_ARGS               => 'args';
use constant FUNDAMENTAL_TYPE_PTR                => 'pointer';
use constant FUNDAMENTAL_TYPE_SIG                => 'signal';
use constant FUNDAMENTAL_TYPE_C_CALLBACK         => 'c-callback';
use constant FUNDAMENTAL_TYPE_OBJ                => 'object';
#=JUSTIFICATION
use constant JUSTIFICATION_LEFT                  => 'left';
use constant JUSTIFICATION_RIGHT                 => 'right';
use constant JUSTIFICATION_CENTER                => 'center';
use constant JUSTIFICATION_FILL                  => 'fill';
#=MATCH_TYPE
use constant MATCH_TYPE_ALL                      => 'all';
use constant MATCH_TYPE_ALL_TAIL                 => 'all-tail';
use constant MATCH_TYPE_HEAD                     => 'head';
use constant MATCH_TYPE_TAIL                     => 'tail';
use constant MATCH_TYPE_EXACT                    => 'exact';
use constant MATCH_TYPE_LAST                     => 'last';
#=MENU_FACTORY_TYPE
use constant MENU_FACTORY_TYPE_MENU              => 'menu';
use constant MENU_FACTORY_TYPE_MENU_BAR          => 'menu-bar';
use constant MENU_FACTORY_TYPE_OPT_MENU          => 'option-menu';
#=METRIC_TYPE
use constant METRIC_TYPE_PIXELS                  => 'pixels';
use constant METRIC_TYPE_INCHES                  => 'inches';
use constant METRIC_TYPE_CENTIMETERS             => 'centimeters';
#=ORIENTATION
use constant ORIENTATION_HORIZONTAL              => 'horizontal';
use constant ORIENTATION_VERTICAL                => 'vertical';
#=PACK_TYPE
use constant PACK_TYPE_START                     => 'start';
use constant PACK_TYPE_END                       => 'end';
#=PATH_PRIORITY_TYPE
use constant PATH_PRIORITY_TYPE_LOWEST           => 'lowest';
use constant PATH_PRIORITY_TYPE_GTK              => 'gtk';
use constant PATH_PRIORITY_TYPE_APPLICATION      => 'application';
use constant PATH_PRIORITY_TYPE_RC               => 'rc';
use constant PATH_PRIORITY_TYPE_HIGHEST          => 'highest';
use constant PATH_PRIORITY_TYPE_MASK             => 'mask';
#=PATH_TYPE
use constant PATH_TYPE_WIDGET                    => 'widget';
use constant PATH_TYPE_WIDGET_CLASS              => 'widget-class';
use constant PATH_TYPE_CLASS                     => 'class';
#=POL_TYPE
use constant POL_TYPE_ALWAYS                     => 'always';
use constant POL_TYPE_NEVER                      => 'never';
use constant POL_TYPE_AUTOMATIC                  => 'automatic';
#=POSITION_TYPE
use constant POSITION_TYPE_LEFT                  => 'left';
use constant POSITION_TYPE_RIGHT                 => 'right';
use constant POSITION_TYPE_TOP                   => 'top';
use constant POSITION_TYPE_BOTTOM                => 'bottom';
#=PREVIEW_TYPE
use constant PREVIEW_TYPE_COLOR                  => 'color';
use constant PREVIEW_TYPE_GRAYSCALE              => 'grayscale';
#=PROG_BAR_ORIENTATION
use constant PROG_BAR_ORIENTATION_LEFT_TO_RIGHT  => 'left-to-right';
use constant PROG_BAR_ORIENTATION_RIGHT_TO_LEFT  => 'right-to-left';
use constant PROG_BAR_ORIENTATION_BOTTOM_TO_TOP  => 'bottom-to-top';
use constant PROG_BAR_ORIENTATION_TOP_TO_BOTTOM  => 'top-to-bottom';
#=PROG_BAR_STYLE
use constant PROG_BAR_STYLE_CONTINUOUS           => 'continuous';
use constant PROG_BAR_STYLE_DISCRETE             => 'discrete';
#=RELIEF_STYLE
use constant RELIEF_STYLE_NORMAL                 => 'normal';
use constant RELIEF_STYLE_HALF                   => 'half';
use constant RELIEF_STYLE_NONE                   => 'none';
#=RESIZE_MODE
use constant RESIZE_MODE_PARENT                  => 'parent';
use constant RESIZE_MODE_QUEUE                   => 'queue';
use constant RESIZE_MODE_IMMEDIATE               => 'immediate';
#=SCROLL_TYPE
use constant SCROLL_TYPE_NONE                    => 'none';
use constant SCROLL_TYPE_STEP_BACKWARD           => 'step-backward';
use constant SCROLL_TYPE_STEP_FORWARD            => 'step-forward';
use constant SCROLL_TYPE_PAGE_BACKWARD           => 'page-backward';
use constant SCROLL_TYPE_PAGE_FORWARD            => 'page-forward';
use constant SCROLL_TYPE_JUMP                    => 'jump';
#=SELECTION_MODE
use constant SELECTION_MODE_SINGLE               => 'single';
use constant SELECTION_MODE_BROWSE               => 'browse';
use constant SELECTION_MODE_MULTIPLE             => 'multiple';
use constant SELECTION_MODE_EXTENDED             => 'extended';
#=SHADOW_TYPE
use constant SHADOW_TYPE_NONE                    => 'none';
use constant SHADOW_TYPE_IN                      => 'in';
use constant SHADOW_TYPE_OUT                     => 'out';
use constant SHADOW_TYPE_ETCHED_IN               => 'etched-in';
use constant SHADOW_TYPE_ETCHED_OUT              => 'etched-out';
#=SIDE_TYPE
use constant SIDE_TYPE_TOP                       => 'top';
use constant SIDE_TYPE_BOTTOM                    => 'bottom';
use constant SIDE_TYPE_LEFT                      => 'left';
use constant SIDE_TYPE_RIGHT                     => 'right';
#=SORT_TYPE
use constant SORT_TYPE_ASCENDING                 => 'ascending';
use constant SORT_TYPE_DESCENDING                => 'descending';
#=STATE_TYPE
use constant STATE_TYPE_NORMAL                   => 'normal';
use constant STATE_TYPE_ACTIVE                   => 'active';
use constant STATE_TYPE_PRELIGHT                 => 'prelight';
use constant STATE_TYPE_SELECTED                 => 'selected';
use constant STATE_TYPE_INSENSITIVE              => 'insensitive';
#=SUBMENU_DIRECTION
use constant SUBMENU_DIRECTION_LEFT              => 'left';
use constant SUBMENU_DIRECTION_RIGHT             => 'right';
#=SUBMENU_PLACEMENT
use constant SUBMENU_PLACEMENT_TOP_BOTTOM        => 'top-bottom';
use constant SUBMENU_PLACEMENT_LEFT_RIGHT        => 'left-right';
#=TOOLBAR_CHILD_TYPE
use constant TOOLBAR_CHILD_TYPE_SPACE            => 'space';
use constant TOOLBAR_CHILD_TYPE_BTN              => 'button';
use constant TOOLBAR_CHILD_TYPE_TOGGLE_BTN       => 'toggle-button';
use constant TOOLBAR_CHILD_TYPE_RADIO_BTN        => 'radio-button';
use constant TOOLBAR_CHILD_TYPE_WIDGET           => 'widget';
#=TOOLBAR_SPACE_STYLE
use constant TOOLBAR_SPACE_STYLE_EMPTY           => 'empty';
use constant TOOLBAR_SPACE_STYLE_LINE            => 'line';
#=TOOLBAR_STYLE
use constant TOOLBAR_STYLE_ICONS                 => 'icons';
use constant TOOLBAR_STYLE_TEXT                  => 'text';
use constant TOOLBAR_STYLE_BOTH                  => 'both';
#=TREE_VIEW_MODE
use constant TREE_VIEW_MODE_LINE                 => 'line';
use constant TREE_VIEW_MODE_ITEM                 => 'item';
#=TROUGH_TYPE
use constant TROUGH_TYPE_NONE                    => 'none';
use constant TROUGH_TYPE_START                   => 'start';
use constant TROUGH_TYPE_END                     => 'end';
use constant TROUGH_TYPE_JUMP                    => 'jump';
#=UPDATE_TYPE
use constant UPDATE_TYPE_CONTINUOUS              => 'continuous';
use constant UPDATE_TYPE_DISCONTINUOUS           => 'discontinuous';
use constant UPDATE_TYPE_DELAYED                 => 'delayed';
#=VISIBILITY
use constant VISIBILITY_NONE                     => 'none';
use constant VISIBILITY_PARTIAL                  => 'partial';
use constant VISIBILITY_FULL                     => 'full';
#=WIN_POSITION
use constant WIN_POSITION_NONE                   => 'none';
use constant WIN_POSITION_CENTER                 => 'center';
use constant WIN_POSITION_MOUSE                  => 'mouse';
#=WIN_TYPE
use constant WIN_TYPE_TOPLEVEL                   => 'toplevel';
use constant WIN_TYPE_DIALOG                     => 'dialog';
use constant WIN_TYPE_POPUP                      => 'popup';
#=FLAGS::
#=GDK_DRAG_ACTION
use constant GDK_DRAG_ACTION_DEFAULT             => 'default';
use constant GDK_DRAG_ACTION_COPY                => 'copy';
use constant GDK_DRAG_ACTION_MOVE                => 'move';
use constant GDK_DRAG_ACTION_LINK                => 'link';
use constant GDK_DRAG_ACTION_PRIVATE             => 'private';
use constant GDK_DRAG_ACTION_ASK                 => 'ask';
#=GDK_EV_MASK
use constant GDK_EV_MASK_EXPOSURE_MASK           => 'exposure-mask';
use constant GDK_EV_MASK_PTR_MOTION_MASK         => 'pointer-motion-mask';
use constant GDK_EV_MASK_PTR_MOTION_HINT_MASK    => 'pointer-motion-hint-mask';
use constant GDK_EV_MASK_BTN_MOTION_MASK         => 'button-motion-mask';
use constant GDK_EV_MASK_BTN1_MOTION_MASK        => 'button1-motion-mask';
use constant GDK_EV_MASK_BTN2_MOTION_MASK        => 'button2-motion-mask';
use constant GDK_EV_MASK_BTN3_MOTION_MASK        => 'button3-motion-mask';
use constant GDK_EV_MASK_BTN_PRESS_MASK          => 'button-press-mask';
use constant GDK_EV_MASK_BTN_RELEASE_MASK        => 'button-release-mask';
use constant GDK_EV_MASK_KEY_PRESS_MASK          => 'key-press-mask';
use constant GDK_EV_MASK_KEY_RELEASE_MASK        => 'key-release-mask';
use constant GDK_EV_MASK_ENTER_NOTIFY_MASK       => 'enter-notify-mask';
use constant GDK_EV_MASK_LEAVE_NOTIFY_MASK       => 'leave-notify-mask';
use constant GDK_EV_MASK_FOCUS_CHANGE_MASK       => 'focus-change-mask';
use constant GDK_EV_MASK_STRUCTURE_MASK          => 'structure-mask';
use constant GDK_EV_MASK_ALL_EVS_MASK            => 'all-events-mask';
#=GDK_GCVALUES_MASK
use constant GDK_GCVALUES_MASK_FOREGROUND        => 'foreground';
use constant GDK_GCVALUES_MASK_BACKGROUND        => 'background';
use constant GDK_GCVALUES_MASK_FONT              => 'font';
use constant GDK_GCVALUES_MASK_FUNC              => 'function';
use constant GDK_GCVALUES_MASK_FILL              => 'fill';
use constant GDK_GCVALUES_MASK_TILE              => 'tile';
use constant GDK_GCVALUES_MASK_STIPPLE           => 'stipple';
use constant GDK_GCVALUES_MASK_CLIP_MASK         => 'clip-mask';
use constant GDK_GCVALUES_MASK_SUBWIN            => 'subwindow';
use constant GDK_GCVALUES_MASK_TS_X_ORIGIN       => 'ts-x-origin';
use constant GDK_GCVALUES_MASK_TS_Y_ORIGIN       => 'ts-y-origin';
use constant GDK_GCVALUES_MASK_CLIP_X_ORIGIN     => 'clip-x-origin';
use constant GDK_GCVALUES_MASK_CLIP_Y_ORIGIN     => 'clip-y-origin';
use constant GDK_GCVALUES_MASK_EXPOSURES         => 'exposures';
use constant GDK_GCVALUES_MASK_LINE_WIDTH        => 'line-width';
use constant GDK_GCVALUES_MASK_LINE_STYLE        => 'line-style';
use constant GDK_GCVALUES_MASK_CAP_STYLE         => 'cap-style';
use constant GDK_GCVALUES_MASK_JOIN_STYLE        => 'join-style';
#=GDK_INPUT_CONDITION
use constant GDK_INPUT_CONDITION_READ            => 'read';
use constant GDK_INPUT_CONDITION_WRITE           => 'write';
use constant GDK_INPUT_CONDITION_EXCEPTION       => 'exception';
#=GDK_MOD_TYPE
use constant GDK_MOD_TYPE_SHIFT_MASK             => 'shift-mask';
use constant GDK_MOD_TYPE_LOCK_MASK              => 'lock-mask';
use constant GDK_MOD_TYPE_CONTROL_MASK           => 'control-mask';
use constant GDK_MOD_TYPE_MOD1_MASK              => 'mod1-mask';
use constant GDK_MOD_TYPE_MOD2_MASK              => 'mod2-mask';
use constant GDK_MOD_TYPE_MOD3_MASK              => 'mod3-mask';
use constant GDK_MOD_TYPE_MOD4_MASK              => 'mod4-mask';
use constant GDK_MOD_TYPE_MOD5_MASK              => 'mod5-mask';
use constant GDK_MOD_TYPE_BTN1_MASK              => 'button1-mask';
use constant GDK_MOD_TYPE_BTN2_MASK              => 'button2-mask';
use constant GDK_MOD_TYPE_BTN3_MASK              => 'button3-mask';
use constant GDK_MOD_TYPE_BTN4_MASK              => 'button4-mask';
use constant GDK_MOD_TYPE_BTN5_MASK              => 'button5-mask';
#=GDK_WMDEC
use constant GDK_WMDEC_ALL                       => 'all';
use constant GDK_WMDEC_BORDER                    => 'border';
use constant GDK_WMDEC_RESIZEH                   => 'resizeh';
use constant GDK_WMDEC_TITLE                     => 'title';
use constant GDK_WMDEC_MENU                      => 'menu';
use constant GDK_WMDEC_MINIMIZE                  => 'minimize';
use constant GDK_WMDEC_MAXIMIZE                  => 'maximize';
#=GDK_WMFUNC
use constant GDK_WMFUNC_ALL                      => 'all';
use constant GDK_WMFUNC_RESIZE                   => 'resize';
use constant GDK_WMFUNC_MOVE                     => 'move';
use constant GDK_WMFUNC_MINIMIZE                 => 'minimize';
use constant GDK_WMFUNC_MAXIMIZE                 => 'maximize';
use constant GDK_WMFUNC_CLOSE                    => 'close';
#=GDK_WIN_ATTRS_TYPE
use constant GDK_WIN_ATTRS_TYPE_TITLE            => 'title';
use constant GDK_WIN_ATTRS_TYPE_X                => 'x';
use constant GDK_WIN_ATTRS_TYPE_Y                => 'y';
use constant GDK_WIN_ATTRS_TYPE_CURSOR           => 'cursor';
use constant GDK_WIN_ATTRS_TYPE_COLORMAP         => 'colormap';
use constant GDK_WIN_ATTRS_TYPE_VISUAL           => 'visual';
#=GDK_WIN_HINTS
use constant GDK_WIN_HINTS_POS                   => 'pos';
use constant GDK_WIN_HINTS_MIN_SIZE              => 'min-size';
use constant GDK_WIN_HINTS_MAX_SIZE              => 'max-size';
use constant GDK_WIN_HINTS_BASE_SIZE             => 'base-size';
use constant GDK_WIN_HINTS_ASPECT                => 'aspect';
use constant GDK_WIN_HINTS_RESIZE_INC            => 'resize-inc';
#=ACCEL_FLAGS
use constant ACCEL_FLAGS_VISIBLE                 => 'visible';
use constant ACCEL_FLAGS_SIG_VISIBLE             => 'signal-visible';
use constant ACCEL_FLAGS_LOCKED                  => 'locked';
use constant ACCEL_FLAGS_MASK                    => 'mask';
#=ARG_FLAGS
use constant ARG_FLAGS_READABLE                  => 'readable';
use constant ARG_FLAGS_WRITABLE                  => 'writable';
use constant ARG_FLAGS_CONSTRUCT                 => 'construct';
use constant ARG_FLAGS_CONSTRUCT_ONLY            => 'construct-only';
use constant ARG_FLAGS_CHILD_ARG                 => 'child-arg';
#=ATTACH_OPTS
use constant ATTACH_OPTS_EXPAND                  => 'expand';
use constant ATTACH_OPTS_SHRINK                  => 'shrink';
use constant ATTACH_OPTS_FILL                    => 'fill';
#=BTN_ACTION
use constant BTN_ACTION_IGNORED                  => 'ignored';
use constant BTN_ACTION_SELECTS                  => 'selects';
use constant BTN_ACTION_DRAGS                    => 'drags';
use constant BTN_ACTION_EXPANDS                  => 'expands';
#=CAL_DISP_OPTS
use constant CAL_DISP_OPTS_SHOW_HEADING          => 'show-heading';
use constant CAL_DISP_OPTS_SHOW_DAY_NAMES        => 'show-day-names';
use constant CAL_DISP_OPTS_NO_MONTH_CHANGE       => 'no-month-change';
use constant CAL_DISP_OPTS_SHOW_WEEKS_NUMBERS    => 'show-weeks-numbers';
use constant CAL_DISP_OPTS_WEEK_START_MONDAY     => 'week-start-monday';
#=DEBUG_FLAG
use constant DEBUG_FLAG_OBJS                     => 'objects';
use constant DEBUG_FLAG_MISC                     => 'misc';
use constant DEBUG_FLAG_SIGS                     => 'signals';
#=DEST_DEFAULTS
use constant DEST_DEFAULTS_MOTION                => 'motion';
use constant DEST_DEFAULTS_HIGHLIGHT             => 'highlight';
use constant DEST_DEFAULTS_DROP                  => 'drop';
use constant DEST_DEFAULTS_ALL                   => 'all';
#=FONT_TYPE
use constant FONT_TYPE_BITMAP                    => 'bitmap';
use constant FONT_TYPE_SCALABLE                  => 'scalable';
use constant FONT_TYPE_SCALABLE_BITMAP           => 'scalable-bitmap';
use constant FONT_TYPE_ALL                       => 'all';
#=OBJ_FLAGS
use constant OBJ_FLAGS_DESTROYED                 => 'destroyed';
use constant OBJ_FLAGS_FLOATING                  => 'floating';
use constant OBJ_FLAGS_CONNECTED                 => 'connected';
#=PACKER_OPTS
use constant PACKER_OPTS_PACK_EXPAND             => 'pack-expand';
use constant PACKER_OPTS_FILL_X                  => 'fill-x';
use constant PACKER_OPTS_FILL_Y                  => 'fill-y';
#=SIG_RUN_TYPE
use constant SIG_RUN_TYPE_FIRST                  => 'first';
use constant SIG_RUN_TYPE_LAST                   => 'last';
use constant SIG_RUN_TYPE_BOTH                   => 'both';
use constant SIG_RUN_TYPE_NO_RECURSE             => 'no-recurse';
use constant SIG_RUN_TYPE_ACTION                 => 'action';
#=SPIN_BTN_UPDATE_POL
use constant SPIN_BTN_UPDATE_POL_ALWAYS          => 'always';
use constant SPIN_BTN_UPDATE_POL_IF_VALID        => 'if-valid';
#=TARGET_FLAGS
use constant TARGET_FLAGS_SAME_APP               => 'same-app';
use constant TARGET_FLAGS_SAME_WIDGET            => 'same-widget';
#=SIGNALS
use constant ADJUSTMENT_CHANGED             => 'changed';
use constant ADJUSTMENT_VALUE_CHANGED       => 'value-changed';
use constant BUTTON_PRESSED                 => 'pressed';
use constant BUTTON_RELEASED                => 'released';
use constant BUTTON_CLICKED                 => 'clicked';
use constant BUTTON_ENTER                   => 'enter';
use constant BUTTON_LEAVE                   => 'leave';
use constant CALENDAR_MONTH_CHANGED         => 'month-changed';
use constant CALENDAR_DAY_SELECTED          => 'day-selected';
use constant CALENDAR_DAY_SELECTED_DOUBLE_CLICK => 'day-selected-double-click';
use constant CALENDAR_PREV_MONTH            => 'prev-month';
use constant CALENDAR_NEXT_MONTH            => 'next-month';
use constant CALENDAR_PREV_YEAR             => 'prev-year';
use constant CALENDAR_NEXT_YEAR             => 'next-year';
use constant CHECKMENUITEM_TOGGLED          => 'toggled';
use constant CLIST_SELECT_ROW               => 'select-row';
use constant CLIST_UNSELECT_ROW             => 'unselect-row';
use constant CLIST_ROW_MOVE                 => 'row-move';
use constant CLIST_CLICK_COLUMN             => 'click-column';
use constant CLIST_RESIZE_COLUMN            => 'resize-column';
use constant CLIST_TOGGLE_FOCUS_ROW         => 'toggle-focus-row';
use constant CLIST_SELECT_ALL               => 'select-all';
use constant CLIST_UNSELECT_ALL             => 'unselect-all';
use constant CLIST_UNDO_SELECTION           => 'undo-selection';
use constant CLIST_START_SELECTION          => 'start-selection';
use constant CLIST_END_SELECTION            => 'end-selection';
use constant CLIST_TOGGLE_ADD_MODE          => 'toggle-add-mode';
use constant CLIST_EXTEND_SELECTION         => 'extend-selection';
use constant CLIST_SCROLL_VERTICAL          => 'scroll-vertical';
use constant CLIST_SCROLL_HORIZONTAL        => 'scroll-horizontal';
use constant CLIST_ABORT_COLUMN_RESIZE      => 'abort-column-resize';
use constant COLORSELECTION_COLOR_CHANGED   => 'color-changed';
use constant CONTAINER_ADD                  => 'add';
use constant CONTAINER_REMOVE               => 'remove';
use constant CONTAINER_CHECK_RESIZE         => 'check-resize';
use constant CONTAINER_SET_FOCUS_CHILD      => 'set-focus-child';
use constant CTREE_TREE_SELECT_ROW          => 'tree-select-row';
use constant CTREE_TREE_UNSELECT_ROW        => 'tree-unselect-row';
use constant CTREE_TREE_EXPAND              => 'tree-expand';
use constant CTREE_TREE_COLLAPSE            => 'tree-collapse';
use constant CTREE_TREE_MOVE                => 'tree-move';
use constant CTREE_CHANGE_FOCUS_ROW_EXPANSION => 'change-focus-row-expansion';
use constant CURVE_CURVE_TYPE_CHANGED       => 'curve-type-changed';
use constant DATA_DISCONNECT                => 'disconnect';
use constant EDITABLE_CHANGED               => 'changed';
use constant EDITABLE_INSERT_TEXT           => 'insert-text';
use constant EDITABLE_DELETE_TEXT           => 'delete-text';
use constant EDITABLE_ACTIVATE              => 'activate';
use constant EDITABLE_SET_EDITABLE          => 'set-editable';
use constant EDITABLE_MOVE_CURSOR           => 'move-cursor';
use constant EDITABLE_MOVE_WORD             => 'move-word';
use constant EDITABLE_MOVE_PAGE             => 'move-page';
use constant EDITABLE_MOVE_TO_ROW           => 'move-to-row';
use constant EDITABLE_MOVE_TO_COLUMN        => 'move-to-column';
use constant EDITABLE_KILL_CHAR             => 'kill-char';
use constant EDITABLE_KILL_WORD             => 'kill-word';
use constant EDITABLE_KILL_LINE             => 'kill-line';
use constant EDITABLE_CUT_CLIPBOARD         => 'cut-clipboard';
use constant EDITABLE_COPY_CLIPBOARD        => 'copy-clipboard';
use constant EDITABLE_PASTE_CLIPBOARD       => 'paste-clipboard';
use constant HANDLEBOX_CHILD_ATTACHED       => 'child-attached';
use constant HANDLEBOX_CHILD_DETACHED       => 'child-detached';
use constant INPUTDIALOG_ENABLE_DEVICE      => 'enable-device';
use constant INPUTDIALOG_DISABLE_DEVICE     => 'disable-device';
use constant ITEM_SELECT                    => 'select';
use constant ITEM_DESELECT                  => 'deselect';
use constant ITEM_TOGGLE                    => 'toggle';
use constant LIST_SELECTION_CHANGED         => 'selection-changed';
use constant LIST_SELECT_CHILD              => 'select-child';
use constant LIST_UNSELECT_CHILD            => 'unselect-child';
use constant LISTITEM_TOGGLE_FOCUS_ROW      => 'toggle-focus-row';
use constant LISTITEM_SELECT_ALL            => 'select-all';
use constant LISTITEM_UNSELECT_ALL          => 'unselect-all';
use constant LISTITEM_UNDO_SELECTION        => 'undo-selection';
use constant LISTITEM_START_SELECTION       => 'start-selection';
use constant LISTITEM_END_SELECTION         => 'end-selection';
use constant LISTITEM_TOGGLE_ADD_MODE       => 'toggle-add-mode';
use constant LISTITEM_EXTEND_SELECTION      => 'extend-selection';
use constant LISTITEM_SCROLL_VERTICAL       => 'scroll-vertical';
use constant LISTITEM_SCROLL_HORIZONTAL     => 'scroll-horizontal';
use constant MENUITEM_ACTIVATE              => 'activate';
use constant MENUITEM_ACTIVATE_ITEM         => 'activate-item';
use constant MENUSHELL_DEACTIVATE           => 'deactivate';
use constant MENUSHELL_SELECTION_DONE       => 'selection-done';
use constant MENUSHELL_MOVE_CURRENT         => 'move-current';
use constant MENUSHELL_ACTIVATE_CURRENT     => 'activate-current';
use constant MENUSHELL_CANCEL               => 'cancel';
use constant NOTEBOOK_SWITCH_PAGE           => 'switch-page';
use constant STATUSBAR_TEXT_PUSHED          => 'text-pushed';
use constant STATUSBAR_TEXT_POPPED          => 'text-popped';
use constant TIPSQUERY_START_QUERY          => 'start-query';
use constant TIPSQUERY_STOP_QUERY           => 'stop-query';
use constant TIPSQUERY_WIDGET_ENTERED       => 'widget-entered';
use constant TOGGLEBUTTON_TOGGLED           => 'toggled';
use constant TOOLBAR_ORIENTATION_CHANGED    => 'orientation-changed';
use constant TOOLBAR_STYLE_CHANGED          => 'style-changed';
use constant TREE_SELECTION_CHANGED         => 'selection-changed';
use constant TREE_SELECT_CHILD              => 'select-child';
use constant TREE_UNSELECT_CHILD            => 'unselect-child';
use constant TREEITEM_COLLAPSE              => 'collapse';
use constant TREEITEM_EXPAND                => 'expand';
use constant WIDGET_SHOW                    => 'show';
use constant WIDGET_HIDE                    => 'hide';
use constant WIDGET_MAP                     => 'map';
use constant WIDGET_UNMAP                   => 'unmap';
use constant WIDGET_REALIZE                 => 'realize';
use constant WIDGET_UNREALIZE               => 'unrealize';
use constant WIDGET_DRAW                    => 'draw';
use constant WIDGET_DRAW_FOCUS              => 'draw-focus';
use constant WIDGET_DRAW_DEFAULT            => 'draw-default';
use constant WIDGET_SIZE_REQUEST            => 'size-request';
use constant WIDGET_SIZE_ALLOCATE           => 'size-allocate';
use constant WIDGET_STATE_CHANGED           => 'state-changed';
use constant WIDGET_PARENT_SET              => 'parent-set';
use constant WIDGET_STYLE_SET               => 'style-set';
use constant WIDGET_ADD_ACCELERATOR         => 'add-accelerator';
use constant WIDGET_REMOVE_ACCELERATOR      => 'remove-accelerator';
use constant WIDGET_SELECTION_GET           => 'selection-get';
use constant WIDGET_SELECTION_RECEIVED      => 'selection-received';
use constant WIDGET_DRAG_BEGIN              => 'drag-begin';
use constant WIDGET_DRAG_END                => 'drag-end';
use constant WIDGET_DRAG_DATA_DELETE        => 'drag-data-delete';
use constant WIDGET_DRAG_LEAVE              => 'drag-leave';
use constant WIDGET_DRAG_DATA_GET           => 'drag-data-get';
use constant WIDGET_DRAG_DATA_RECEIVED      => 'drag-data-received';
use constant WIDGET_DEBUG_MSG               => 'debug-msg';
use constant WINDOW_SET_FOCUS               => 'set-focus';

@GDK_AXIS_USE = 
    qw(GDK_AXIS_USE_IGNORE
       GDK_AXIS_USE_X
       GDK_AXIS_USE_Y
       GDK_AXIS_USE_PRESSURE
       GDK_AXIS_USE_X_TILT
       GDK_AXIS_USE_Y_TILT
       GDK_AXIS_USE_LAST);

@GDK_BYTE_ORDER = 
    qw(GDK_BYTE_ORDER_LSB_FIRST
       GDK_BYTE_ORDER_MSB_FIRST);

@GDK_CAP_STYLE = 
    qw(GDK_CAP_STYLE_NOT_LAST
       GDK_CAP_STYLE_BUTT
       GDK_CAP_STYLE_ROUND
       GDK_CAP_STYLE_PROJECTING);

@GDK_CROSSING_MODE = 
    qw(GDK_CROSSING_MODE_NORMAL
       GDK_CROSSING_MODE_GRAB
       GDK_CROSSING_MODE_UNGRAB);

@GDK_CURSOR_TYPE = 
    qw(GDK_CURSOR_TYPE_CURSOR);

@GDK_DRAG_PROTO = 
    qw(GDK_DRAG_PROTO_MOTIF
       GDK_DRAG_PROTO_XDND
       GDK_DRAG_PROTO_ROOTWIN
       GDK_DRAG_PROTO_NONE);

@GDK_EV_TYPE = 
    qw(GDK_EV_TYPE_NOTHING
       GDK_EV_TYPE_DELETE
       GDK_EV_TYPE_DESTROY
       GDK_EV_TYPE_EXPOSE
       GDK_EV_TYPE_MOTION_NOTIFY
       GDK_EV_TYPE_BTN_PRESS
       GDK_EV_TYPE_2BTN_PRESS
       GDK_EV_TYPE_3BTN_PRESS
       GDK_EV_TYPE_BTN_RELEASE
       GDK_EV_TYPE_KEY_PRESS
       GDK_EV_TYPE_KEY_RELEASE
       GDK_EV_TYPE_ENTER_NOTIFY
       GDK_EV_TYPE_LEAVE_NOTIFY
       GDK_EV_TYPE_FOCUS_CHANGE
       GDK_EV_TYPE_CONFIGURE
       GDK_EV_TYPE_MAP
       GDK_EV_TYPE_UNMAP
       GDK_EV_TYPE_PROPERTY_NOTIFY
       GDK_EV_TYPE_SELECTION_CLEAR
       GDK_EV_TYPE_SELECTION_REQUEST
       GDK_EV_TYPE_SELECTION_NOTIFY
       GDK_EV_TYPE_PROXIMITY_IN
       GDK_EV_TYPE_PROXIMITY_OUT
       GDK_EV_TYPE_DRAG_ENTER
       GDK_EV_TYPE_DRAG_LEAVE
       GDK_EV_TYPE_DRAG_MOTION
       GDK_EV_TYPE_DRAG_STATUS
       GDK_EV_TYPE_DRAG_START
       GDK_EV_TYPE_DRAG_FINISHED
       GDK_EV_TYPE_CLIENT_EV
       GDK_EV_TYPE_VISIBILITY_NOTIFY
       GDK_EV_TYPE_NO_EXPOSE);

@GDK_EXT_MODE = 
    qw(GDK_EXT_MODE_NONE
       GDK_EXT_MODE_ALL
       GDK_EXT_MODE_CURSOR);

@GDK_FILL = 
    qw(GDK_FILL_SOLID
       GDK_FILL_TILED
       GDK_FILL_STIPPLED
       GDK_FILL_OPAQUE_STIPPLED);

@GDK_FILL_RULE = 
    qw(GDK_FILL_RULE_EVEN_ODD_RULE
       GDK_FILL_RULE_WINDING_RULE);

@GDK_FUNC = 
    qw(GDK_FUNC_COPY
       GDK_FUNC_INVERT
       GDK_FUNC_XOR
       GDK_FUNC_CLEAR
       GDK_FUNC_AND
       GDK_FUNC_AND_REVERSE
       GDK_FUNC_AND_INVERT
       GDK_FUNC_NOOP
       GDK_FUNC_OR
       GDK_FUNC_EQUIV
       GDK_FUNC_OR_REVERSE
       GDK_FUNC_COPY_INVERT
       GDK_FUNC_OR_INVERT
       GDK_FUNC_NAND
       GDK_FUNC_SET);

@GDK_IMG_TYPE = 
    qw(GDK_IMG_TYPE_NORMAL
       GDK_IMG_TYPE_SHARED
       GDK_IMG_TYPE_FASTEST);

@GDK_INPUT_MODE = 
    qw(GDK_INPUT_MODE_DISABLED
       GDK_INPUT_MODE_SCREEN
       GDK_INPUT_MODE_WIN);

@GDK_INPUT_SRC = 
    qw(GDK_INPUT_SRC_MOUSE
       GDK_INPUT_SRC_PEN
       GDK_INPUT_SRC_ERASER
       GDK_INPUT_SRC_CURSOR);

@GDK_JOIN_STYLE = 
    qw(GDK_JOIN_STYLE_MITER
       GDK_JOIN_STYLE_ROUND
       GDK_JOIN_STYLE_BEVEL);

@GDK_LINE_STYLE = 
    qw(GDK_LINE_STYLE_SOLID
       GDK_LINE_STYLE_ON_OFF_DASH
       GDK_LINE_STYLE_DOUBLE_DASH);

@GDK_NOTIFY_TYPE = 
    qw(GDK_NOTIFY_TYPE_ANCESTOR
       GDK_NOTIFY_TYPE_VIRTUAL
       GDK_NOTIFY_TYPE_INFERIOR
       GDK_NOTIFY_TYPE_NONLINEAR
       GDK_NOTIFY_TYPE_NONLINEAR_VIRTUAL
       GDK_NOTIFY_TYPE_UNKNOWN);

@GDK_OVERLAP_TYPE = 
    qw(GDK_OVERLAP_TYPE_IN
       GDK_OVERLAP_TYPE_OUT
       GDK_OVERLAP_TYPE_PART);

@GDK_PROP_MODE = 
    qw(GDK_PROP_MODE_REPLACE
       GDK_PROP_MODE_PREPEND
       GDK_PROP_MODE_APPEND);

@GDK_PROPERTY_STATE = 
    qw(GDK_PROPERTY_STATE_NEW_VALUE
       GDK_PROPERTY_STATE_DELETE);

@GDK_RGB_DITHER = 
    qw(GDK_RGB_DITHER_NONE
       GDK_RGB_DITHER_NORMAL
       GDK_RGB_DITHER_MAX);

@GDK_SELECTION = 
    qw(GDK_SELECTION_PRIMARY
       GDK_SELECTION_SECONDARY);

@GDK_STATUS = 
    qw(GDK_STATUS_OK
       GDK_STATUS_ERROR
       GDK_STATUS_ERROR_PARAM
       GDK_STATUS_ERROR_FILE
       GDK_STATUS_ERROR_MEM);

@GDK_SUBWIN_MODE = 
    qw(GDK_SUBWIN_MODE_CLIP_BY_CHILDREN
       GDK_SUBWIN_MODE_INCLUDE_INFERIORS);

@GDK_VISIBILITY_STATE = 
    qw(GDK_VISIBILITY_STATE_UNOBSCURED
       GDK_VISIBILITY_STATE_PARTIAL
       GDK_VISIBILITY_STATE_FULLY_OBSCURED);

@GDK_VISUAL_TYPE = 
    qw(GDK_VISUAL_TYPE_STATIC_GRAY
       GDK_VISUAL_TYPE_GRAYSCALE
       GDK_VISUAL_TYPE_STATIC_COLOR
       GDK_VISUAL_TYPE_PSEUDO_COLOR
       GDK_VISUAL_TYPE_TRUE_COLOR
       GDK_VISUAL_TYPE_DIRECT_COLOR);

@GDK_WIN_CLASS = 
    qw(GDK_WIN_CLASS_INPUT_OUTPUT
       GDK_WIN_CLASS_INPUT_ONLY);

@GDK_WIN_TYPE = 
    qw(GDK_WIN_TYPE_ROOT
       GDK_WIN_TYPE_TOPLEVEL
       GDK_WIN_TYPE_CHILD
       GDK_WIN_TYPE_DIALOG
       GDK_WIN_TYPE_TEMP
       GDK_WIN_TYPE_PIXMAP);

@ANCHOR_TYPE = 
    qw(ANCHOR_TYPE_CENTER
       ANCHOR_TYPE_NORTH
       ANCHOR_TYPE_NE
       ANCHOR_TYPE_EAST
       ANCHOR_TYPE_SE
       ANCHOR_TYPE_SOUTH
       ANCHOR_TYPE_SW
       ANCHOR_TYPE_WEST
       ANCHOR_TYPE_NW);

@ARROW_TYPE = 
    qw(ARROW_TYPE_UP
       ARROW_TYPE_DOWN
       ARROW_TYPE_LEFT
       ARROW_TYPE_RIGHT);

@BTN_BOX_STYLE = 
    qw(BTN_BOX_STYLE_DEFAULT_STYLE
       BTN_BOX_STYLE_SPREAD
       BTN_BOX_STYLE_EDGE
       BTN_BOX_STYLE_START
       BTN_BOX_STYLE_END);

@CLIST_DRAG_POS = 
    qw(CLIST_DRAG_POS_NONE
       CLIST_DRAG_POS_BEFORE
       CLIST_DRAG_POS_INTO
       CLIST_DRAG_POS_AFTER);

@CTREE_EXPANDER_STYLE = 
    qw(CTREE_EXPANDER_STYLE_NONE
       CTREE_EXPANDER_STYLE_SQUARE
       CTREE_EXPANDER_STYLE_TRIANGLE
       CTREE_EXPANDER_STYLE_CIRCULAR);

@CTREE_EXP_TYPE = 
    qw(CTREE_EXP_TYPE_EXPAND
       CTREE_EXP_TYPE_EXPAND_RECURSIVE
       CTREE_EXP_TYPE_COLLAPSE
       CTREE_EXP_TYPE_COLLAPSE_RECURSIVE
       CTREE_EXP_TYPE_TOGGLE
       CTREE_EXP_TYPE_TOGGLE_RECURSIVE);

@CTREE_LINE_STYLE = 
    qw(CTREE_LINE_STYLE_SOLID
       CTREE_LINE_STYLE_DOTTED
       CTREE_LINE_STYLE_TABBED
       CTREE_LINE_STYLE_NONE);

@CTREE_POS = 
    qw(CTREE_POS_BEFORE
       CTREE_POS_AS_CHILD
       CTREE_POS_AFTER);

@CELL_TYPE = 
    qw(CELL_TYPE_EMPTY
       CELL_TYPE_TEXT
       CELL_TYPE_PIXMAP
       CELL_TYPE_PIXTEXT
       CELL_TYPE_WIDGET);

@CORNER_TYPE = 
    qw(CORNER_TYPE_TOP_LEFT
       CORNER_TYPE_BOTTOM_LEFT
       CORNER_TYPE_TOP_RIGHT
       CORNER_TYPE_BOTTOM_RIGHT);

@CURVE_TYPE = 
    qw(CURVE_TYPE_LINEAR
       CURVE_TYPE_SPLINE
       CURVE_TYPE_FREE);

@DIRECTION_TYPE = 
    qw(DIRECTION_TYPE_TAB_FORWARD
       DIRECTION_TYPE_TAB_BACKWARD
       DIRECTION_TYPE_UP
       DIRECTION_TYPE_DOWN
       DIRECTION_TYPE_LEFT
       DIRECTION_TYPE_RIGHT);

@FONT_FILTER_TYPE = 
    qw(FONT_FILTER_TYPE_BASE
       FONT_FILTER_TYPE_USER);

@FONT_METRIC_TYPE = 
    qw(FONT_METRIC_TYPE_PIXELS_METRIC
       FONT_METRIC_TYPE_POINTS_METRIC);

@FUNDAMENTAL_TYPE = 
    qw(FUNDAMENTAL_TYPE_INVALID
       FUNDAMENTAL_TYPE_NONE
       FUNDAMENTAL_TYPE_CHAR
       FUNDAMENTAL_TYPE_BOOL
       FUNDAMENTAL_TYPE_INT
       FUNDAMENTAL_TYPE_UINT
       FUNDAMENTAL_TYPE_LONG
       FUNDAMENTAL_TYPE_ULONG
       FUNDAMENTAL_TYPE_FLOAT
       FUNDAMENTAL_TYPE_STRING
       FUNDAMENTAL_TYPE_ENUM
       FUNDAMENTAL_TYPE_FLAGS
       FUNDAMENTAL_TYPE_BOXED
       FUNDAMENTAL_TYPE_FOREIGN
       FUNDAMENTAL_TYPE_CALLBACK
       FUNDAMENTAL_TYPE_ARGS
       FUNDAMENTAL_TYPE_PTR
       FUNDAMENTAL_TYPE_SIG
       FUNDAMENTAL_TYPE_C_CALLBACK
       FUNDAMENTAL_TYPE_OBJ);

@JUSTIFICATION = 
    qw(JUSTIFICATION_LEFT
       JUSTIFICATION_RIGHT
       JUSTIFICATION_CENTER
       JUSTIFICATION_FILL);

@MATCH_TYPE = 
    qw(MATCH_TYPE_ALL
       MATCH_TYPE_ALL_TAIL
       MATCH_TYPE_HEAD
       MATCH_TYPE_TAIL
       MATCH_TYPE_EXACT
       MATCH_TYPE_LAST);

@MENU_FACTORY_TYPE = 
    qw(MENU_FACTORY_TYPE_MENU
       MENU_FACTORY_TYPE_MENU_BAR
       MENU_FACTORY_TYPE_OPT_MENU);

@METRIC_TYPE = 
    qw(METRIC_TYPE_PIXELS
       METRIC_TYPE_INCHES
       METRIC_TYPE_CENTIMETERS);

@ORIENTATION = 
    qw(ORIENTATION_HORIZONTAL
       ORIENTATION_VERTICAL);

@PACK_TYPE = 
    qw(PACK_TYPE_START
       PACK_TYPE_END);

@PATH_PRIORITY_TYPE = 
    qw(PATH_PRIORITY_TYPE_LOWEST
       PATH_PRIORITY_TYPE_GTK
       PATH_PRIORITY_TYPE_APPLICATION
       PATH_PRIORITY_TYPE_RC
       PATH_PRIORITY_TYPE_HIGHEST
       PATH_PRIORITY_TYPE_MASK);

@PATH_TYPE = 
    qw(PATH_TYPE_WIDGET
       PATH_TYPE_WIDGET_CLASS
       PATH_TYPE_CLASS);

@POL_TYPE = 
    qw(POL_TYPE_ALWAYS
       POL_TYPE_NEVER
       POL_TYPE_AUTOMATIC);

@POSITION_TYPE = 
    qw(POSITION_TYPE_LEFT
       POSITION_TYPE_RIGHT
       POSITION_TYPE_TOP
       POSITION_TYPE_BOTTOM);

@PREVIEW_TYPE = 
    qw(PREVIEW_TYPE_COLOR
       PREVIEW_TYPE_GRAYSCALE);

@PROG_BAR_ORIENTATION = 
    qw(PROG_BAR_ORIENTATION_LEFT_TO_RIGHT
       PROG_BAR_ORIENTATION_RIGHT_TO_LEFT
       PROG_BAR_ORIENTATION_BOTTOM_TO_TOP
       PROG_BAR_ORIENTATION_TOP_TO_BOTTOM);

@PROG_BAR_STYLE = 
    qw(PROG_BAR_STYLE_CONTINUOUS
       PROG_BAR_STYLE_DISCRETE);

@RELIEF_STYLE = 
    qw(RELIEF_STYLE_NORMAL
       RELIEF_STYLE_HALF
       RELIEF_STYLE_NONE);

@RESIZE_MODE = 
    qw(RESIZE_MODE_PARENT
       RESIZE_MODE_QUEUE
       RESIZE_MODE_IMMEDIATE);

@SCROLL_TYPE = 
    qw(SCROLL_TYPE_NONE
       SCROLL_TYPE_STEP_BACKWARD
       SCROLL_TYPE_STEP_FORWARD
       SCROLL_TYPE_PAGE_BACKWARD
       SCROLL_TYPE_PAGE_FORWARD
       SCROLL_TYPE_JUMP);

@SELECTION_MODE = 
    qw(SELECTION_MODE_SINGLE
       SELECTION_MODE_BROWSE
       SELECTION_MODE_MULTIPLE
       SELECTION_MODE_EXTENDED);

@SHADOW_TYPE = 
    qw(SHADOW_TYPE_NONE
       SHADOW_TYPE_IN
       SHADOW_TYPE_OUT
       SHADOW_TYPE_ETCHED_IN
       SHADOW_TYPE_ETCHED_OUT);

@SIDE_TYPE = 
    qw(SIDE_TYPE_TOP
       SIDE_TYPE_BOTTOM
       SIDE_TYPE_LEFT
       SIDE_TYPE_RIGHT);

@SORT_TYPE = 
    qw(SORT_TYPE_ASCENDING
       SORT_TYPE_DESCENDING);

@STATE_TYPE = 
    qw(STATE_TYPE_NORMAL
       STATE_TYPE_ACTIVE
       STATE_TYPE_PRELIGHT
       STATE_TYPE_SELECTED
       STATE_TYPE_INSENSITIVE);

@SUBMENU_DIRECTION = 
    qw(SUBMENU_DIRECTION_LEFT
       SUBMENU_DIRECTION_RIGHT);

@SUBMENU_PLACEMENT = 
    qw(SUBMENU_PLACEMENT_TOP_BOTTOM
       SUBMENU_PLACEMENT_LEFT_RIGHT);

@TOOLBAR_CHILD_TYPE = 
    qw(TOOLBAR_CHILD_TYPE_SPACE
       TOOLBAR_CHILD_TYPE_BTN
       TOOLBAR_CHILD_TYPE_TOGGLE_BTN
       TOOLBAR_CHILD_TYPE_RADIO_BTN
       TOOLBAR_CHILD_TYPE_WIDGET);

@TOOLBAR_SPACE_STYLE = 
    qw(TOOLBAR_SPACE_STYLE_EMPTY
       TOOLBAR_SPACE_STYLE_LINE);

@TOOLBAR_STYLE = 
    qw(TOOLBAR_STYLE_ICONS
       TOOLBAR_STYLE_TEXT
       TOOLBAR_STYLE_BOTH);

@TREE_VIEW_MODE = 
    qw(TREE_VIEW_MODE_LINE
       TREE_VIEW_MODE_ITEM);

@TROUGH_TYPE = 
    qw(TROUGH_TYPE_NONE
       TROUGH_TYPE_START
       TROUGH_TYPE_END
       TROUGH_TYPE_JUMP);

@UPDATE_TYPE = 
    qw(UPDATE_TYPE_CONTINUOUS
       UPDATE_TYPE_DISCONTINUOUS
       UPDATE_TYPE_DELAYED);

@VISIBILITY = 
    qw(VISIBILITY_NONE
       VISIBILITY_PARTIAL
       VISIBILITY_FULL);

@WIN_POSITION = 
    qw(WIN_POSITION_NONE
       WIN_POSITION_CENTER
       WIN_POSITION_MOUSE);

@WIN_TYPE = 
    qw(WIN_TYPE_TOPLEVEL
       WIN_TYPE_DIALOG
       WIN_TYPE_POPUP);

@GDK_DRAG_ACTION = 
    qw(GDK_DRAG_ACTION_DEFAULT
       GDK_DRAG_ACTION_COPY
       GDK_DRAG_ACTION_MOVE
       GDK_DRAG_ACTION_LINK
       GDK_DRAG_ACTION_PRIVATE
       GDK_DRAG_ACTION_ASK);

@GDK_EV_MASK = 
    qw(GDK_EV_MASK_EXPOSURE_MASK
       GDK_EV_MASK_PTR_MOTION_MASK
       GDK_EV_MASK_PTR_MOTION_HINT_MASK
       GDK_EV_MASK_BTN_MOTION_MASK
       GDK_EV_MASK_BTN1_MOTION_MASK
       GDK_EV_MASK_BTN2_MOTION_MASK
       GDK_EV_MASK_BTN3_MOTION_MASK
       GDK_EV_MASK_BTN_PRESS_MASK
       GDK_EV_MASK_BTN_RELEASE_MASK
       GDK_EV_MASK_KEY_PRESS_MASK
       GDK_EV_MASK_KEY_RELEASE_MASK
       GDK_EV_MASK_ENTER_NOTIFY_MASK
       GDK_EV_MASK_LEAVE_NOTIFY_MASK
       GDK_EV_MASK_FOCUS_CHANGE_MASK
       GDK_EV_MASK_STRUCTURE_MASK
       GDK_EV_MASK_ALL_EVS_MASK);

@GDK_GCVALUES_MASK = 
    qw(GDK_GCVALUES_MASK_FOREGROUND
       GDK_GCVALUES_MASK_BACKGROUND
       GDK_GCVALUES_MASK_FONT
       GDK_GCVALUES_MASK_FUNC
       GDK_GCVALUES_MASK_FILL
       GDK_GCVALUES_MASK_TILE
       GDK_GCVALUES_MASK_STIPPLE
       GDK_GCVALUES_MASK_CLIP_MASK
       GDK_GCVALUES_MASK_SUBWIN
       GDK_GCVALUES_MASK_TS_X_ORIGIN
       GDK_GCVALUES_MASK_TS_Y_ORIGIN
       GDK_GCVALUES_MASK_CLIP_X_ORIGIN
       GDK_GCVALUES_MASK_CLIP_Y_ORIGIN
       GDK_GCVALUES_MASK_EXPOSURES
       GDK_GCVALUES_MASK_LINE_WIDTH
       GDK_GCVALUES_MASK_LINE_STYLE
       GDK_GCVALUES_MASK_CAP_STYLE
       GDK_GCVALUES_MASK_JOIN_STYLE);

@GDK_INPUT_CONDITION = 
    qw(GDK_INPUT_CONDITION_READ
       GDK_INPUT_CONDITION_WRITE
       GDK_INPUT_CONDITION_EXCEPTION);

@GDK_MOD_TYPE = 
    qw(GDK_MOD_TYPE_SHIFT_MASK
       GDK_MOD_TYPE_LOCK_MASK
       GDK_MOD_TYPE_CONTROL_MASK
       GDK_MOD_TYPE_MOD1_MASK
       GDK_MOD_TYPE_MOD2_MASK
       GDK_MOD_TYPE_MOD3_MASK
       GDK_MOD_TYPE_MOD4_MASK
       GDK_MOD_TYPE_MOD5_MASK
       GDK_MOD_TYPE_BTN1_MASK
       GDK_MOD_TYPE_BTN2_MASK
       GDK_MOD_TYPE_BTN3_MASK
       GDK_MOD_TYPE_BTN4_MASK
       GDK_MOD_TYPE_BTN5_MASK);

@GDK_WMDEC = 
    qw(GDK_WMDEC_ALL
       GDK_WMDEC_BORDER
       GDK_WMDEC_RESIZEH
       GDK_WMDEC_TITLE
       GDK_WMDEC_MENU
       GDK_WMDEC_MINIMIZE
       GDK_WMDEC_MAXIMIZE);

@GDK_WMFUNC = 
    qw(GDK_WMFUNC_ALL
       GDK_WMFUNC_RESIZE
       GDK_WMFUNC_MOVE
       GDK_WMFUNC_MINIMIZE
       GDK_WMFUNC_MAXIMIZE
       GDK_WMFUNC_CLOSE);

@GDK_WIN_ATTRS_TYPE = 
    qw(GDK_WIN_ATTRS_TYPE_TITLE
       GDK_WIN_ATTRS_TYPE_X
       GDK_WIN_ATTRS_TYPE_Y
       GDK_WIN_ATTRS_TYPE_CURSOR
       GDK_WIN_ATTRS_TYPE_COLORMAP
       GDK_WIN_ATTRS_TYPE_VISUAL);

@GDK_WIN_HINTS = 
    qw(GDK_WIN_HINTS_POS
       GDK_WIN_HINTS_MIN_SIZE
       GDK_WIN_HINTS_MAX_SIZE
       GDK_WIN_HINTS_BASE_SIZE
       GDK_WIN_HINTS_ASPECT
       GDK_WIN_HINTS_RESIZE_INC);

@ACCEL_FLAGS = 
    qw(ACCEL_FLAGS_VISIBLE
       ACCEL_FLAGS_SIG_VISIBLE
       ACCEL_FLAGS_LOCKED
       ACCEL_FLAGS_MASK);

@ARG_FLAGS = 
    qw(ARG_FLAGS_READABLE
       ARG_FLAGS_WRITABLE
       ARG_FLAGS_CONSTRUCT
       ARG_FLAGS_CONSTRUCT_ONLY
       ARG_FLAGS_CHILD_ARG);

@ATTACH_OPTS = 
    qw(ATTACH_OPTS_EXPAND
       ATTACH_OPTS_SHRINK
       ATTACH_OPTS_FILL);

@BTN_ACTION = 
    qw(BTN_ACTION_IGNORED
       BTN_ACTION_SELECTS
       BTN_ACTION_DRAGS
       BTN_ACTION_EXPANDS);

@CAL_DISP_OPTS = 
    qw(CAL_DISP_OPTS_SHOW_HEADING
       CAL_DISP_OPTS_SHOW_DAY_NAMES
       CAL_DISP_OPTS_NO_MONTH_CHANGE
       CAL_DISP_OPTS_SHOW_WEEKS_NUMBERS
       CAL_DISP_OPTS_WEEK_START_MONDAY);

@DEBUG_FLAG = 
    qw(DEBUG_FLAG_OBJS
       DEBUG_FLAG_MISC
       DEBUG_FLAG_SIGS);

@DEST_DEFAULTS = 
    qw(DEST_DEFAULTS_MOTION
       DEST_DEFAULTS_HIGHLIGHT
       DEST_DEFAULTS_DROP
       DEST_DEFAULTS_ALL);

@FONT_TYPE = 
    qw(FONT_TYPE_BITMAP
       FONT_TYPE_SCALABLE
       FONT_TYPE_SCALABLE_BITMAP
       FONT_TYPE_ALL);

@OBJ_FLAGS = 
    qw(OBJ_FLAGS_DESTROYED
       OBJ_FLAGS_FLOATING
       OBJ_FLAGS_CONNECTED);

@PACKER_OPTS = 
    qw(PACKER_OPTS_PACK_EXPAND
       PACKER_OPTS_FILL_X
       PACKER_OPTS_FILL_Y);

@SIG_RUN_TYPE = 
    qw(SIG_RUN_TYPE_FIRST
       SIG_RUN_TYPE_LAST
       SIG_RUN_TYPE_BOTH
       SIG_RUN_TYPE_NO_RECURSE
       SIG_RUN_TYPE_ACTION);

@SPIN_BTN_UPDATE_POL = 
    qw(SPIN_BTN_UPDATE_POL_ALWAYS
       SPIN_BTN_UPDATE_POL_IF_VALID);

@TARGET_FLAGS = 
  qw(TARGET_FLAGS_SAME_APP
     TARGET_FLAGS_SAME_WIDGET);

@SIG_INPUTDIALOG =
  qw(
     INPUTDIALOG_ENABLE_DEVICE
     INPUTDIALOG_DISABLE_DEVICE
    );

@SIG_NOTEBOOK = 
  qw(
     NOTEBOOK_SWITCH_PAGE
    );

@SIG_CHECKMENUITEM = 
  qw(
     CHECKMENUITEM_TOGGLED
    );

@SIG_CONTAINER = 
  qw(
     CONTAINER_ADD
     CONTAINER_REMOVE
     CONTAINER_CHECK_RESIZE
     CONTAINER_SET_FOCUS_CHILD
    );

@SIG_WIDGET = 
  qw(
     WIDGET_SHOW
     WIDGET_HIDE
     WIDGET_MAP
     WIDGET_UNMAP
     WIDGET_REALIZE
     WIDGET_UNREALIZE
     WIDGET_DRAW
     WIDGET_DRAW_FOCUS
     WIDGET_DRAW_DEFAULT
     WIDGET_SIZE_REQUEST
     WIDGET_SIZE_ALLOCATE
     WIDGET_STATE_CHANGED
     WIDGET_PARENT_SET
     WIDGET_STYLE_SET
     WIDGET_ADD_ACCELERATOR
     WIDGET_REMOVE_ACCELERATOR
     WIDGET_SELECTION_GET
     WIDGET_SELECTION_RECEIVED
     WIDGET_DRAG_BEGIN
     WIDGET_DRAG_END
     WIDGET_DRAG_DATA_DELETE
     WIDGET_DRAG_LEAVE
     WIDGET_DRAG_DATA_GET
     WIDGET_DRAG_DATA_RECEIVED
     WIDGET_DEBUG_MSG
    );

@SIG_MENUITEM = 
  qw(
     MENUITEM_ACTIVATE
     MENUITEM_ACTIVATE_ITEM
    );

@SIG_CURVE = 
  qw(
     CURVE_CURVE_TYPE_CHANGED
    );

@SIG_COLORSELECTION = 
  qw(
     COLORSELECTION_COLOR_CHANGED
    );

@SIG_LISTITEM = 
  qw(
     LISTITEM_TOGGLE_FOCUS_ROW
     LISTITEM_SELECT_ALL
     LISTITEM_UNSELECT_ALL
     LISTITEM_UNDO_SELECTION
     LISTITEM_START_SELECTION
     LISTITEM_END_SELECTION
     LISTITEM_TOGGLE_ADD_MODE
     LISTITEM_EXTEND_SELECTION
     LISTITEM_SCROLL_VERTICAL
     LISTITEM_SCROLL_HORIZONTAL
    );

@SIG_MENUSHELL = 
  qw(
     MENUSHELL_DEACTIVATE
     MENUSHELL_SELECTION_DONE
     MENUSHELL_MOVE_CURRENT
     MENUSHELL_ACTIVATE_CURRENT
     MENUSHELL_CANCEL
    );

@SIG_ITEM = 
  qw(
     ITEM_SELECT
     ITEM_DESELECT
     ITEM_TOGGLE
    );

@SIG_TREE = 
  qw(
     TREE_SELECTION_CHANGED
     TREE_SELECT_CHILD
     TREE_UNSELECT_CHILD
    );

@SIG_TOOLBAR = 
  qw(
     TOOLBAR_ORIENTATION_CHANGED
     TOOLBAR_STYLE_CHANGED
    );

@SIG_CTREE = 
  qw(
     CTREE_TREE_SELECT_ROW
     CTREE_TREE_UNSELECT_ROW
     CTREE_TREE_EXPAND
     CTREE_TREE_COLLAPSE
     CTREE_TREE_MOVE
     CTREE_CHANGE_FOCUS_ROW_EXPANSION
    );

@SIG_HANDLEBOX = 
  qw(
     HANDLEBOX_CHILD_ATTACHED
     HANDLEBOX_CHILD_DETACHED
    );

@SIG_TIPSQUERY = 
  qw(
     TIPSQUERY_START_QUERY
     TIPSQUERY_STOP_QUERY
     TIPSQUERY_WIDGET_ENTERED
    );

@SIG_WINDOW = 
  qw(
     WINDOW_SET_FOCUS
    );

@SIG_STATUSBAR = 
  qw(
     STATUSBAR_TEXT_PUSHED
     STATUSBAR_TEXT_POPPED
    );

@SIG_EDITABLE = 
  qw(
     EDITABLE_CHANGED
     EDITABLE_INSERT_TEXT
     EDITABLE_DELETE_TEXT
     EDITABLE_ACTIVATE
     EDITABLE_SET_EDITABLE
     EDITABLE_MOVE_CURSOR
     EDITABLE_MOVE_WORD
     EDITABLE_MOVE_PAGE
     EDITABLE_MOVE_TO_ROW
     EDITABLE_MOVE_TO_COLUMN
     EDITABLE_KILL_CHAR
     EDITABLE_KILL_WORD
     EDITABLE_KILL_LINE
     EDITABLE_CUT_CLIPBOARD
     EDITABLE_COPY_CLIPBOARD
     EDITABLE_PASTE_CLIPBOARD
    );

@SIG_DATA = 
  qw(
     DATA_DISCONNECT
    );

@SIG_CALENDAR = 
  qw(
     CALENDAR_MONTH_CHANGED
     CALENDAR_DAY_SELECTED
     CALENDAR_DAY_SELECTED_DOUBLE_CLICK
     CALENDAR_PREV_MONTH
     CALENDAR_NEXT_MONTH
     CALENDAR_PREV_YEAR
     CALENDAR_NEXT_YEAR
    );

@SIG_BUTTON = 
  qw(
     BUTTON_PRESSED
     BUTTON_RELEASED
     BUTTON_CLICKED
     BUTTON_ENTER
     BUTTON_LEAVE
    );

@SIG_LIST = 
  qw(
     LIST_SELECTION_CHANGED
     LIST_SELECT_CHILD
     LIST_UNSELECT_CHILD
    );

@SIG_TOGGLEBUTTON = 
  qw(
     TOGGLEBUTTON_TOGGLED
    );

@SIG_TREEITEM = 
  qw(
     TREEITEM_COLLAPSE
     TREEITEM_EXPAND
    );

@SIG_CLIST = 
  qw(
     CLIST_SELECT_ROW
     CLIST_UNSELECT_ROW
     CLIST_ROW_MOVE
     CLIST_CLICK_COLUMN
     CLIST_RESIZE_COLUMN
     CLIST_TOGGLE_FOCUS_ROW
     CLIST_SELECT_ALL
     CLIST_UNSELECT_ALL
     CLIST_UNDO_SELECTION
     CLIST_START_SELECTION
     CLIST_END_SELECTION
     CLIST_TOGGLE_ADD_MODE
     CLIST_EXTEND_SELECTION
     CLIST_SCROLL_VERTICAL
     CLIST_SCROLL_HORIZONTAL
     CLIST_ABORT_COLUMN_RESIZE
    );

@SIG_ADJUSTMENT = 
  qw(
     ADJUSTMENT_CHANGED
     ADJUSTMENT_VALUE_CHANGED
    );


@ENUM =
  (
   @GDK_AXIS_USE,
   @GDK_BYTE_ORDER,
   @GDK_CAP_STYLE,
   @GDK_CROSSING_MODE,
   @GDK_CURSOR_TYPE,
   @GDK_DRAG_PROTO,
   @GDK_EV_TYPE,
   @GDK_EXT_MODE,
   @GDK_FILL,
   @GDK_FILL_RULE,
   @GDK_FUNC,
   @GDK_IMG_TYPE,
   @GDK_INPUT_MODE,
   @GDK_INPUT_SRC,
   @GDK_JOIN_STYLE,
   @GDK_LINE_STYLE,
   @GDK_NOTIFY_TYPE,
   @GDK_OVERLAP_TYPE,
   @GDK_PROP_MODE,
   @GDK_PROPERTY_STATE,
   @GDK_RGB_DITHER,
   @GDK_SELECTION,
   @GDK_STATUS,
   @GDK_SUBWIN_MODE,
   @GDK_VISIBILITY_STATE,
   @GDK_VISUAL_TYPE,
   @GDK_WIN_CLASS,
   @GDK_WIN_TYPE,
   @ANCHOR_TYPE,
   @ARROW_TYPE,
   @BTN_BOX_STYLE,
   @CLIST_DRAG_POS,
   @CTREE_EXPANDER_STYLE,
   @CTREE_EXP_TYPE,
   @CTREE_LINE_STYLE,
   @CTREE_POS,
   @CELL_TYPE,
   @CORNER_TYPE,
   @CURVE_TYPE,
   @DIRECTION_TYPE,
   @FONT_FILTER_TYPE,
   @FONT_METRIC_TYPE,
   @FUNDAMENTAL_TYPE,
   @JUSTIFICATION,
   @MATCH_TYPE,
   @MENU_FACTORY_TYPE,
   @METRIC_TYPE,
   @ORIENTATION,
   @PACK_TYPE,
   @PATH_PRIORITY_TYPE,
   @PATH_TYPE,
   @POL_TYPE,
   @POSITION_TYPE,
   @PREVIEW_TYPE,
   @PROG_BAR_ORIENTATION,
   @PROG_BAR_STYLE,
   @RELIEF_STYLE,
   @RESIZE_MODE,
   @SCROLL_TYPE,
   @SELECTION_MODE,
   @SHADOW_TYPE,
   @SIDE_TYPE,
   @SORT_TYPE,
   @STATE_TYPE,
   @SUBMENU_DIRECTION,
   @SUBMENU_PLACEMENT,
   @TOOLBAR_CHILD_TYPE,
   @TOOLBAR_SPACE_STYLE,
   @TOOLBAR_STYLE,
   @TREE_VIEW_MODE,
   @TROUGH_TYPE,
   @UPDATE_TYPE,
   @VISIBILITY,
   @WIN_POSITION,
   @WIN_TYPE
  );

@FLAG =
  (
   @GDK_DRAG_ACTION,
   @GDK_EV_MASK,
   @GDK_GCVALUES_MASK,
   @GDK_INPUT_CONDITION,
   @GDK_MOD_TYPE,
   @GDK_WMDEC,
   @GDK_WMFUNC,
   @GDK_WIN_ATTRS_TYPE,
   @GDK_WIN_HINTS,
   @ACCEL_FLAGS,
   @ARG_FLAGS,
   @ATTACH_OPTS,
   @BTN_ACTION,
   @CAL_DISP_OPTS,
   @DEBUG_FLAG,
   @DEST_DEFAULTS,
   @FONT_TYPE,
   @OBJ_FLAGS,
   @PACKER_OPTS,
   @SIG_RUN_TYPE,
   @SPIN_BTN_UPDATE_POL,
   @TARGET_FLAGS
  );

@FUNC =
  qw(GTK__TRUE
     GTK__FALSE
     GTK__MAIN_QUIT
    );

@SIGNAL =
  (
   @SIG_INPUTDIALOG,
   @SIG_NOTEBOOK,
   @SIG_CHECKMENUITEM,
   @SIG_CONTAINER,
   @SIG_WIDGET,
   @SIG_MENUITEM,
   @SIG_CURVE,
   @SIG_COLORSELECTION,
   @SIG_LISTITEM,
   @SIG_MENUSHELL,
   @SIG_ITEM,
   @SIG_TREE,
   @SIG_TOOLBAR,
   @SIG_CTREE,
   @SIG_HANDLEBOX,
   @SIG_TIPSQUERY,
   @SIG_WINDOW,
   @SIG_STATUSBAR,
   @SIG_EDITABLE,
   @SIG_DATA,
   @SIG_CALENDAR,
   @SIG_BUTTON,
   @SIG_LIST,
   @SIG_TOGGLEBUTTON,
   @SIG_TREEITEM,
   @SIG_CLIST,
   @SIG_ADJUSTMENT
  );

@SYM = qw(NULL);

@ISA       = qw(Exporter);
@EXPORT    = ();
@EXPORT_OK = (@FLAG, @ENUM, @FUNC, @SYM, @SIGNAL);

%EXPORT_TAGS =
  (
   ALL                  => [ @EXPORT, @EXPORT_OK ],
   sym                  => \ @SYM,
   func                 => \ @FUNC,
   flags                => \ @FLAG,
   enums                => \ @ENUM,
   signals              => \ @SIGNAL,
   gdk_axis_use         => \ @GDK_AXIS_USE,
   gdk_byte_order       => \ @GDK_BYTE_ORDER,
   gdk_cap_style        => \ @GDK_CAP_STYLE,
   gdk_crossing_mode    => \ @GDK_CROSSING_MODE,
   gdk_cursor_type      => \ @GDK_CURSOR_TYPE,
   gdk_drag_proto       => \ @GDK_DRAG_PROTO,
   gdk_ev_type          => \ @GDK_EV_TYPE,
   gdk_ext_mode         => \ @GDK_EXT_MODE,
   gdk_fill             => \ @GDK_FILL,
   gdk_fill_rule        => \ @GDK_FILL_RULE,
   gdk_func             => \ @GDK_FUNC,
   gdk_img_type         => \ @GDK_IMG_TYPE,
   gdk_input_mode       => \ @GDK_INPUT_MODE,
   gdk_input_src        => \ @GDK_INPUT_SRC,
   gdk_join_style       => \ @GDK_JOIN_STYLE,
   gdk_line_style       => \ @GDK_LINE_STYLE,
   gdk_notify_type      => \ @GDK_NOTIFY_TYPE,
   gdk_overlap_type     => \ @GDK_OVERLAP_TYPE,
   gdk_prop_mode        => \ @GDK_PROP_MODE,
   gdk_property_state   => \ @GDK_PROPERTY_STATE,
   gdk_rgb_dither       => \ @GDK_RGB_DITHER,
   gdk_selection        => \ @GDK_SELECTION,
   gdk_status           => \ @GDK_STATUS,
   gdk_subwin_mode      => \ @GDK_SUBWIN_MODE,
   gdk_visibility_state => \ @GDK_VISIBILITY_STATE,
   gdk_visual_type      => \ @GDK_VISUAL_TYPE,
   gdk_win_class        => \ @GDK_WIN_CLASS,
   gdk_win_type         => \ @GDK_WIN_TYPE,
   anchor_type          => \ @ANCHOR_TYPE,
   arrow_type           => \ @ARROW_TYPE,
   btn_box_style        => \ @BTN_BOX_STYLE,
   clist_drag_pos       => \ @CLIST_DRAG_POS,
   ctree_expander_style => \ @CTREE_EXPANDER_STYLE,
   ctree_exp_type       => \ @CTREE_EXP_TYPE,
   ctree_line_style     => \ @CTREE_LINE_STYLE,
   ctree_pos            => \ @CTREE_POS,
   cell_type            => \ @CELL_TYPE,
   corner_type          => \ @CORNER_TYPE,
   curve_type           => \ @CURVE_TYPE,
   direction_type       => \ @DIRECTION_TYPE,
   font_filter_type     => \ @FONT_FILTER_TYPE,
   font_metric_type     => \ @FONT_METRIC_TYPE,
   fundamental_type     => \ @FUNDAMENTAL_TYPE,
   justification        => \ @JUSTIFICATION,
   match_type           => \ @MATCH_TYPE,
   menu_factory_type    => \ @MENU_FACTORY_TYPE,
   metric_type          => \ @METRIC_TYPE,
   orientation          => \ @ORIENTATION,
   pack_type            => \ @PACK_TYPE,
   path_priority_type   => \ @PATH_PRIORITY_TYPE,
   path_type            => \ @PATH_TYPE,
   pol_type             => \ @POL_TYPE,
   position_type        => \ @POSITION_TYPE,
   preview_type         => \ @PREVIEW_TYPE,
   prog_bar_orientation => \ @PROG_BAR_ORIENTATION,
   prog_bar_style       => \ @PROG_BAR_STYLE,
   relief_style         => \ @RELIEF_STYLE,
   resize_mode          => \ @RESIZE_MODE,
   scroll_type          => \ @SCROLL_TYPE,
   selection_mode       => \ @SELECTION_MODE,
   shadow_type          => \ @SHADOW_TYPE,
   side_type            => \ @SIDE_TYPE,
   sort_type            => \ @SORT_TYPE,
   state_type           => \ @STATE_TYPE,
   submenu_direction    => \ @SUBMENU_DIRECTION,
   submenu_placement    => \ @SUBMENU_PLACEMENT,
   toolbar_child_type   => \ @TOOLBAR_CHILD_TYPE,
   toolbar_space_style  => \ @TOOLBAR_SPACE_STYLE,
   toolbar_style        => \ @TOOLBAR_STYLE,
   tree_view_mode       => \ @TREE_VIEW_MODE,
   trough_type          => \ @TROUGH_TYPE,
   update_type          => \ @UPDATE_TYPE,
   visibility           => \ @VISIBILITY,
   win_position         => \ @WIN_POSITION,
   win_type             => \ @WIN_TYPE,
   gdk_drag_action      => \ @GDK_DRAG_ACTION,
   gdk_ev_mask          => \ @GDK_EV_MASK,
   gdk_gcvalues_mask    => \ @GDK_GCVALUES_MASK,
   gdk_input_condition  => \ @GDK_INPUT_CONDITION,
   gdk_mod_type         => \ @GDK_MOD_TYPE,
   gdk_wmdec            => \ @GDK_WMDEC,
   gdk_wmfunc           => \ @GDK_WMFUNC,
   gdk_win_attrs_type   => \ @GDK_WIN_ATTRS_TYPE,
   gdk_win_hints        => \ @GDK_WIN_HINTS,
   accel_flags          => \ @ACCEL_FLAGS,
   arg_flags            => \ @ARG_FLAGS,
   attach_opts          => \ @ATTACH_OPTS,
   btn_action           => \ @BTN_ACTION,
   cal_disp_opts        => \ @CAL_DISP_OPTS,
   debug_flag           => \ @DEBUG_FLAG,
   dest_defaults        => \ @DEST_DEFAULTS,
   font_type            => \ @FONT_TYPE,
   obj_flags            => \ @OBJ_FLAGS,
   packer_opts          => \ @PACKER_OPTS,
   sig_run_type         => \ @SIG_RUN_TYPE,
   spin_btn_update_pol  => \ @SPIN_BTN_UPDATE_POL,
   target_flags         => \ @TARGET_FLAGS,
   sig_inputdialog      => \ @SIG_INPUTDIALOG,
   sig_notebook         => \ @SIG_NOTEBOOK,
   sig_checkmenuitem    => \ @SIG_CHECKMENUITEM,
   sig_container        => \ @SIG_CONTAINER,
   sig_widget           => \ @SIG_WIDGET,
   sig_menuitem         => \ @SIG_MENUITEM,
   sig_curve            => \ @SIG_CURVE,
   sig_colorselection   => \ @SIG_COLORSELECTION,
   sig_listitem         => \ @SIG_LISTITEM,
   sig_menushell        => \ @SIG_MENUSHELL,
   sig_item             => \ @SIG_ITEM,
   sig_tree             => \ @SIG_TREE,
   sig_toolbar          => \ @SIG_TOOLBAR,
   sig_ctree            => \ @SIG_CTREE,
   sig_handlebox        => \ @SIG_HANDLEBOX,
   sig_tipsquery        => \ @SIG_TIPSQUERY,
   sig_window           => \ @SIG_WINDOW,
   sig_statusbar        => \ @SIG_STATUSBAR,
   sig_editable         => \ @SIG_EDITABLE,
   sig_data             => \ @SIG_DATA,
   sig_calendar         => \ @SIG_CALENDAR,
   sig_button           => \ @SIG_BUTTON,
   sig_list             => \ @SIG_LIST,
   sig_togglebutton     => \ @SIG_TOGGLEBUTTON,
   sig_treeitem         => \ @SIG_TREEITEM,
   sig_clist            => \ @SIG_CLIST,
   sig_adjustment       => \ @SIG_ADJUSTMENT
  );

$VERSION = 0.01_04;

__END__

perl -n -e '/=head2\s+Gtk::(\S+)/ ? ($s = $1, $s =~ s/::/_/g, $s =~ s/([a-z])([A-Z])/$1_$2/g, $s = uc($s), printf(STDOUT "#=$s\n")) : /=item\s+\*\s+(\S+)/ ? ($l = uc($1), $v = $1, $l =~ s/\W/_/g, printf(STDOUT "use constant %s_%s => \x27%s\x27;\n", $s, $l, $v)): undef(); ' perl-gtk-ds.pod | perl -p -e 's/CALENDAR/CAL/g; s/DISPLAY/DISP/g; s/OPTION/OPT/g; s/ATTRIBUTE/ATTR/g; s/MODIFIER/MOD/g; s/PROTOCOL/PROTO/g; s/EXTENSION/EXT/g; s/DECORATION/DEC/g; s/OBJECT/OBJ/g; s/FUNCTION/FUNC/g; s/SIGNAL/SIG/g; s/WINDOW/WIN/g; s/EVENT/EV/g; s/IMAGE/IMG/g; s/SOURCE/SRC/g; s/POLICY/POL/g; s/POINTER/PTR/g; s/EXPANSION_TYPE/EXP_TYPE/; s/PROGRESS/PROG/g' > ~/src/gtk/gtk_util.pm

perl -n -e '/#=(\w+)\s/ && print(STDOUT " " x 12,"\@$1\n");'

perl -n -e '/#=(\w+)\s/ ? (push(@A,$1), $A = $1, $X{$A} ||= []) : /use constant (\w+)\s/ ? push(@{$X{$A}}, $1) : undef(); END { foreach $A (@A) { print(STDOUT "\@$A = \n    qw(",join("\n       ",@{$X{$A}}),");\n\n")} }'
