/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * bookmark.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: bookmark.c,v 1.4 2003/12/28 09:27:43 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <gnome.h>

#include "gtkcellrenderertextx.h"
#include "main.h"
#include "misc_gtk.h"
#include "bookmark.h"
#include "gui_layout.h"
#include "gui_define.h"
#include "macro.h"
#include "init_fnc.h"
#include "gtk_helper.h"

/***************************************************************************************************/
/* Create a string which can be used as a value in gnome_config_set_string from the 3 given string */
/***************************************************************************************************/
/* the 3 strings are joined with a '|' inserted between them. */
/**************************************************************/
static GString *array_bookmark_to_gnome_bookmark_string(char *hubname, char *hub_description, char *hub_address, char *profile_name_to_use, char *flags)
{
	GString *str;
	str=g_string_new("");

	if(hubname!=NULL)
	{
		str=g_string_append(str,hubname);
	}
	str=g_string_append_c(str,'|');
	if(hub_description!=NULL)
	{
		str=g_string_append(str,hub_description);
	}
	str=g_string_append_c(str,'|');
	if(hub_address!=NULL)
	{
		str=g_string_append(str,hub_address);
	}
	str=g_string_append_c(str,'|');
	if(profile_name_to_use!=NULL)
	{
		str=g_string_append(str,profile_name_to_use);
	}
	str=g_string_append_c(str,'|');
	if(flags!=NULL)
	{
		str=g_string_append(str,flags);
	}

	return str;
}

/********************************************/
/* Opposition operation of the previous one */
/**************************************************************/
/* the first 3 strings are mandatory, the others are optional */
/**************************************************************/
static void gnome_bookmark_string_to_array_bookmark(char *gnome_config_string, char **hubname, char **hub_description, char **hub_address, char **profile_name_to_use, char **flags)
{
	gchar **ar;

	ar=g_strsplit(gnome_config_string,"|",0);
	if((ar!=NULL)&&(ar[0]!=NULL)&&(ar[1]!=NULL)&&(ar[2]!=NULL))
	{
		*hubname=strdup(ar[0]);
		*hub_description=strdup(ar[1]);
		*hub_address=strdup(ar[2]);

		*profile_name_to_use=strdup(ar[3]!=NULL ? ar[3] : "");
		*flags=strdup(ar[4]!=NULL ? ar[4] : "");
	}
	else
	{
		*hubname=NULL;
		*hub_description=NULL;
		*hub_address=NULL;
		*profile_name_to_use=NULL;
		*flags=NULL;
	}

	g_strfreev(ar);
	return;
}


/**************************************************************/
/* colorize entry of favorite clist existing in running clist */
/**************************************************************/
void colorize_favorite(GtkTreeModel *fav_gtm, int fav_addr_col, GtkTreeModel *other_gtm, int other_addr_col)
{
	GtkTreeIter iter;
	gboolean valid;
	GtkListStore *gls;

	gls=GTK_LIST_STORE(fav_gtm);

	valid=gtk_tree_model_get_iter_first(fav_gtm,&iter);
	while(valid)
	{
		gchar *fav_ip;
		GtkTreeIter dummy;

		gtk_tree_model_get(fav_gtm,&iter,fav_addr_col,&fav_ip,-1);
		if(get_iter_from_string(other_gtm,other_addr_col,fav_ip,&dummy)==TRUE)
		{
			gtk_list_store_set(gls,&iter,FHC_LINE_BACKGROUND,"green",-1);
		}
		else
		{
			gtk_list_store_set(gls,&iter,FHC_LINE_BACKGROUND,NULL,-1);
		}
		g_free(fav_ip);
		valid=gtk_tree_model_iter_next(fav_gtm,&iter);
	}

}

/********************************************************************/
/* this function reloads the bookmark into the 'hub_favorite_clist' */
/*************************************************************************************/
/* NOTE: each clist row data is the bookmark entry number (in the gnome config file) */
/*************************************************************************************/
void reload_bookmark(void)
{
	GtkWidget *w;
	GtkListStore *gls;
	GtkTreeModel *gtm;
	int nb_entry;
	SORT_VARS( )
	
	w=get_widget_by_widget_name(main_window,"hub_favorite_clist");
	if(w==NULL)
		return;

	gls=GTK_LIST_STORE(gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w)));

	gtk_list_store_clear(gls);

	nb_entry=gnome_config_get_int_with_default("/" PROGNAME "/Bookmark_v1/next_key",0);
	
	if(nb_entry!=0)
	{
		int i,j;
		GString *str;
		char *pval;
		GtkTreeIter iter;

		SORT_SAVE_GLS_TO_UNSORTED(,gls,gls)
		str=g_string_new("");

		for(i=0;i<nb_entry;i++)
		{
			str=g_string_assign(str,"/" PROGNAME "/Bookmark_v1/");
			g_string_sprintfa(str,"%d",i);

			pval=gnome_config_get_string(str->str);
			if(pval!=NULL)
			{
				char *entry_list[5];

				gnome_bookmark_string_to_array_bookmark(pval, &(entry_list[0]), &(entry_list[1]), &(entry_list[2]), &(entry_list[3]), &(entry_list[4]));
				if(entry_list[0]!=NULL)
				{
					if(entry_list[3]==NULL)
						entry_list[3]=strdup("");
					if(entry_list[4]==NULL)
						entry_list[4]=strdup("");

					gtk_list_store_append(gls,&iter);
					if(utf8_mode==TRUE)
					{
						gtk_list_store_set(gls,&iter,FHC_HUB_NAME_COL,entry_list[0],
														FHC_DESC_COL,entry_list[1],
														FHC_HUB_ADDR_COL,entry_list[2],
														FHC_PROFILE,entry_list[3],
														FHC_FLAGS,entry_list[4],
														FHC_MARK_NUM,(int)i,
														FHC_LINE_BACKGROUND,NULL,
														-1);
					}
					else
					{
						gchar *utf8_e0, *utf8_e1;

						utf8_e0=g_locale_to_utf8(entry_list[0],-1,NULL,NULL,NULL);
						utf8_e1=g_locale_to_utf8(entry_list[1],-1,NULL,NULL,NULL);
						gtk_list_store_set(gls,&iter,FHC_HUB_NAME_COL,utf8_e0,
														FHC_DESC_COL,utf8_e1,
														FHC_HUB_ADDR_COL,entry_list[2],
														FHC_PROFILE,entry_list[3],
														FHC_FLAGS,entry_list[4],
														FHC_MARK_NUM,(int)i,
														FHC_LINE_BACKGROUND,NULL,
														-1);
						g_free(utf8_e0);
						g_free(utf8_e1);
					}
					for(j=0;j<5;j++)
						free(entry_list[j]);
				}
			}
		}
		g_string_free(str,TRUE);
		SORT_RESTORE(,gls)
	}

	colorize_favorite(gtm,
							FHC_HUB_ADDR_COL,
							gtk_tree_view_get_model(GTK_TREE_VIEW(get_widget_by_widget_name(main_window,"running_hub_clist"))),
							RHC_HUB_ADDR_COL);
}

/******************************************/
/* add/update a new entry to the bookmark */
/*****************************************************************************/
/* if id_to_use==-1, the function uses a free id, else, the given id is used */
/*****************************************************************************/
void add_entry_to_bookmark(int id_to_use,char *name,char *description, char *address, char *profilename, char *flags, int no_reload)
{
	int my_id;
	GString *str,*val;

	str=g_string_new("/" PROGNAME "/Bookmark_v1/");
	if(id_to_use==-1)
	{
		my_id=gnome_config_get_int_with_default("/" PROGNAME "/Bookmark_v1/next_key",0);
	}
	else
	{
		my_id=id_to_use;
	}
	g_string_sprintfa(str,"%d",my_id);
	val=array_bookmark_to_gnome_bookmark_string(name, description, address, profilename, flags);
	gnome_config_set_string(str->str,val->str);
	g_string_free(str,TRUE);
	g_string_free(val,TRUE);
	if(id_to_use==-1)
	{	/* update the next id if we have used a new one */
		my_id++;
		gnome_config_set_int("/" PROGNAME "/Bookmark_v1/next_key",my_id);
	}
	
	gnome_config_sync ();

	if(no_reload!=1)
		reload_bookmark();
}

/*********************************************************/
/* search if the searched_flag is inside the flag_string */
/*********************************************************/
/* output: 1=yes, 0=no */
/***********************/
int flag_is_set(char *flag_string,char *searched_flag)
{
	int lstr=strlen(flag_string);
	int lwanted=strlen(searched_flag);
	int i;

	lstr-=lwanted;
	
	for(i=0;i<=lstr;i++)
	{
		if(!strncmp(flag_string+i,searched_flag,lwanted))
		{
			/* we may have found our flag */
			if((flag_string[i+lwanted]=='\0')||		/* either a terminal string */
				(flag_string[i+lwanted]==','))		/* or a comma terminated one */
				return 1;
		}
	}

	return 0;
}

/*********************************************/
/* toggle a flag of an entry of the bookmark */
/*********************************************/
void toggle_entry_flag_from_bookmark_by_id(int my_id, char *flag_to_toggle, int no_reload)
{
	GString *str,*val;
	gchar *pval;
	char *entry_list[5];
	gchar **flags;
	int fnd=0;
	int j;
	GString *new_flag_val;

	str=g_string_new("/" PROGNAME "/Bookmark_v1/");
	g_string_sprintfa(str,"%d",my_id);
	pval=gnome_config_get_string(str->str);
	if(pval==NULL)
	{
		/* the entry does not exist */
		g_string_free(str,TRUE);
		return;
	}

	/* retrieve entry to update */
	gnome_bookmark_string_to_array_bookmark(pval, &(entry_list[0]), &(entry_list[1]), &(entry_list[2]), &(entry_list[3]), &(entry_list[4]));
	if(entry_list[0]==NULL)
	{
		/* the entry does not exist */
		g_string_free(str,TRUE);
		return;
	}

	if(entry_list[3]==NULL)
		entry_list[3]=strdup("");
	if(entry_list[4]==NULL)
		entry_list[4]=strdup("");

	/* now, we have to toggle the wanted flag */
	flags=g_strsplit(entry_list[4],",",0);
	new_flag_val=g_string_new("");
	j=0;
	while(flags[j]!=NULL)
	{
		if(!strcmp(flag_to_toggle,flags[j]))
			fnd=1;
		else
		{
			if(new_flag_val->len!=0)
				new_flag_val=g_string_append_c(new_flag_val,',');
			new_flag_val=g_string_append(new_flag_val,flags[j]);
		}
		j++;
	}
	if(!fnd)
	{
		if(new_flag_val->len!=0)
			new_flag_val=g_string_append_c(new_flag_val,',');
		new_flag_val=g_string_append(new_flag_val,flag_to_toggle);
	}
	g_strfreev(flags);

	/* and save updated entry */
	val=array_bookmark_to_gnome_bookmark_string(entry_list[0], entry_list[1], entry_list[2], entry_list[3], new_flag_val->str);
	gnome_config_set_string(str->str,val->str);

	g_string_free(new_flag_val,TRUE);
	g_string_free(str,TRUE);
	g_string_free(val,TRUE);
	for(j=0;j<5;j++)
		free(entry_list[j]);
	
	gnome_config_sync();

	if(no_reload!=1)
		reload_bookmark();
}

/***********************************************/
/* set the profile of an entry of the bookmark */
/***********************************************/
void set_entry_profile_from_bookmark_by_id(int my_id, char *profile_to_use, int no_reload)
{
	GString *str,*val;
	gchar *pval;
	char *entry_list[5];
	int j;

	str=g_string_new("/" PROGNAME "/Bookmark_v1/");
	g_string_sprintfa(str,"%d",my_id);
	pval=gnome_config_get_string(str->str);
	if(pval==NULL)
	{
		/* the entry does not exist */
		g_string_free(str,TRUE);
		return;
	}

	/* retrieve entry to update */
	gnome_bookmark_string_to_array_bookmark(pval, &(entry_list[0]), &(entry_list[1]), &(entry_list[2]), &(entry_list[3]), &(entry_list[4]));
	if(entry_list[0]==NULL)
	{
		/* the entry does not exist */
		g_string_free(str,TRUE);
		return;
	}

	if(entry_list[3]!=NULL)
		free(entry_list[3]);
	entry_list[3]=strdup(profile_to_use);
	if(entry_list[4]==NULL)
		entry_list[4]=strdup("");

	/* and save updated entry */
	val=array_bookmark_to_gnome_bookmark_string(entry_list[0], entry_list[1], entry_list[2], entry_list[3], entry_list[4]);
	gnome_config_set_string(str->str,val->str);

	g_string_free(str,TRUE);
	g_string_free(val,TRUE);
	for(j=0;j<5;j++)
		free(entry_list[j]);
	
	gnome_config_sync();

	if(no_reload!=1)
		reload_bookmark();
}



/************************************/
/* delete a entry from the bookmark */
/************************************/
void delete_entry_from_bookmark_by_id(unsigned int bm_id, int no_reload)
{
	GString *str;

	str=g_string_new("/" PROGNAME "/Bookmark_v1/");
	g_string_sprintfa(str,"%d",bm_id);
	gnome_config_clean_key(str->str);
	gnome_config_sync ();
	g_string_free(str,TRUE);

	if(no_reload!=1)
		reload_bookmark();
}

/******************************************************************************************************/
/* Convert bookmarks from the old bookmark format (in /Bookmark/Content) into the new bookmark format */
/******************************************************************************************************/
void convert_old_bookmark_to_new_bookmark_format(void)
{
	int nb_entry;
	gchar **entry_list;
	int i;
	char num[32];

	gnome_config_get_vector("/" PROGNAME "/Bookmark/Content",&nb_entry,&entry_list);

	if(nb_entry!=0)
	{
		if(entry_list!=NULL)
		{
			for(i=0;i<nb_entry;i+=3)
			{
				/* entry_list[i] = Hubname */
				/* entry_list[i+1] = Hub description */
				/* entry_list[i+2] = Hub address */
				GString *bm_val;

				bm_val=array_bookmark_to_gnome_bookmark_string(entry_list[i],entry_list[i+1],entry_list[i+2],NULL,NULL);
				
				sprintf(num,"/" PROGNAME "/Bookmark_v1/%d",i/3);
				gnome_config_set_string(num,bm_val->str);
				g_string_free(bm_val,TRUE);
			}
		}
		gnome_config_set_int("/" PROGNAME "/Bookmark_v1/next_key",nb_entry/3);
	}

	gnome_config_sync ();
	
	/* entry list is no more useful */
	if(entry_list!=NULL)
		g_strfreev(entry_list);

	/* and delete the old bookmark */
	gnome_config_clean_section("/" PROGNAME "/Bookmark/");
	gnome_config_sync ();
}

/* -------------------------------------------- */
/****************************************************/
/* build modele and view for the hub favorite clist */
/****************************************************/
void bmav4_hub_favorite_clist(void)
{
	GtkListStore *model;
	GtkWidget *view;
	GtkCellRenderer *rend;
	GtkTreeSelection *slc;

	model=gtk_list_store_new(NB_FHC_COL,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_INT, G_TYPE_STRING);

	view=get_widget_by_widget_name(main_window,"hub_favorite_clist");

	gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),TRUE);
	gtk_tree_view_set_headers_clickable(GTK_TREE_VIEW(view),TRUE);

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode(slc,GTK_SELECTION_MULTIPLE);

	/* the first column of the view display the first column of the model, and so on. The 4th entry of the model is not displayed */
	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),FHC_HUB_NAME_COL,_("Hubname"),rend,"text",FHC_HUB_NAME_COL,"background",FHC_LINE_BACKGROUND,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),FHC_DESC_COL,_("Description"),rend,"text",FHC_DESC_COL,"background",FHC_LINE_BACKGROUND,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),FHC_HUB_ADDR_COL,_("Address"),rend,"text",FHC_HUB_ADDR_COL,"background",FHC_LINE_BACKGROUND,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),FHC_PROFILE,_("Default Profile"),rend,"text",FHC_PROFILE,"background",FHC_LINE_BACKGROUND,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),FHC_FLAGS,_("Flags"),rend,"text",FHC_FLAGS,"background",FHC_LINE_BACKGROUND,NULL);

	/* The view now holds a reference.  We can get rid of our own
	 * reference */
	g_object_unref (G_OBJECT (model));

}

