/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * gdl_ctree.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: gdl_ctree.h,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __GDL_CTREE_H__
#define __GDL_CTREE_H__

typedef enum
{
	GDL_ROOT=0,
	GDL_SEARCH_PATTERN,
	GDL_ACTIVE_SEGMENT,
	GDL_STORED_SEGMENT,
	GDL_RENAME_AT_END,
	GDL_SCRIPT_AT_END,
	GDL_NUMBER_OF_GDL_CT_TYPE	/* last value of the enum */
} GDL_CT_TYPE;

#if 0
typedef struct
{
	GDL_CT_TYPE ct_type;						/* GCC_TYPE */
	union
	{
		struct
		{
			unsigned long gdl_id;			/* GCC_ID= GDL ID */
			char *local_filename;			/* GCC_STR1= local filename */
			unsigned long gdl_size;			/* GCC_VAL1= size of the file */
			unsigned long byte_offset;		/* GCC_BYTE_OFFSET= number of bytes already here when this GDL was attached */
			unsigned long received_bytes;	/* GCC_RECEIVED_BYTES= this value includes the previous one */
			time_t start_time;				/* GCC_START_TIME= from creation or attachment */
			unsigned long last_10sec_speed;	/* GCC_LAST_10S_SPD= number of bytes received during the last 10 seconds */
		} root;
		struct
		{
			unsigned long autoscan_id;		/* GCC_ID */
			char *search_pattern;			/* GCC_STR1 */
			unsigned long autoscan_type;	/* GCC_VAL1 */
		} search_pattern;
		struct
		{
			char *nickname;					/* GCC_STR1 */
			char *remote_filename;			/* GCC_STR2 */
			unsigned long remote_file_size;/* GCC_VAL1 */
			char *status;						/* GCC_STR3 */
		} active_segment;
		struct
		{
			char *stored_filename;			/* GCC_STR1 */
			char *stored_interval;			/* GCC_STR2 */
		} stored_segment;
		struct
		{
			char *final_directory;			/* GCC_STR1 */
			char *final_filename;			/* GCC_STR2 */
		} rename_at_end;
		struct
		{
			char *script_to_start;			/* GCC_STR1 */
		} script_at_end;
	} c;
} GDL_CT_ENTRY;

#endif

/*******************************/
/* detach selected GDL entries */
/*******************************/
void detach_selected_gdl_entry(void);

/*****************************/
/* kill selected GDL entries */
/*****************************/
void kill_selected_gdl_entry(void);

/**************************************************************************************/
/* this function calls the given fnc for each selected entry of the "gdl_ctree" clist */
/**************************************************************************************/
/* fnc is an array of GDL_NUMBER_OF_GDL_CT_TYPE pointers, 1 pointer per GDL_CT_TYPE */
/* a NULL pointer means the entry is not processed                                  */
/************************************************************************************/
void generic_selected_gdl_entry_list_calls(void (*fnc[GDL_NUMBER_OF_GDL_CT_TYPE])(GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data), void *data);

/*******************************************/
/* build modele and view for the gdl ctree */
/*******************************************/
void bmav4_gdl_ctree(void);

#endif
