<?php
/*
 * $Id: class.boWatches.inc.php,v 1.4.2.2.2.18 2004/01/04 21:15:32 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');
LoadStringResource('wo');
LoadStringResource('tc');
LoadStringResource('tck');

class boWatches
{
	function showall()
	{
		commonHeader();
		$obj = CreateObject('dcl.htmlWatches');
		$obj->PrintMine();
	}
	
	function addWorkorder()
	{
		$GLOBALS['typeid'] = 1;
		$this->add();
	}

	function addTicket()
	{
		$GLOBALS['typeid'] = 4;
		$this->add();
	}

	function add()
	{
		commonHeader();

		$obj = CreateObject('dcl.dbWatches');
		$obj->Connect();
		$query = sprintf('SELECT * FROM watches WHERE typeid=%d AND whoid=%d AND whatid1=%d',
				$GLOBALS['typeid'], $GLOBALS['DCLID'], $GLOBALS['whatid1']);
		if (IsSet($GLOBALS['whatid2']))
			$query .= sprintf(' AND whatid2=%d', $GLOBALS['whatid2']);

		$objHTML = CreateObject('dcl.htmlWatches');

		if ($obj->Query($query) != -1)
		{
			if ($obj->next_record())
			{
				// He said they've already got one!
				$obj->GetRow();
				$objHTML->ShowEntryForm($obj, $this->getWatchDescription($obj));
				print('<p>');
				$objHTML->PrintMine();
				return;
			}
		}

		$objHTML->ShowEntryForm();
		print('<p>');
		$objHTML->PrintMine();
	}

	function dbadd()
	{
		commonHeader();
		$obj = CreateObject('dcl.dbWatches');
		$obj->Connect();
		$obj->InitFromGlobals();
		$obj->Add();

		$objHTML = CreateObject('dcl.htmlWatches');
		$objHTML->PrintMine();
	}

	function modify()
	{
		commonHeader();
		$obj = CreateObject('dcl.dbWatches');
		$obj->Connect();
		$obj->Load($GLOBALS['watchid']);
		if ($obj->whoid != $GLOBALS['DCLID'])
			return PrintPermissionDenied();
		$objHTML = CreateObject('dcl.htmlWatches');
		$objHTML->ShowEntryForm($obj, $this->getWatchDescription($obj));
	}

	function dbmodify()
	{
		commonHeader();
		$obj = CreateObject('dcl.dbWatches');
		$obj->Connect();
		$obj->Load($GLOBALS['watchid']);
		if ($obj->whoid != $GLOBALS['DCLID'])
			return PrintPermissionDenied();

		$obj->InitFromGlobals();
		$obj->Edit();
		$objHTML = CreateObject('dcl.htmlWatches');
		$objHTML->PrintMine();
	}
	function delete()
	{
		commonHeader();
		$obj = CreateObject('dcl.dbWatches');
		$obj->Connect();
		$obj->Load($GLOBALS['watchid']);
		if ($obj->whoid != $GLOBALS['DCLID'])
			return PrintPermissionDenied();

		ShowDeleteYesNo('Watch', 'boWatches.dbdelete', $obj->watchid, $this->getWatchDescription($obj));
	}

	function dbdelete()
	{
		$classSubName = 'Watches';

		commonHeader();
		$obj = CreateObject('dcl.db' . $classSubName);
		$obj->connect();
		$obj->Load($GLOBALS['id']);
		if ($obj->whoid != $GLOBALS['DCLID'])
			return PrintPermissionDenied();

		$objKey = new dclDB; // Don't really need anything fancy, 'spose...
		$noref = true;
		$objKey->connect($obj->conn);
		while ((list($table, $field) = each($obj->foreignKeys)) && $noref)
		{
			if (is_array($field)) // More than one field in here references this key
			{
				while ((list($dummykey, $onefield) = each($field)) && $noref)
				{
					$obj->Query("SELECT $onefield FROM $table WHERE $onefield=" . $GLOBALS['watchid']);
					if ($obj->next_record())
						$noref = false;
				}
			}
			else
			{
				$obj->Query("SELECT $field FROM $table WHERE $field=" . $GLOBALS['watchid']);
				if ($obj->next_record())
					$noref = false;
			}
		}

		$obj->Delete();
		print(STR_BO_DELETED);

		$objHTML = CreateObject('dcl.html' . $classSubName);
		$objHTML->PrintMine();
	}

	function getWatchDescription($obj)
	{
		if (!is_object($obj))
			return '';

		$objP = CreateObject('dcl.dbProducts');
		$objP->Connect($obj->conn);
		$objJ = CreateObject('dcl.dbProjects');
		$objJ->Connect($obj->conn);
		$objW = CreateObject('dcl.dbWorkorders');
		$objW->Connect($obj->conn);
		$objT = CreateObject('dcl.dbTickets');
		$objT->Connect($obj->conn);

		$summary = '';
		switch ($obj->typeid)
		{
			case 1:
			case 4:
				$objP->Load($obj->whatid1);
				$summary = $objP->name;
				break;
			case 2:
				$objJ->Load($obj->whatid1);
				$summary = $objJ->name;
				break;
			case 3:
				if ($obj->whatid2 > 0)
				{
					$objW->Load($obj->whatid1, $obj->whatid2);
					$summary = sprintf('(%d-%d) %s', $obj->whatid1, $obj->whatid2, $objW->summary);
				}
				else
					$summary = sprintf(STR_BO_WTCHALLSEQ, $obj->whatid1);
				break;
			case 5:
				$objT->Load($obj->whatid1);
				$summary = sprintf('(%d) %s', $obj->whatid1, $objT->summary);
				break;
			default:
				$summary = STR_BO_WTCHSUMMARYERR;
				break;
		}

		return sprintf('(%s %s) %s', $obj->arrTypeid[$obj->typeid], $obj->arrActions[$obj->actions], $summary);
	}

	// obj is a dbWorkorder object and actions is a comma delimited list of actions to send for
	function sendNotification($obj, $actions, $bShowNotifyMsg = true)
	{
		global $dcl_info;

		if (!is_object($obj) || $actions == '' || $dcl_info['DCL_SMTP_ENABLED'] != 'Y')
			return;

		$oMail = CreateObject('dcl.boSMTP');
		$oMail->isHtml = ($dcl_info['DCL_WO_NOTIFICATION_HTML'] == 'Y');

		$t = CreateObject('dcl.DCLTemplate');
		$t->set_file(array('hForm' => 'templates/custom/' . $dcl_info['DCL_WO_EMAIL_TEMPLATE']));
		$t->set_block('hForm', 'timecards', 'hTimecards');
		$t->set_var('hTimecards');

		$t->set_var('URL_DETAIL', $dcl_info['DCL_ROOT'] . 'main.php?menuAction=boWorkorders.viewjcn&jcn=' . $obj->jcn . '&seq=' . $obj->seq);

		$t->set_var('TXT_RESPONSIBLE', STR_WO_RESPONSIBLE);
		$t->set_var('TXT_PRIORITY', STR_WO_PRIORITY);
		$t->set_var('TXT_SEVERITY', STR_WO_SEVERITY);
		$t->set_var('TXT_DEADLINE', STR_WO_DEADLINE);
		$t->set_var('TXT_PRODUCT', STR_WO_PRODUCT);
		$t->set_var('TXT_VERSION', STR_WO_REVISION);
		$t->set_var('TXT_ESTSTART', STR_WO_ESTSTART);
		$t->set_var('TXT_ACTSTART', STR_WO_START);
		$t->set_var('TXT_ESTEND', STR_WO_ESTEND);
		$t->set_var('TXT_ACTEND', STR_WO_END);
		$t->set_var('TXT_ESTHOURS', STR_WO_ESTHOURS);
		$t->set_var('TXT_ACTHOURS', STR_WO_ACTHOURS);
		$t->set_var('TXT_ETCHOURS', STR_WO_ETCHOURS);
		$t->set_var('TXT_OPENEDBY', STR_WO_OPENBY);
		$t->set_var('TXT_CLOSEDBY', STR_WO_CLOSEBY);
		$t->set_var('TXT_STATUS', STR_WO_STATUS);
		$t->set_var('TXT_LASTACTION', STR_WO_LASTACTION);
		$t->set_var('TXT_ACCOUNT', STR_WO_ACCOUNT);
		$t->set_var('TXT_CONTACT', STR_WO_CONTACT);
		$t->set_var('TXT_CONTACTPHONE', STR_WO_CONTACTPHONE);
		$t->set_var('TXT_NOTES', STR_WO_NOTES);
		$t->set_var('TXT_DESCRIPTION', STR_WO_DESCRIPTION);
		$t->set_var('TXT_MODULE', STR_CMMN_MODULE);
		$t->set_var('TXT_PROJECT', STR_WO_PROJECT);
		$t->set_var('TXT_TYPE', STR_WO_TYPE);

		$t->set_var('VAL_WOID', $obj->jcn);
		$t->set_var('VAL_SEQ', $obj->seq);
		$t->set_var('VAL_DEADLINE', $obj->deadlineon);
		$t->set_var('VAL_ESTSTART', $obj->eststarton);
		$t->set_var('VAL_ACTSTART', $obj->starton);
		$t->set_var('VAL_ESTEND', $obj->estendon);
		$t->set_var('VAL_ACTEND', $obj->closedon);
		$t->set_var('VAL_ESTHOURS', $obj->esthours);
		$t->set_var('VAL_ACTHOURS', $obj->totalhours);
		$t->set_var('VAL_ETCHOURS', $obj->etchours);
		$t->set_var('VAL_OPENEDON', $obj->createdon);
		$t->set_var('VAL_STATUSON', $obj->statuson);
		$t->set_var('VAL_LASTACTION', $obj->lastactionon);
		$t->set_var('VAL_CLOSEDON', $obj->closedon);

		if ($oMail->isHtml)
		{
			$t->set_var('VAL_SUMMARY', htmlspecialchars($obj->summary));
			$t->set_var('VAL_VERSION', htmlspecialchars($obj->revision));
			$t->set_var('VAL_CONTACT', htmlspecialchars($obj->contact));
			$t->set_var('VAL_CONTACTPHONE', htmlspecialchars($obj->contactphone));
			$t->set_var('VAL_NOTES', nl2br(htmlspecialchars($obj->notes)));
			$t->set_var('VAL_DESCRIPTION', nl2br(htmlspecialchars($obj->description)));
		}
		else
		{
			$t->set_var('VAL_SUMMARY', $obj->summary);
			$t->set_var('VAL_VERSION', $obj->revision);
			$t->set_var('VAL_CONTACT', $obj->contact);
			$t->set_var('VAL_CONTACTPHONE', $obj->contactphone);
			$t->set_var('VAL_NOTES', $obj->notes);
			$t->set_var('VAL_DESCRIPTION', $obj->description);
		}

		$objPersonnel = CreateObject('dcl.dbPersonnel');
		$objPersonnel->Connect($obj->conn);
		$objStatus = CreateObject('dcl.dbStatuses');
		$objStatus->Connect($obj->conn);
		$objPriority = CreateObject('dcl.dbPriorities');
		$objPriority->Connect($obj->conn);
		$objSeverity = CreateObject('dcl.dbSeverities');
		$objSeverity->Connect($obj->conn);
		$objProduct = CreateObject('dcl.dbProducts');
		$objProduct->Connect($obj->conn);
		$objType = CreateObject('dcl.dbWorkOrderType');
		$objType->Connect($obj->conn);

		$objPersonnel->Load($obj->responsible);
		$t->set_var('VAL_RESPONSIBLE', $objPersonnel->short);
		$objPersonnel->Load($obj->createby);
		$t->set_var('VAL_OPENEDBY', $objPersonnel->short);
		$objType->Load($obj->wo_type_id);
		$t->set_var('VAL_TYPE', $objType->type_name);

		if ($objStatus->GetStatusType($obj->status) == 2)
		{
			$objPersonnel->Load($obj->closedby);
			$t->set_var('VAL_CLOSEDBY', $objPersonnel->short);
		}
		else
			$t->set_var('VAL_CLOSEDBY', '');

		$objPriority->Load($obj->priority);
		$objSeverity->Load($obj->severity);
		$objProduct->Load($obj->product);
		$objStatus->Load($obj->status);

		$t->set_var('VAL_PRIORITY', $objPriority->name);
		$t->set_var('VAL_SEVERITY', $objSeverity->name);
		$t->set_var('VAL_PRODUCT', $objProduct->name);
		$t->set_var('VAL_STATUS', $objStatus->name);

		$objAccount = CreateObject('dcl.dbWorkOrderAccount');
		$objAccount->Connect($obj->conn);
		if ($objAccount->Load($obj->jcn, $obj->seq) != -1)
		{
			$sAccounts = '';
			do
			{
				$objAccount->GetRow();
				$sAccounts .= $objAccount->account_name . '; ';
			}
			while ($objAccount->next_record());

			$t->set_var('VAL_ACCOUNT', $sAccounts);
		}
		else
			$t->set_var('VAL_ACCOUNT', '');

		if ($obj->module_id > 0)
		{
			$oModule = CreateObject('dcl.dbProductModules');
			$oModule->Connect($obj->conn);
			$oModule->Load($obj->module_id);
			$t->set_var('VAL_MODULE', $oModule->module_name);
		}
		else
			$t->set_var('VAL_MODULE', '');

		if ($obj->IsInAProject())
		{
			$oPM = CreateObject('dcl.dbProjectmap');
			$oPM->Connect($obj->conn);
			$oPM->LoadByWO($obj->jcn, $obj->seq);

			$oProject = CreateObject('dcl.dbProjects');
			$oProject->Connect($obj->conn);
			$oProject->Load($oPM->projectid);
			$t->set_var('VAL_PROJECT', $oProject->name);
		}
		else
			$t->set_var('VAL_PROJECT', '');

		// Slap on the time cards!
		$objTimeCard = CreateObject('dcl.dbTimeCards');
		$objTimeCard->Connect();
		if ($objTimeCard->GetTimeCards($obj->jcn, $obj->seq) != -1)
		{
			$t->set_var('TXT_TCSTATUS', STR_TC_STATUS);
			$t->set_var('TXT_TCVERSION', STR_TC_VERSION);
			$t->set_var('TXT_TCACTION', STR_TC_ACTION);
			$t->set_var('TXT_TCHOURS', STR_TC_HOURS);
			$t->set_var('TXT_TCDESCRIPTION', STR_TC_DESCRIPTION);
			$t->set_var('TXT_TCREASSIGN', STR_CMMN_REASSIGN);
			$t->set_var('TXT_TCTO', STR_CMMN_TO);

			$objAction = CreateObject('dcl.dbActions');
			$objAction->Connect($objTimeCard->conn);

			while ($objTimeCard->next_record())
			{
				$objTimeCard->GetRow();

				$t->set_var('VAL_TCACTIONON', $objTimeCard->actionon);
				$t->set_var('VAL_TCSUMMARY', $objTimeCard->summary);
				$t->set_var('VAL_TCVERSION', $objTimeCard->revision);
				$t->set_var('VAL_TCHOURS', $objTimeCard->hours);
				$t->set_var('VAL_TCDESCRIPTION', $objTimeCard->description);

				$objPersonnel->Load($objTimeCard->actionby);
				$t->set_var('VAL_TCACTIONBY', $objPersonnel->short);

				$objStatus->Load($objTimeCard->status);
				$t->set_var('VAL_TCSTATUS', $objStatus->name);

				$objAction->Load($objTimeCard->action);
				$t->set_var('VAL_TCACTION', $objAction->name);

				if ($objTimeCard->reassign_from_id > 0)
				{
					$objPersonnel->Load($objTimeCard->reassign_from_id);
					$t->set_var('VAL_TCREASSIGN', $objPersonnel->short);
				}
				else
					$t->set_var('VAL_TCREASSIGN', '');

				if ($objTimeCard->reassign_to_id > 0)
				{
					$objPersonnel->Load($objTimeCard->reassign_to_id);
					$t->set_var('VAL_TCTO', $objPersonnel->short);
				}
				else
					$t->set_var('VAL_TCTO', '');

				$t->parse('hTimecards', 'timecards', true);
			}
		}

		// Got the message constructed, so send it!
		// Determine if a project is associated and being watched
		$objPM = CreateObject('dcl.dbProjectmap');
		$objPM->Connect();
		$objPM->Query('select projectid from projectmap where jcn=' . $obj->jcn . ' and seq in (0,' . $obj->seq . ')');
		$projectID = -1;
		if ($objPM->next_record())
		{
			$projectID = $objPM->f(0);
		}

		$objWtch = CreateObject('dcl.dbWatches');
		$objWtch->Connect();
		$query = 'select distinct email from personnel ' . $objWtch->JoinKeyword . ' watches ON id=whoid ';
		$query .= 'LEFT JOIN dcl_wo_account ON typeid = 6 AND wo_id = ' . $obj->jcn;
		$query .= ' AND dcl_wo_account.seq = ' . $obj->seq . ' AND whatid1 = account_id ';;
		$query .= "where id = whoid AND actions in ($actions) and (";
		$query .= sprintf('(typeid=1 AND whatid1=%d)', $obj->product);
		if ($projectID != -1)
			$query .= sprintf(' or (typeid=2 and whatid1=%d)', $projectID);
		$query .= sprintf(' or (typeid=3 and whatid1=%d and whatid2 in (0,%d))', $obj->jcn, $obj->seq);
		$query .= ' or (typeid = 6 and whatid1 = account_id)';

		$query .= sprintf(') AND whoid != %d', $GLOBALS['DCLID']);
		$query .= " AND active = 'Y' AND email IS NOT NULL AND email != ''";

		$arrEmail = array();
		$mailFrom = '';
		if ($objPersonnel->Load($GLOBALS['DCLID']) != -1 && $objPersonnel->email != '')
			$mailFrom = '<' . $objPersonnel->email . '>';

		if ($obj->responsible != $GLOBALS['DCLID'] && $objPersonnel->Load($obj->responsible) != -1)
			if ($objPersonnel->active == 'Y' && !IsSet($arrEmail[$objPersonnel->email]))
				$arrEmail[$objPersonnel->email] = 1;

		if ($obj->createby != $GLOBALS['DCLID'] && $objPersonnel->Load($obj->createby) != -1)
			if ($objPersonnel->active == 'Y' && $objPersonnel->email != '' && !IsSet($arrEmail[$objPersonnel->email]))
				$arrEmail[$objPersonnel->email] = 1;

		if ($objWtch->Query($query) != -1)
		{
			while ($objWtch->next_record())
			{
				$arrEmail[$objWtch->f(0)] = 1;
			}
		}

		if (count($arrEmail) == 0)
			return;

		// Here we go!
		$toAddr = '';
		if ($objPriority->weight == 1)
			$oMail->AddHeader('X-Priority: 1');

		$oMail->from = $mailFrom;
		$oMail->subject = sprintf('[%s %d-%d] %s', STR_WO_JCN, $obj->jcn, $obj->seq, $obj->summary);
		$oMail->body = $t->parse('out', 'hForm');
		$oMail->to = array();
		while (list($email, $junk) = each($arrEmail))
		{
			$oMail->to[] = '<' . $email . '>';
			if ($toAddr != '')
				$toAddr .= ', ';
			$toAddr .= $email;
		}
		if (count($oMail->to) < 1)
			return;

		$oMail->Send();

		if ($bShowNotifyMsg && $toAddr != '')
		{
			print('<center>');
			PrintWithChocoFont(sprintf(STR_BO_MAILSENT, $toAddr));
			print('</center>');
		}
	}

	function sendTicketNotification($obj, $actions)
	{
		global $dcl_info;

		if ($dcl_info['DCL_SMTP_ENABLED'] != 'Y' || !is_object($obj))
			return;

		$oMail = CreateObject('dcl.boSMTP');
		$oMail->isHtml = ($dcl_info['DCL_TCK_NOTIFICATION_HTML'] == 'Y');

		$t = CreateObject('dcl.DCLTemplate');
		$t->set_file(array('hForm' => 'templates/custom/' . $dcl_info['DCL_TCK_EMAIL_TEMPLATE']));
		$t->set_block('hForm', 'resolutions', 'hResolutions');
		$t->set_var('hResolutions');

		$t->set_var('URL_DETAIL', $dcl_info['DCL_ROOT'] . 'main.php?menuAction=boTickets.view&ticketid=' . $obj->ticketid);

		$t->set_var('TXT_TICKET', STR_TCK_TICKET);
		$t->set_var('TXT_OPENEDBY', STR_TCK_OPENEDBY);
		$t->set_var('TXT_CLOSEDBY', STR_TCK_CLOSEDBY);
		$t->set_var('TXT_CLOSEDON', STR_TCK_CLOSEDON);
		$t->set_var('TXT_LASTACTION', STR_TCK_LASTACTIONON);
		$t->set_var('TXT_RESPONSIBLE', STR_TCK_RESPONSIBLE);
		$t->set_var('TXT_STATUS', STR_TCK_STATUS);
		$t->set_var('TXT_PRIORITY', STR_TCK_PRIORITY);
		$t->set_var('TXT_TYPE', STR_TCK_TYPE);
		$t->set_var('TXT_PRODUCT', STR_TCK_PRODUCT);
		$t->set_var('TXT_MODULE', STR_CMMN_MODULE);
		$t->set_var('TXT_VERSION', STR_TCK_VERSION);
		$t->set_var('TXT_ACCOUNT', STR_TCK_ACCOUNT);
		$t->set_var('TXT_CONTACT', STR_TCK_CONTACT);
		$t->set_var('TXT_CONTACTPHONE', STR_TCK_CONTACTPHONE);
		$t->set_var('TXT_ISSUE', STR_TCK_ISSUE);
		$t->set_var('TXT_RESOLUTION', STR_TCK_RESOLUTION);
		$t->set_var('TXT_TIME', STR_TCK_APPROXTIME);

		if ($oMail->isHtml)
		{
			$t->set_var('VAL_VERSION', htmlspecialchars($obj->version));
			$t->set_var('VAL_CONTACT', htmlspecialchars($obj->contact));
			$t->set_var('VAL_CONTACTPHONE', htmlspecialchars($obj->contactphone));
			$t->set_var('VAL_ISSUE', nl2br(htmlspecialchars($obj->issue)));
			$t->set_var('VAL_SUMMARY', htmlspecialchars($obj->summary));
		}
		else
		{
			$t->set_var('VAL_VERSION', $obj->version);
			$t->set_var('VAL_CONTACT', $obj->contact);
			$t->set_var('VAL_CONTACTPHONE', $obj->contactphone);
			$t->set_var('VAL_ISSUE', $obj->issue);
			$t->set_var('VAL_SUMMARY', $obj->summary);
		}

		$t->set_var('VAL_TICKETID', $obj->ticketid);
		$t->set_var('VAL_STATUSON', $obj->statuson);
		$t->set_var('VAL_OPENEDON', $obj->createdon);
		$t->set_var('VAL_CLOSEDON', $obj->closedon);
		$t->set_var('VAL_LASTACTION', $obj->lastactionon);
		$t->set_var('VAL_TIME', $obj->GetHoursText());

		$objPersonnel = CreateObject('dcl.dbPersonnel');
		$objPersonnel->Connect();

		$objPersonnel->Load($obj->createdby);
		$t->set_var('VAL_OPENEDBY', $objPersonnel->lastNameFirst);

		if ($obj->closedby > 0)
		{
			$objPersonnel->Load($obj->closedby);
			$t->set_var('VAL_CLOSEDBY', $objPersonnel->lastNameFirst);
		}
		else
			$t->set_var('VAL_CLOSEDBY', '');

		$objPersonnel->Load($obj->responsible);
		$t->set_var('VAL_RESPONSIBLE', $objPersonnel->lastNameFirst);

		$objStatus = CreateObject('dcl.dbStatuses');
		$objStatus->Connect($obj->conn);
		$objStatus->Load($obj->status);
		$t->set_var('VAL_STATUS', $objStatus->name);

		$objPriority = CreateObject('dcl.dbPriorities');
		$objPriority->Connect($obj->conn);
		$objPriority->Load($obj->priority);
		$t->set_var('VAL_PRIORITY', $objPriority->name);

		$objSeverity = CreateObject('dcl.dbSeverities');
		$objSeverity->Connect($obj->conn);
		$objSeverity->Load($obj->type);
		$t->set_var('VAL_TYPE', $objSeverity->name);

		$objProduct = CreateObject('dcl.dbProducts');
		$objProduct->Connect($objPersonnel->conn);
		$objProduct->Load($obj->product);
		$t->set_var('VAL_PRODUCT', $objProduct->name);

		if ($obj->module_id > 0)
		{
			$oModule = CreateObject('dcl.dbProductModules');
			$oModule->Connect($obj->conn);
			$oModule->Load($obj->module_id);
			$t->set_var('VAL_MODULE', $oModule->module_name);
		}
		else
			$t->set_var('VAL_MODULE', '');

		if ($obj->account > 0)
		{
			$objAccount = CreateObject('dcl.dbAccounts');
			$objAccount->Connect($objPersonnel->conn);
			$objAccount->Load($obj->account);
			$t->set_var('VAL_ACCOUNT', $objAccount->name);
		}
		else
			$t->set_var('VAL_ACCOUNT', '');

		// Add the resolutions
		$objT = CreateObject('dcl.dbTicketresolutions');
		$objT->Connect();
		if ($objT->GetResolutions($obj->ticketid) != -1)
		{
			$objAction = CreateObject('dcl.dbActions');
			$objAction->Connect($objT->conn);

			while ($objT->next_record())
			{
				$objT->GetRow();
				$objPersonnel->Load($objT->loggedby);
				$objStatus->Load($objT->status);

				$t->set_var('VAL_LOGGEDBY', $objPersonnel->short);
				$t->set_var('VAL_LOGGEDON', $objT->loggedon);
				$t->set_var('VAL_RESSTATUS', $objStatus->name);
				$t->set_var('VAL_RESTIME', $objT->GetHoursText());
				
				if ($oMail->isHtml)
					$t->set_var('VAL_RESOLUTION', nl2br(htmlspecialchars($objT->resolution)));
				else
					$t->set_var('VAL_RESOLUTION', $objT->resolution);

				$t->parse('hResolutions', 'resolutions', true);
			}
		}

		// Got the message constructed, so send it!
		$objWtch = CreateObject('dcl.dbWatches');
		$objWtch->Connect();
		$query = "select distinct whoid from watches where actions in ($actions) and (";
		$query .= sprintf('(typeid=4 AND whatid1=%d)', $obj->product);
		$query .= sprintf(' or (typeid=5 and whatid1=%d)', $obj->ticketid);

		if ($obj->account > 0)
			$query .= sprintf(' or (typeid=7 and whatid1=%d)', $obj->account);

		$query .= sprintf(') AND whoid != %d', $GLOBALS['DCLID']);

		$arrEmail = array();
		$mailFrom = '';
		if ($objPersonnel->Load($GLOBALS['DCLID']) != -1)
			$mailFrom = '<' . $objPersonnel->email . '>';

		if ($obj->responsible != $GLOBALS['DCLID'] && $objPersonnel->Load($obj->responsible) != -1)
			if ($objPersonnel->active == 'Y' && $objPersonnel->email != '' && !IsSet($arrEmail[$objPersonnel->email]))
				$arrEmail[$objPersonnel->email] = 1;

		if ($objPersonnel->Load($obj->createdby) != -1)
			if ($objPersonnel->active == 'Y' && !IsSet($arrEmail[$objPersonnel->email]))
				$arrEmail[$objPersonnel->email] = 1;

		if ($objWtch->Query($query) != -1)
		{
			while ($objWtch->next_record())
			{
				if ($objPersonnel->Load($objWtch->f(0)) != -1)
					if ($objPersonnel->active == 'Y' && !IsSet($arrEmail[$objPersonnel->email]))
						$arrEmail[$objPersonnel->email] = 1;
			}
		}
		// Here we go!
		$toAddr = '';
		if ($objPriority->weight == 1)
			$oMail->AddHeader('X-Priority: 1');

		$oMail->from = $mailFrom;
		$oMail->subject = sprintf('[%s #%d] %s', STR_TCK_TICKET, $obj->ticketid, $obj->summary);
		$oMail->body = $t->parse('out', 'hForm');
		$oMail->to = array();
		while (list($email, $junk) = each($arrEmail))
		{
			$oMail->to[] = '<' . $email . '>';
			if ($toAddr != '')
				$toAddr .= ', ';
			$toAddr .= $email;
		}
		if (count($oMail->to) < 1)
			return;

		$oMail->Send();

		if ($toAddr != '')
		{
			print('<center>');
			PrintWithChocoFont(sprintf(STR_BO_MAILSENT, $toAddr));
			print('</center>');
		}
	}

	function showmy()
	{
		commonHeader();
		$obj = CreateObject('dcl.htmlWatches');
		$obj->my(0);
	}
}
?>
