<?php
/*
 * $Id: class.htmlPersonnelBrowse.inc.php,v 1.1.2.2 2003/12/12 04:51:07 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('vw');
LoadStringResource('usr');
import('htmlView');
class htmlPersonnelBrowse extends htmlView
{
	function htmlPersonnelBrowse()
	{
		parent::htmlView();
		$this->sPagingMenuAction = 'htmlPersonnelBrowse.Page';

		$this->sColumnTitle = STR_CMMN_OPTIONS;
	}
	
	function InitTemplate()
	{
		$this->Template = CreateTemplate(array('hForm' => 'htmlPersonnelBrowse.tpl'));
		$this->_CreateBlocks();
		$this->_ResetBlocks();
	}

	function Render(&$oView)
	{
		global $dcl_info;

		if (!is_object($oView))
		{
			print('[htmlPersonnelBrowse::Render] ' . STR_VW_VIEWOBJECTNOTPASSED);
			return;
		}

		$this->oView = &$oView;

		$this->InitTemplate();
		
		$this->_SetStaticOptions();
		if (!$this->_Execute())
			return;

		$this->_SetActionFormOptions();
		$this->_SetFilterActiveOptions();
		$this->_SetFilterDepartmentOptions();
		
		$this->bShowPager = true;
		$this->_SetPager();

		$this->_SetVar('VAL_SEARCHACTION', menuLink());
		$this->_SetVar('VAL_VIEWSETTINGS', $this->oView->GetForm());

		if (!$this->oDB->next_record())
		{
			$this->_NoMatches();
			$this->_Finish();
			return;
		}

		do // next_record already called to check for matches
		{
			$this->_DisplayGroups();
			$this->_DisplayDetailHeader();
			$this->_DisplayDetail();
		}
		while ($this->oDB->next_record());

		$this->Template->parse('hSection', 'section', true);
		$this->Template->parse('hMatches', 'matches');
		$this->_Finish();
	}
	
	function Page()
	{
		global $dcl_info;

		commonHeader();
		
		$oView = CreateObject('dcl.boView');
		$oView->SetFromURL();

		if ((IsSet($GLOBALS['btnNav']) || IsSet($GLOBALS['jumptopage'])) && IsSet($GLOBALS['startrow']) && IsSet($GLOBALS['numrows']))
		{
			if (IsSet($GLOBALS['btnNav']) && $GLOBALS['btnNav'] == '<<')
				$oView->startrow = $GLOBALS['startrow'] - $GLOBALS['numrows'];
			else if (IsSet($GLOBALS['btnNav']) && $GLOBALS['btnNav'] == '>>')
				$oView->startrow = $GLOBALS['startrow'] + $GLOBALS['numrows'];
			else
			{
				$iPage = $GLOBALS['jumptopage'];
				if ($iPage < 1)
					$iPage = 1;

				$oView->startrow = ($iPage - 1) * $GLOBALS['numrows'];
			}

			if ($oView->startrow < 0)
				$oView->startrow = 0;

			$oView->numrows = $GLOBALS['numrows'];
		}
		else
		{
			$oView->numrows = 15;
			$oView->startrow = 0;
		}

		$filterActive = '';
		$filterDepartment = '0';
		if (IsSet($GLOBALS['filterActive']))
			$filterActive = $GLOBALS['filterActive'];
		if (IsSet($GLOBALS['filterDepartment']))
			$filterDepartment = $GLOBALS['filterDepartment'];

		$oView->RemoveDef('filter', 'active');
		if ($filterActive == 'Y' || $filterActive == 'N')
			$oView->AddDef('filter', 'active', "'$filterActive'");

		$oView->RemoveDef('filter', 'department');
		if ($filterDepartment != '0')
			$oView->AddDef('filter', 'department', $filterDepartment);

		$this->sColumnTitle = STR_CMMN_OPTIONS;
		$this->bShowPager = true;
		$this->Render($oView);
	}

	function _CreateBlocks()
	{
		$this->Template->set_block('hForm', 'pager', 'hPager');
		$this->Template->set_block('hForm', 'noActions', 'hNoActions');
		$this->Template->set_block('hForm', 'actions', 'hActions');
		$this->Template->set_block('hForm', 'nomatches', 'hNomatches');
		$this->Template->set_block('hForm', 'matches', 'hMatches');

		$this->Template->set_block('actions', 'actionLinkSet', 'hActionLinkSet');
		
		$this->Template->set_block('actionLinkSet', 'actionLinkSetLinks', 'hActionLinkSetLinks');

		$this->Template->set_block('actionLinkSetLinks', 'actionLinkSetLink', 'hActionLinkSetLink');
		$this->Template->set_block('actionLinkSetLinks', 'actionLinkSetSep', 'hActionLinkSetSep');

		$this->Template->set_block('matches', 'section', 'hSection');

		$this->Template->set_block('section', 'group', 'hGroup');
		$this->Template->set_block('section', 'detailHeader', 'hDetailHeader');
		$this->Template->set_block('section', 'detailRows', 'hDetailRows');

		$this->Template->set_block('detailHeader', 'detailHeaderCells', 'hDetailHeaderCells');

		$this->Template->set_block('detailHeaderCells', 'detailHeaderPadding', 'hDetailHeaderPadding');
		$this->Template->set_block('detailHeaderCells', 'detailHeaderColumnText', 'hDetailHeaderColumnText');
		$this->Template->set_block('detailHeaderCells', 'detailHeaderColumnLink', 'hDetailHeaderColumnLink');

		$this->Template->set_block('detailRows', 'detail', 'hDetail');
		$this->Template->set_block('detail', 'detailCells', 'hDetailCells');

		$this->Template->set_block('detailCells', 'detailPadding', 'hDetailPadding');
		$this->Template->set_block('detailCells', 'detailColumnText', 'hDetailColumnText');
		$this->Template->set_block('detailCells', 'detailColumnLink', 'hDetailColumnLink');

		$this->Template->set_block('hForm', 'filterActiveOptions', 'hFilterActiveOptions');
		$this->Template->set_block('hForm', 'filterDepartmentOptions', 'hFilterDepartmentOptions');
		$this->Template->set_block('detailHeaderCells', 'detailHeaderCheckbox', 'hDetailHeaderCheckbox');
		$this->Template->set_block('detailCells', 'detailCheckbox', 'hDetailCheckbox');
		$this->Template->set_block('detailCells', 'detailColumnAccount', 'hDetailColumnAccount');
		$this->Template->set_block('detailCells', 'detailColumnLinkSet', 'hDetailColumnLinkSet');
		
		$this->Template->set_block('detailColumnLinkSet', 'detailColumnLinkSetLinks', 'hDetailColumnLinkSetLinks');

		$this->Template->set_block('detailColumnLinkSetLinks', 'detailColumnLinkSetLink', 'hDetailColumnLinkSetLink');
		$this->Template->set_block('detailColumnLinkSetLinks', 'detailColumnLinkSetLinkDisabled', 'hDetailColumnLinkSetLinkDisabled');
		$this->Template->set_block('detailColumnLinkSetLinks', 'detailColumnLinkSetSep', 'hDetailColumnLinkSetSep');
	}

	function _ResetBlocks()
	{
		$this->_SetVar('hNoActions', '');
		$this->_SetVar('hActions', '');
		$this->_SetVar('hActionLinkSet', '');
		$this->_SetVar('hActionLinkSetLinks', '');
		$this->_SetVar('hActionLinkSetLink', '');
		$this->_SetVar('hActionLinkSetSep', '');
		$this->_SetVar('hPager', '');
		$this->_SetVar('hNomatches', '');
		$this->_SetVar('hMatches', '');
		$this->_SetVar('hSection', '');
		$this->_SetVar('hGroup', '');
		$this->_SetVar('hDetailHeader', '');
		$this->_SetVar('hDetailRows', '');
		$this->_SetVar('hDetailHeaderCells', '');
		$this->_SetVar('hDetailHeaderPadding', '');
		$this->_SetVar('hDetailHeaderColumnText', '');
		$this->_SetVar('hDetailHeaderColumnLink', '');
		$this->_SetVar('hDetail', '');
		$this->_SetVar('hDetailRows', '');
		$this->_SetVar('hDetailCells', '');
		$this->_SetVar('hDetailPadding', '');
		$this->_SetVar('hDetailColumnText', '');
		$this->_SetVar('hDetailColumnLink', '');
		$this->_SetVar('hFilterActiveOptions', '');
		$this->_SetVar('hFilterDepartmentOptions', '');
		$this->_SetVar('hDetailHeaderCheckbox', '');
		$this->_SetVar('hDetailCheckbox', '');
		$this->_SetVar('hDetailColumnAccount', '');
		$this->_SetVar('hDetailColumnLinkSet', '');
		$this->_SetVar('hDetailColumnLinkSetLinks', '');
		$this->_SetVar('hDetailColumnLinkSetLink', '');
		$this->_SetVar('hDetailColumnLinkSetLinkDisabled', '');
		$this->_SetVar('hDetailColumnLinkSetSep', '');
	}

	function _SetStaticOptions()
	{
		parent::_SetStaticOptions();
		$this->_SetVar('TXT_ACTIVE', STR_CMMN_ACTIVE);
		$this->_SetVar('TXT_DEPARTMENT', STR_USR_DEPARTMENT);
		$this->_SetVar('TXT_GO', STR_CMMN_GO);
		$this->_SetVar('TXT_FILTER', 'Filter');
	}

	function _SetActionFormOptions()
	{
		$aLinks = array(
				STR_CMMN_NEW => menuLink('', 'menuAction=boPersonnel.add'),
				DCL_MENU_SYSTEMSETUP => menuLink('', 'menuAction=boAdmin.ShowSystemConfig')
			);

		$this->_SetVar('hActionLinkSetLinks', '');
		$bFirst = true;
		foreach ($aLinks as $sText => $sLink)
		{
			if ($bFirst)
				$bFirst = false;
			else
				$this->Template->parse('hActionLinkSetLinks', 'actionLinkSetSep', true);

			$this->_SetVar('LNK_ACTIONVALUE', $sLink);
			$this->_SetVar('VAL_ACTIONVALUE', $sText);
			$this->Template->parse('hActionLinkSetLinks', 'actionLinkSetLink', true);
		}
		
		$this->Template->parse('hActionLinkSet', 'actionLinkSet');
		$this->Template->parse('hActions', 'actions');
	}

	function _AddFilterActiveOption($sValue, $sDescription, $bSelected = false)
	{
		$this->_AddOption('hFilterActiveOptions', 'filterActiveOptions', array(
			'VAL_FILTERACTIVEOPTION' => $sValue,
			'VAL_FILTERACTIVESELECTED' => ($bSelected ? ' selected' : ''),
			'TXT_FILTERACTIVEOPTION' => $sDescription
			));
	}

	function _SetFilterActiveOptions()
	{
		$filterActive = IsSet($GLOBALS['filterActive']) ? $GLOBALS['filterActive'] : '';

		$aActive = array(
				STR_CMMN_ALL => '0',
				STR_CMMN_YES => 'Y',
				STR_CMMN_NO => 'N'
			);
			
		foreach ($aActive as $sText => $sValue)
		{
			$this->_AddFilterActiveOption($sValue, $sText, $sValue == $filterActive);
		}
	}

	function _AddFilterDepartmentOption($sValue, $sDescription, $bSelected = false)
	{
		$this->_AddOption('hFilterDepartmentOptions', 'filterDepartmentOptions', array(
			'VAL_FILTERDEPARTMENTOPTION' => $sValue,
			'VAL_FILTERDEPARTMENTSELECTED' => ($bSelected ? ' selected' : ''),
			'TXT_FILTERDEPARTMENTOPTION' => $sDescription
			));
	}

	function _SetFilterDepartmentOptions()
	{
		$filterDepartment = IsSet($GLOBALS['filterDepartment']) ? $GLOBALS['filterDepartment'] : 0;

		$this->_AddFilterDepartmentOption('0', STR_CMMN_SELECTONE);

		$oDepartment = CreateObject('dcl.dbDepartments');
		$oDepartment->Connect();
		$oDepartment->Query('SELECT id, name FROM departments ORDER BY name');

		while ($oDepartment->next_record())
		{
			$this->_AddFilterDepartmentOption($oDepartment->f(0), $oDepartment->f(1), $oDepartment->f(0) == $filterDepartment);
		}

		$oDepartment->FreeResult();
	}

	function _DisplayOptions()
	{
		$id = $this->oDB->f('id');
		$email = $this->oDB->f('email');
		
		$this->_AddDisplayOption(STR_USR_EMAIL, $email, false, $email == '');
		$this->_AddDisplayOption(STR_CMMN_EDIT, menuLink('', 'menuAction=boPersonnel.modify&id=' . $id), true);
		$this->_AddDisplayOption(STR_CMMN_DELETE, menuLink('', 'menuAction=boPersonnel.delete&id=' . $id), true);

		$this->Template->parse('hDetailColumnLinkSet', 'detailColumnLinkSet');
		$this->Template->parse('hDetailCells', 'detailCells', true);

		// this avoids repeating cells
		$this->_ResetDetailCells();
	}
}
?>