CREATE TABLE tickets (
	ticketid int(11) NOT NULL auto_increment ,
	product int(11) NOT NULL,
	account int(11),
	createdby int(11) NOT NULL,
	createdon timestamp(14) DEFAULT 'now()' NOT NULL,
	responsible int(11) NOT NULL,
	closedby int(11),
	closedon timestamp(14),
	status int(11) NOT NULL,
	statuson timestamp(14) NOT NULL,
	lastactionon timestamp(14),
	priority int(11) NOT NULL,
	type int(11) NOT NULL,
	contact varchar(80),
	contactphone varchar(20),
	issue text NOT NULL,
	version varchar(20),
	summary varchar(100),
	seconds int(11) not null default '0',
	contactemail varchar(100),
	PRIMARY KEY (ticketid)
);

CREATE TABLE ticketresolutions (
	resid int(11) NOT NULL auto_increment ,
	ticketid int(11) NOT NULL,
	loggedby int(11) NOT NULL,
	loggedon timestamp(14) DEFAULT 'now()' NOT NULL,
	status int(11) NOT NULL,
	resolution text NOT NULL,
	startedon timestamp(14) NOT NULL,
	PRIMARY KEY (resid)
);

CREATE TABLE faq (
	faqid int(11) NOT NULL auto_increment ,
	name varchar(80) NOT NULL,
	createby int(11),
	createon timestamp(14) DEFAULT 'now()' NOT NULL,
	modifyby int(11),
	modifyon timestamp(14),
	active char(1) DEFAULT 'Y' NOT NULL,
	description text,
	PRIMARY KEY (faqid)
);

CREATE TABLE faqtopics (
	topicid int(11) NOT NULL auto_increment ,
	seq int(11) NOT NULL,
	faqid int(11) NOT NULL,
	name varchar(80) NOT NULL,
	description text NOT NULL,
	createby int(11),
	createon timestamp(14) DEFAULT 'now()' NOT NULL,
	modifyby int(11),
	modifyon timestamp(14),
	active char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY (topicid)
);

CREATE TABLE faqquestions (
	questionid int(11) NOT NULL auto_increment ,
	seq int(11) NOT NULL,
	topicid int(11) NOT NULL,
	questiontext text NOT NULL,
	createby int(11),
	createon timestamp(14) DEFAULT 'now()' NOT NULL,
	modifyby int(11),
	modifyon timestamp(14),
	active char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY (questionid)
);

CREATE TABLE faqanswers (
	answerid int(11) NOT NULL auto_increment ,
	questionid int(11) NOT NULL,
	answertext text NOT NULL,
	createby int(11) NOT NULL,
	createon timestamp(14) DEFAULT 'now()' NOT NULL,
	modifyby int(11),
	modifyon timestamp(14),
	active char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY (answerid)
);

alter table products add column ticketsto int(11) not null;
update products set ticketsto=reportto;

alter table projects add column parentprojectid int(11) default '0' not null;
update projects set parentprojectid=0;

CREATE TABLE views (
	viewid int(11) NOT NULL auto_increment ,
	whoid int(11) NOT NULL,
	name varchar(100) NOT NULL,
	ispublic char(1) DEFAULT 'N' NOT NULL,
	viewurl text NOT NULL,
	tablename varchar(30) not null,
	PRIMARY KEY(viewid)
);


CREATE TABLE attributesets (
	id int(11) NOT NULL auto_increment ,
	short varchar(20) NOT NULL,
	name varchar(100) NOT NULL,
	active char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY(id)
);

INSERT INTO attributesets(short,name,active) VALUES ('WO', 'Work Orders', 'Y');
INSERT INTO attributesets(short,name,active) VALUES ('TCK', 'Tickets', 'Y');

CREATE TABLE attributesetsmap (
	setid int(11) NOT NULL,
	typeid int(11) NOT NULL,
	keyid int(11) NOT NULL,
	weight int(11) NOT NULL
);

INSERT INTO attributesetsmap SELECT 1, 1, id, 1 FROM actions;
INSERT INTO attributesetsmap SELECT 1, 2, id, weight FROM priorities;
INSERT INTO attributesetsmap SELECT 1, 3, id, weight FROM severities;
INSERT INTO attributesetsmap SELECT 1, 4, id, 1 FROM statuses;

INSERT INTO attributesetsmap SELECT 2, 1, id, 1 FROM actions;
INSERT INTO attributesetsmap SELECT 2, 2, id, weight FROM priorities;
INSERT INTO attributesetsmap SELECT 2, 3, id, weight FROM severities;
INSERT INTO attributesetsmap SELECT 2, 4, id, 1 FROM statuses;

alter table products add column wosetid int(11) not null default '0';
alter table products add column tcksetid int(11) not null default '0';

update products set wosetid=1;
update products set tcksetid=2;
