<?php
/*
 * $Id: menu.php,v 1.1.2.2 2003/04/27 14:31:20 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

function getMenuLink($link)
{
	if (!ereg('html$', $link) && !ereg('php3$', $link) && !ereg('\.php$', $link))
		return menuLink('', 'menuAction=' . $link);
	elseif (substr($link, 0, 7) != 'http://')
		return menuLink('/dcl/' . $link);

	return $link;
}

function getmenu(&$t)
{
	global $dcl_info;

	$menu = 0;

	reset($GLOBALS['DCL_MENU']);
	while (list($menuname, $themenu) = each($GLOBALS['DCL_MENU']))
	{
		reset($themenu);
		if (count($themenu) < 3)
			continue;

		$menu++;
		$t->set_var('hMenuItems', '');
		while (list($name, $item) = each($themenu))
		{
			$link = $item[0];
			$seclvl = $item[1];
			if ($GLOBALS['SEC'] >= $seclvl)
			{
				$t->set_var('LNK_MENUITEM', getMenuLink($link));
				$t->set_var('VAL_MENUITEM', $name);
				$t->parse('hMenuItems', 'menuItems', true);
			}
		}

		$t->set_var('VAL_MENUNAME', $menuname);
		$t->set_var('VAL_MENUID', $menu);
		$t->set_var('VAL_WIDTH', '150');
		$t->parse('hMenuCSS', 'menuCSS', true);
		$t->parse('hMenuJS', 'menuJS', true);
		$t->parse('hMenuBar', 'menuBar', true);
	}
}

function renderDCLMenu()
{
	global $dcl_info;

	$t = CreateTemplate(array('hForm' => 'menu.tpl'));
	$t->set_block('hForm', 'menuCSS', 'hMenuCSS');
	$t->set_block('hForm', 'menuJS', 'hMenuJS');
	$t->set_block('hForm', 'menuBar', 'hMenuBar');
	$t->set_block('menuBar', 'menuItems', 'hMenuItems');
	$t->set_var('hMenuCSS', '');
	$t->set_var('hMenuJS', '');
	$t->set_var('hMenuBar', '');
	$t->set_var('hMenuItems', '');

	$t->set_var('DIR_IMAGES', 'templates/' . GetDefaultTemplateSet() . '/img');
	$t->set_var('DIR_CSS', 'templates/' . GetDefaultTemplateSet() . '/css');
	$t->set_var('DIR_JS', 'templates/' . GetDefaultTemplateSet() . '/js');
	$t->set_var('LNK_LOGOFF', menuLink('index.php'));
	$t->set_var('LNK_HOME', menuLink('', 'menuAction=htmlMyDCL.show'));
	$t->set_var('LNK_PREFERENCES', menuLink('', 'menuAction=htmlPreferences.modify'));
	$t->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
	$t->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);

	getmenu($t);

	$t->pparse('out', 'hForm');
}
?>
