/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * bdb.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: bdb.h,v 1.2 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __BDB_H__
#define __BDB_H__

/**************************/
/* BerkeleyDB environment */
/**************************/
extern DB_ENV *dbenv;
extern DB *unwanted_user;      	/* berkeleyDB of all users we must ignore */

/********************************************/
/* close dctc DBs and exit Berkeley library */
/********************************************/
void do_berkeley_exit(void);

/********************************************************************/
/* initialize berkeleyDB library and check/create and open dctc DBs */
/********************************************************************/
void do_berkeley_init(void);

/***************************/
/* get data of a given key */
/****************************************************************************/
/* output: 0=ok, !=0 not found                                              */
/*         if ok, *data_val contains the data (to free when no more useful) */
/*                *data_len is the length of the data                       */
/****************************************************************************/
int get_key_data(DB *table, void *key_val, const int key_len, void **data_val, int *data_len);

/***************************/
/* set data of a given key */
/***************************/
/* output: 0=ok, !=0 error */
/***************************/
int set_key_data(DB *table, void *key_val, const int key_len, void *data_val, const int data_len);

/******************************/
/* del data and the given key */
/******************************/
/* output: 0=ok, !=0 error */
/***************************/
int del_key_data(DB *table, void *key_val, const int key_len);

#endif
