#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "command.h"

#include <stdexcept>

#include <algorithm>

#include <cerrno>

extern "C" {
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>
}

command::command(std::string const &executable,
		arg_list const &args,
		env_list const &env,
		shared_fd child_stdin,
		shared_fd child_stdout,
		shared_fd child_stderr) :
	executable(executable),
	args(args),
	env(env),
	child_stdin(child_stdin),
	child_stdout(child_stdout),
	child_stderr(child_stderr),
	pid(-1)
{
	return;
}

void command::run(void)
{
	char const *arg_array[args.size()+1];
	*std::transform(args.begin(), args.end(), arg_array, std::mem_fun_ref(&std::string::c_str)) = 0;
	char const *env_array[env.size()+1];
	*std::transform(env.begin(), env.end(), env_array, std::mem_fun_ref(&std::string::c_str)) = 0;
	pid = ::fork();
	if(pid == -1)
		throw std::runtime_error(strerror(errno));
	if(pid != 0)
	{
		child_stdin.reset();
		child_stdout.reset();
		child_stderr.reset();
		return;
	}
	dup2(child_stdin, 0);
	dup2(child_stdout, 1);
	dup2(child_stderr, 2);
	child_stdin.reset();
	child_stdout.reset();
	child_stderr.reset();
	::execve(executable.c_str(), const_cast<char *const *>(arg_array), const_cast<char *const *>(env_array));
	::exit(128);
}

int command::wait(void)
{
	int status;
	rusage resources;
	::wait4(pid, &status, 0, &resources);
	return status;
}
