#ifndef DEBTAGS_OPTIONS_H
#define DEBTAGS_OPTIONS_H

/*
 * Commandline parser for tagcoll
 *
 * Copyright (C) 2003,2004,2005,2006  Enrico Zini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>
#include <wibble/commandline/parser.h>

namespace wibble {
namespace commandline {

struct DebtagsEditOptions : public StandardParserWithManpage
{
public:
	BoolOption* out_verbose;
	BoolOption* out_debug;

	DebtagsEditOptions() 
		: StandardParserWithManpage("debtags-edit", VERSION, 1, "enrico@enricozini.org")
	{
		usage = "[options]";
		description = "Editor application for Debian Package Tags";
		longDescription = 
				"Edits the Debian Package Tags database present on the system\n"
				"saving the changes in ~/.debtags\n";

		out_verbose = add<BoolOption>("verbose", 'v', "verbose", "",
						"enable verbose output");
		out_debug = add<BoolOption>("debug", 0, "debug", "",
						"enable debugging output (including verbose output)");
	}
};

}
}

// vim:set ts=4 sw=4:
#endif
