/*
 * Main application class
 *
 * Copyright (C) 2003--2006  Enrico Zini <enrico@debian.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "DebtagsEditor.h"

#include <tagcoll/patch.h>
#include "Environment.h"
#include "DebtagsDocument.h"

#include <gtkmm/stock.h>
#include <gtkmm/fileselection.h>
#include <gtkmm/messagedialog.h>

#include <map>
#include <stdexcept>

using namespace std;

//template class DebtagsEditor<DebtagsDocument>;

template<class DOC>
DebtagsEditor<DOC>::DebtagsEditor(DOC& doc)
	: doc(doc), fpanel(doc), tagEditor(doc), rpanel(doc), review(doc) /*panelTable(1, 2, true),*/ /* current(), changed(false) */
{
	set_title("Debtags Editor");
	//set_border_width(5);
	set_default_size(700, 500);

	add(mainVBox);

	mainVBox.pack_start(menuBar, Gtk::PACK_SHRINK);
	mainVBox.pack_start(mainArea, Gtk::PACK_EXPAND_WIDGET);
	//mainVBox.pack_start(mainHPaned, Gtk::PACK_EXPAND_WIDGET);
	//add(mainArea);

	mainArea.append_page(mainHPaned, "Edit");
	mainArea.append_page(review, "Review");

	mainHPaned.add1(fpanel);

	Gtk::VBox* rvbox = manage(new Gtk::VBox());

	Gtk::ScrolledWindow* scr = manage(new Gtk::ScrolledWindow());
    scr->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	scr->add(descr);

	mainHPaned.add2(*rvbox);

	dataArea.append_page(*scr, "Description");
	dataArea.append_page(rpanel, "Related");

	rvbox->pack_start(mainVPaned, Gtk::PACK_EXPAND_WIDGET);

	mainVPaned.add1(tagEditor);
	mainVPaned.add2(dataArea);

	fpanel.signal_selected().connect(
			sigc::mem_fun(doc, &DOC::setCurrent));
	rpanel.signal_selected().connect(
			sigc::mem_fun(doc, &DOC::setCurrent));
	/*
	fpanel.signal_selected().connect(
			sigc::mem_fun(rpanel, &RelatedPanel<DOC>::do_pivot_change));
	rpanel.signal_selected().connect(
			sigc::mem_fun(rpanel, &RelatedPanel<DOC>::do_pivot_change));
	*/
	/*
	tagEditor.signal_changed().connect(
			sigc::mem_fun(*this, &DebtagsEditor<DOC>::on_tag_change));
	*/

	descrBuf = Gtk::TextBuffer::create();
	descr.set_buffer(descrBuf);

	/*
	entryHBox.pack_start(addLabel, Gtk::PACK_SHRINK);
	entryHBox.pack_start(addCombo, Gtk::PACK_EXPAND_WIDGET);
	entryHBox.pack_start(addButton, Gtk::PACK_SHRINK);
	*/
	//currentAdd.set_text("");
	
	/*
	allTags = doc.collection().getAllTags();
	addCombo.set_popdown_strings(allTags);
	//currentAdd.get_entry()->signal_changed().connect(
	addButton.signal_clicked().connect(
			SigC::slot(*this, &DebtagsEditor::on_addButton_clicked));
	*/

	//panelTable.attach(*panels[0], 0, 1, 0, 1, Gtk::FILL | Gtk::EXPAND | Gtk::SHRINK, Gtk::FILL | Gtk::EXPAND | Gtk::SHRINK, 1, 0);
	//panelTable.attach(*panels[1], 1, 2, 0, 1, Gtk::FILL | Gtk::EXPAND | Gtk::SHRINK, Gtk::FILL | Gtk::EXPAND | Gtk::SHRINK, 1, 0);

	/*
	doc.signal_changed().connect(SigC::slot(*this, &DebtagsEditor::on_doc_change));
	doc.signal_filename_changed().connect(SigC::slot(*this, &DebtagsEditor::on_filename_change));
	panels[0]->signal_selection_changed().connect(SigC::slot(*this, &DebtagsEditor::on_selection_change));
	panels[1]->signal_selection_changed().connect(SigC::slot(*this, &DebtagsEditor::on_selection_change));
	panels[0]->signal_focus_in().connect(SigC::slot(*this, &DebtagsEditor::on_leftpanel_focus));
	panels[1]->signal_focus_in().connect(SigC::slot(*this, &DebtagsEditor::on_rightpanel_focus));
	panels[0]->signal_request_tagcoll_change().connect(SigC::slot(*this, &DebtagsEditor::on_request_tagcoll_change));
	panels[1]->signal_request_tagcoll_change().connect(SigC::slot(*this, &DebtagsEditor::on_request_tagcoll_change));
	panels[0]->signal_request_tagset_merge().connect(SigC::slot(*this, &DebtagsEditor::on_merge));
	panels[1]->signal_request_tagset_merge().connect(SigC::slot(*this, &DebtagsEditor::on_merge));
	panels[0]->signal_request_tagset_intersect().connect(SigC::slot(*this, &DebtagsEditor::on_intersect));
	panels[1]->signal_request_tagset_intersect().connect(SigC::slot(*this, &DebtagsEditor::on_intersect));
	panels[0]->signal_request_item_copy().connect(SigC::slot(*this, &DebtagsEditor::on_copy_to_other));
	panels[1]->signal_request_item_copy().connect(SigC::slot(*this, &DebtagsEditor::on_copy_to_other));
	panels[0]->signal_request_item_move().connect(SigC::slot(*this, &DebtagsEditor::on_move_to_other));
	panels[1]->signal_request_item_move().connect(SigC::slot(*this, &DebtagsEditor::on_move_to_other));
	panels[0]->signal_select_tagset().connect(SigC::slot(*this, &DebtagsEditor::on_select_tagset_panel1));
	panels[1]->signal_select_tagset().connect(SigC::slot(*this, &DebtagsEditor::on_select_tagset_panel2));
	panels[0]->signal_select_tagset_other_panel().connect(SigC::slot(*this, &DebtagsEditor::on_select_tagset_panel2));
	panels[1]->signal_select_tagset_other_panel().connect(SigC::slot(*this, &DebtagsEditor::on_select_tagset_panel1));
*/

	menuBar.items().push_back(Gtk::Menu_Helpers::MenuElem("_File", fileMenu));
	menuBar.items().push_back(Gtk::Menu_Helpers::MenuElem("_Edit", editMenu));
	menuBar.items().push_back(Gtk::Menu_Helpers::MenuElem("_Options", optionsMenu));

	/*
	fileMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("Load _Debtags",
				SigC::slot(*this, &DebtagsEditor::on_open_debtags)));
	fileMenu.items().push_back(Gtk::Menu_Helpers::SeparatorElem());
	*/

	fileMenu.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::SAVE,
				sigc::mem_fun(*this, &DebtagsEditor::on_save)));
	
	fileMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("_Mail changes to central database",
				sigc::mem_fun(*this, &DebtagsEditor::on_send)));
	
	/*
	saveMenuItem = &(fileMenu.items().back());
	saveMenuItem->set_sensitive(false);
	fileMenu.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::SAVE_AS,
				SigC::slot(*this, &DebtagsEditor::on_save_as)));
	saveasMenuItem = &(fileMenu.items().back());
	fileMenu.items().push_back(Gtk::Menu_Helpers::SeparatorElem());
	*/

	fileMenu.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::QUIT,
				sigc::mem_fun(*this, &DebtagsEditor::on_quit)));


	editMenu.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::UNDO,
				sigc::mem_fun(doc, &DOC::undo)));
	undoMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::REDO,
				sigc::mem_fun(doc, &DOC::redo)));
	redoMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("_Repeat last change",
				sigc::mem_fun(doc, &DOC::reapplyToCurrent)));
	reapplyMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::SeparatorElem());

	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("_TODO dialog",
				sigc::mem_fun(fpanel, &FilterPanel<DOC>::do_todo_dialog)));
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("_Facet dialog",
				sigc::mem_fun(fpanel, &FilterPanel<DOC>::do_facets_dialog)));

	optionsMenu.items().push_back(Gtk::Menu_Helpers::CheckMenuElem("_Disable slow experimental algorithms",
				sigc::mem_fun(*this, &DebtagsEditor::on_compute_intensive_data)));
	computeIntensiveMenuItem = dynamic_cast<Gtk::CheckMenuItem*>(&(optionsMenu.items().back()));
	computeIntensiveMenuItem->set_active(doc.getComputeIntensive());

	/*
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("_Merge",
				SigC::slot(*this, &DebtagsEditor::on_merge)));
	mergeMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("_Intersect",
				SigC::slot(*this, &DebtagsEditor::on_intersect)));
	intersectMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("Co_py to other panel",
				SigC::slot(*this, &DebtagsEditor::on_copy_to_other)));
	copyToOtherMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("Mo_ve to other panel",
				SigC::slot(*this, &DebtagsEditor::on_move_to_other)));
	moveToOtherMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("Delete _unselected tags",
				SigC::slot(*this, &DebtagsEditor::on_delete_unselected)));
	deleteUnselectedMenuItem = &(editMenu.items().back());
	*/

	//menuBar.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::HELP, helpMenu));
	/*
	checkUndo();
	checkReapply();
	*/
	//setChanged(false);
	//on_filename_change();

	on_changed();

	doc.signal_changed().connect(sigc::mem_fun(*this, &DebtagsEditor<DOC>::on_changed));
	doc.signal_reselected().connect(sigc::mem_fun(*this, &DebtagsEditor<DOC>::on_reselected));

	show_all_children();
}

template<class DOC>
void DebtagsEditor<DOC>::on_changed()
{
	checkUndo();
	on_reselected();
}

template<class DOC>
void DebtagsEditor<DOC>::on_reselected()
{
	checkReapply();
	if (doc.current() == Package())
		descrBuf->set_text("No packages are currently selected");
	else
		try {
			descrBuf->set_text(doc.apt().rawRecord(doc.current()));
		} catch (std::out_of_range& e) {
			descrBuf->set_text("Unable to access package informations");
		}
}

#if 0
template<class DOC>
void DebtagsEditor<DOC>::on_package_selected(typename DOC::package pkg) throw ()
{
	doc.setCurrent(pkg);
	/*
	current = pkg;
	descrBuf->set_text(pkg.candidateVersion().completeRecord());
	tagEditor.setSelected(doc.tagdb().getTags(pkg));
	checkReapply();
	*/
}
#endif

/*
template<class DOC>
void DebtagsEditor<DOC>::on_tag_change() throw ()
{
	TagSet newTags = tagEditor.selected();

	// Make the change
	PatchList<typename DOC::package, Tag> change;
	TagSet oldTags = doc.tagdb().getTags(current);
	change.addPatch(Patch<typename DOC::package, Tag>(current, newTags - oldTags, oldTags - newTags));
	doc.applyChange(change);

	// TODO: farlo da solo quando cambia il doc
	rpanel.do_pivot_change(current);
}
*/

/*
template<class DOC>
void DebtagsEditor<DOC>::setChanged(bool val)
{
	changed = val;
	//on_filename_change();
}
*/

/*
template<class DOC>
void DebtagsEditor<DOC>::on_doc_change()
{
	checkUndo();
	checkReapply();
	setChanged(true);
}
*/

/*
template<class DOC>
void DebtagsEditor<DOC>::on_filename_change()
{
	if (doc.fileName().empty())
	{
		set_title(string("Tagged Collection Editor - debtags Database") + (changed ? " [*]" : ""));
		saveMenuItem->set_sensitive(false);
	}
	else
	{
		set_title("Tagged Collection Editor - " + doc.fileName() + (changed ? " [*]" : ""));
		saveMenuItem->set_sensitive(changed);
	}
}
*/

template<class DOC>
void DebtagsEditor<DOC>::checkUndo()
{
	undoMenuItem->set_sensitive(doc.canUndo());
	redoMenuItem->set_sensitive(doc.canRedo());
}

template<class DOC>
void DebtagsEditor<DOC>::checkReapply()
{
	reapplyMenuItem->set_sensitive(doc.canReapply(doc.current()));
}

/*
template<class DOC>
void DebtagsEditor<DOC>::on_open_debtags()
{
	try {
		doc.load();
	} catch (Exception& e) {
		warning("%s: %.*s", e.type(), PFSTR(e.desc()));
	}
}
*/

template<class DOC>
void DebtagsEditor<DOC>::on_save()
{
	//if (!doc.fileName().empty())
	//{
		//doc.save(doc.fileName());
		//setChanged(false);
	//}
	try {
		doc.save();
		//setChanged(false);
	} catch (std::exception& e) {
		Gtk::MessageDialog err(string("Save failed: ") + e.what(),
				false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
		err.run();
	}
}

template<class DOC>
void DebtagsEditor<DOC>::on_send()
{
	//if (!doc.fileName().empty())
	//{
		//doc.save(doc.fileName());
		//setChanged(false);
	//}
	try {
		doc.send();
		Gtk::MessageDialog oki("Mail sent.", false, Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true);
		oki.run();
	} catch (std::exception& e) {
		Gtk::MessageDialog err(string("Send failed: ") + e.what(),
				false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
		err.run();
	}
}

/*
template<class DOC>
void DebtagsEditor<DOC>::on_save_as()
{
	Gtk::FileSelection dialog("Please select the file name to save as");
	dialog.set_transient_for(*this);
	//dialog.get_file_list()->get_parent()->hide(); //Prevent the user from selecting a file.

	int result = dialog.run();

	//Handle the response:
	switch (result)
	{
		case Gtk::RESPONSE_OK:
		{
			try {
				doc.save(dialog.get_filename());
			} catch (Exception& e) {
				warning("%s: %.*s", e.type(), PFSTR(e.desc()));
			}
			setChanged(false);
			break;
		}
		case Gtk::RESPONSE_CANCEL:
		{
			break;
		}
		default:
		{
			warning("Unexpected button clicked in save as... file selection dialog");
			break;
		}
	}
}
*/

template<class DOC>
void DebtagsEditor<DOC>::on_quit()
{
	hide();
}

template<class DOC>
void DebtagsEditor<DOC>::on_compute_intensive_data()
{
	doc.setComputeIntensive(!computeIntensiveMenuItem->get_active());
}





template class DebtagsEditor<DebtagsDocument>;

// vim:set ts=4 sw=4:
