#ifndef DEBTAGS_EDITOR_H
#define DEBTAGS_EDITOR_H

/*
 * Main application class
 *
 * Copyright (C) 2003--2006  Enrico Zini <enrico@debian.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//#include <debtags/Package.h>
#include "FilterPanel.h"
#include "RelatedPanel.h"
#include "TagEditor.h"
#include "PatchReview.h"

#include <gtkmm/window.h>
//#include <gtkmm/table.h>
#include <gtkmm/paned.h>
#include <gtkmm/menu.h>
#include <gtkmm/menubar.h>
#include <gtkmm/label.h>
#include <gtkmm/button.h>
#include <gtkmm/textview.h>
#include <gtkmm/notebook.h>

using namespace std;

/**
 * Main application window
 *
 * Contains:
 * \verbatim
 * +-Menu-------------------------------+
 * +-------------+----------------------+
 * |             |                      |
 * | FilterPanel |       TagEditor      |
 * |             |                      |
 * |             +-------+--------------+
 * |             |       |              |
 * |             | descr | RelatedPanel |
 * |             |       |              |
 * +-------------+-------+--------------+
 * \endverbatim
 */
template<class DOC>
class DebtagsEditor : public Gtk::Window
{
protected:
	typedef typename DOC::Package Package;
	typedef typename DOC::Facet Facet;
	typedef typename DOC::Tag Tag;

	DOC& doc;
	Gtk::Notebook mainArea;

	FilterPanel<DOC> fpanel;
	Gtk::HPaned mainHPaned;
	Gtk::VPaned mainVPaned;
	TagEditor<DOC> tagEditor;

	//TagPanel leftTagPanel;
	//TagPanel rightTagPanel;
	Gtk::VBox mainVBox;
	Gtk::HBox entryHBox;
	Gtk::Notebook dataArea;
	Gtk::TextView descr;
	RelatedPanel<DOC> rpanel;
	Glib::RefPtr<Gtk::TextBuffer> descrBuf;

	PatchReview<DOC> review;

	//typename DOC::package current;
	
	//Gtk::Table panelTable;
	//bool changed;
	//int currentPanel;

	Gtk::MenuBar menuBar;
	Gtk::Menu fileMenu;
	Gtk::Menu editMenu;
	Gtk::Menu optionsMenu;
	Gtk::Menu helpMenu;

	Gtk::Widget* undoMenuItem;
	Gtk::Widget* redoMenuItem;
	Gtk::Widget* reapplyMenuItem;
	Gtk::CheckMenuItem* computeIntensiveMenuItem;
	/*
	Gtk::Widget* saveMenuItem;
	Gtk::Widget* saveasMenuItem;
	Gtk::Widget* mergeMenuItem;
	Gtk::Widget* intersectMenuItem;
	Gtk::Widget* copyToOtherMenuItem;
	Gtk::Widget* moveToOtherMenuItem;
	Gtk::Widget* deleteUnselectedMenuItem;
	*/

	void checkUndo();
	void checkReapply();
	//void setChanged(bool val);

	// Invoked when the contents of the document change
	void on_changed();

	// Invoked when the current element changes
	void on_reselected();
	
	//void on_package_selected(typename DOC::package pkg) throw ();

public:
	DebtagsEditor(DOC& doc);
	virtual ~DebtagsEditor() {}

	//void on_open_debtags();
	void on_save();
	void on_send();
	//void on_save_as();
	void on_quit();
	void on_compute_intensive_data();
	//void on_merge();
	//void on_intersect();
	//void on_copy_to_other();
	//void on_move_to_other();
	//void on_delete_unselected();

	//void on_doc_change();
	void on_filename_change();
	void on_selection_change();
	//void on_tag_change() throw ();

	//void on_request_tagcoll_change(TagCollection<int>::Change change);
};

// vim:set ts=4 sw=4:
#endif
