#ifndef FILTER_PANEL_H
#define FILTER_PANEL_H

/*
 * The panel for viewing and editing the package filter
 *
 * Copyright (C) 2003--2007  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "TagSelector.h"

#include <sigc++/sigc++.h>
#include <gtkmm/entry.h>
#include <gtkmm/frame.h>
#include <gtkmm/paned.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treemodelsort.h>
#include <gtkmm/liststore.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/optionmenu.h>
#include <gtkmm/radiobutton.h>

template<class DOC>
class FilterPanel : public Gtk::Frame
{
protected:
	typedef typename DOC::Package Package;
	typedef typename DOC::Facet Facet;
	typedef typename DOC::Tag Tag;

public:
	typedef SigC::Signal0<void> type_signal_changed;
	typedef SigC::Signal1<void, Package> type_signal_selected;

protected:
	DOC& doc;
	Gtk::Entry nameFilter;
	Gtk::Entry maintFilter;
	Gtk::Entry ftextFilter;
	Gtk::OptionMenu statusFilter;
	//Gtk::OptionMenu specialQuery;
	Gtk::Button submitButton;
	Gtk::Label specialQuery;
	Gtk::Label foundStats;
	Gtk::TreeView itemList;
	Gtk::ScrolledWindow scrolledItemList;
	Glib::RefPtr<Gtk::ListStore> itemListModel;
	Glib::RefPtr<Gtk::TreeModelSort> sortedModel;
	Glib::RefPtr<Gtk::TreeModel> noModel;
	TagSelector tagSelector;

	int specialID;
	std::string specialExpression;
	Facet specialFacet;
	std::set<Package> specialPackages;

	// Tree model columns
	class ItemListModelColumns : public Gtk::TreeModel::ColumnRecord
	{
	public:
		ItemListModelColumns() { add(pkg); add(name); add(desc); }

		Gtk::TreeModelColumn<Package> pkg;
		Gtk::TreeModelColumn<Glib::ustring> name;
		Gtk::TreeModelColumn<Glib::ustring> desc;
	};

	ItemListModelColumns itemListModelColumns;

	type_signal_changed _signal_changed;
	type_signal_selected _signal_selected;

	void on_filter_changed();

	void on_selection_changed();

	void filterChanged();
	void reselect();
	void updateList();
	
	template<typename OUT>
	void outputSpecialColl(OUT& consumer);

public:
	FilterPanel(DOC& doc);
	virtual ~FilterPanel() {}

	/*
	const OpSet<std::string>& selectedTags() const { return tagSelector.selected(); }
	const OpSet<std::string>& selectedTags(const OpSet<string>& tagset)
		{ return tagSelector.selected(tagset); }

	std::map< std::string, OpSet<std::string> > getAllItems() { return itemList.getAllItems(); }
	std::map< std::string, OpSet<std::string> > getSelection() { return itemList.getSelection(); }
	int getSelectionSize() { return itemList.getSelectionSize(); }
	*/

	//bool isActive() { return itemList.is_focus(); }

	// Signals
	type_signal_changed signal_changed() throw () { return _signal_changed; }
	type_signal_selected signal_selected() throw () { return _signal_selected; }

	/*
	type_signal_list_focus signal_list_focus_in() throw () { return _signal_list_focus; }
	type_signal_list_focus signal_list_focus_out() throw () { return _signal_list_focus; }
	*/

	//virtual bool do_list_focus_in_event(GdkEventFocus*);
	
	void do_facets_dialog();
	void do_todo_dialog();

	template<typename ITEMS, typename TAGS>
    void insert(const ITEMS& items, const TAGS& tags);
};

// vim:set ts=4 sw=4:
#endif
