/*
 * Main application class
 *
 * Copyright (C) 2003,2004,2005,2006  Enrico Zini <enrico@debian.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "PatchReview.h"

#include "DebtagsDocument.h"
#include <tagcoll/patch.h>
#include <gtkmm/frame.h>
#include <gtkmm/paned.h>

#include <stdexcept>

using namespace std;

template<class DOC>
PatchReview<DOC>::PatchReview(DOC& doc)
	: doc(doc)
#if 0
, fpanel(doc), tagEditor(doc), rpanel(doc) /*panelTable(1, 2, true),*/ /* current(), changed(false) */
#endif
{
	//set_title("Review patch");
	//set_border_width(5);
	//set_default_size(400, 300);

	/* Initialize patchlist */
	patchListModel = Gtk::ListStore::create(patchListModelColumns);
	patchList.set_model(patchListModel);
	patchList.append_column("Package", patchListModelColumns.name);
	patchList.append_column("Changes", patchListModelColumns.patch);
	Glib::RefPtr<Gtk::TreeSelection> patchListSelection = patchList.get_selection();
	patchListSelection->set_mode(Gtk::SELECTION_SINGLE);
	scrolledPatchList.add(patchList);
	scrolledPatchList.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	Gtk::Frame* patchFrame = manage(new Gtk::Frame("List of patches"));
	patchFrame->add(scrolledPatchList);
	pack_start(*patchFrame, Gtk::PACK_EXPAND_WIDGET);

	/* Initialize hpaned */
	Gtk::HPaned* hPaned = manage(new Gtk::HPaned());
	pack_start(*hPaned, Gtk::PACK_EXPAND_WIDGET);

	/* Initialize taglist */
	tagListModel = Gtk::ListStore::create(tagListModelColumns);
	tagList.set_model(tagListModel);
	tagList.append_column("Tag", tagListModelColumns.name);
	tagList.append_column("Description", tagListModelColumns.sdesc);
	Glib::RefPtr<Gtk::TreeSelection> tagListSelection = tagList.get_selection();
	tagListSelection->set_mode(Gtk::SELECTION_SINGLE);
	//tagListSelection->signal_changed().connect(sigc::mem_fun(*this, &PatchReview<DOC>::on_tag_changed));
	scrolledTagList.add(tagList);
	scrolledTagList.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	Gtk::Frame* tagsFrame = manage(new Gtk::Frame("Changed tags"));
	tagsFrame->add(scrolledTagList);
	hPaned->add1(*tagsFrame);

	/* Initialize descr */
	descrBuf = Gtk::TextBuffer::create();
	descr.set_buffer(descrBuf);
	Gtk::ScrolledWindow* scr = manage(new Gtk::ScrolledWindow());
    scr->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	scr->add(descr);
	Gtk::Frame* descrFrame = manage(new Gtk::Frame("Package data"));
	descrFrame->add(*scr);
	hPaned->add2(*descrFrame);

	/* Connect signals */
	patchListSelection->signal_changed().connect(sigc::mem_fun(*this, &PatchReview<DOC>::on_patchList_selection_changed));

	doc.signal_changed().connect(sigc::mem_fun(*this, &PatchReview<DOC>::updatePackages));
	doc.signal_reselected().connect(sigc::mem_fun(*this, &PatchReview<DOC>::updateCurrent));

#if 0
	masterList.show();
	slaveList.show();
	scrolledMasterList.show();
	scrolledSlaveList.show();
	hbox.show();

	get_vbox()->pack_start(hbox);

	add_button(Gtk::Stock::OK, Gtk::RESPONSE_OK);
	add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);

	Gtk::TreeModel::Row row;
	FacetSet facets = doc.vocabulary().getFacets();
	for (FacetSet::const_iterator i = facets.begin();
			i != facets.end(); i++)
	{
		row = *(masterListModel->append());
		row[masterListModelColumns.facet] = *i;
		row[masterListModelColumns.label] = i->name();
	}
#endif

#if 0
	add(mainVBox);

	mainVBox.pack_start(menuBar, Gtk::PACK_SHRINK);
	mainVBox.pack_start(mainHPaned, Gtk::PACK_EXPAND_WIDGET);

	mainHPaned.add1(fpanel);

	Gtk::VBox* rvbox = manage(new Gtk::VBox());

	Gtk::ScrolledWindow* scr = manage(new Gtk::ScrolledWindow());
    scr->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	scr->add(descr);

	mainHPaned.add2(*rvbox);

	dataArea.append_page(*scr, "Description");
	dataArea.append_page(rpanel, "Related");

	rvbox->pack_start(tagEditor, Gtk::PACK_SHRINK);
	rvbox->pack_start(dataArea, Gtk::PACK_EXPAND_WIDGET);

	fpanel.signal_selected().connect(
			sigc::mem_fun(doc, &DOC::setCurrent));
	rpanel.signal_selected().connect(
			sigc::mem_fun(doc, &DOC::setCurrent));
	/*
	fpanel.signal_selected().connect(
			sigc::mem_fun(rpanel, &RelatedPanel<DOC>::do_pivot_change));
	rpanel.signal_selected().connect(
			sigc::mem_fun(rpanel, &RelatedPanel<DOC>::do_pivot_change));
	*/
	/*
	tagEditor.signal_changed().connect(
			sigc::mem_fun(*this, &DebtagsEditor<DOC>::on_tag_change));
	*/

	descrBuf = Gtk::TextBuffer::create();
	descr.set_buffer(descrBuf);

	/*
	entryHBox.pack_start(addLabel, Gtk::PACK_SHRINK);
	entryHBox.pack_start(addCombo, Gtk::PACK_EXPAND_WIDGET);
	entryHBox.pack_start(addButton, Gtk::PACK_SHRINK);
	*/
	//currentAdd.set_text("");
	
	/*
	allTags = doc.collection().getAllTags();
	addCombo.set_popdown_strings(allTags);
	//currentAdd.get_entry()->signal_changed().connect(
	addButton.signal_clicked().connect(
			SigC::slot(*this, &DebtagsEditor::on_addButton_clicked));
	*/

	//panelTable.attach(*panels[0], 0, 1, 0, 1, Gtk::FILL | Gtk::EXPAND | Gtk::SHRINK, Gtk::FILL | Gtk::EXPAND | Gtk::SHRINK, 1, 0);
	//panelTable.attach(*panels[1], 1, 2, 0, 1, Gtk::FILL | Gtk::EXPAND | Gtk::SHRINK, Gtk::FILL | Gtk::EXPAND | Gtk::SHRINK, 1, 0);

	/*
	doc.signal_changed().connect(SigC::slot(*this, &DebtagsEditor::on_doc_change));
	doc.signal_filename_changed().connect(SigC::slot(*this, &DebtagsEditor::on_filename_change));
	panels[0]->signal_selection_changed().connect(SigC::slot(*this, &DebtagsEditor::on_selection_change));
	panels[1]->signal_selection_changed().connect(SigC::slot(*this, &DebtagsEditor::on_selection_change));
	panels[0]->signal_focus_in().connect(SigC::slot(*this, &DebtagsEditor::on_leftpanel_focus));
	panels[1]->signal_focus_in().connect(SigC::slot(*this, &DebtagsEditor::on_rightpanel_focus));
	panels[0]->signal_request_tagcoll_change().connect(SigC::slot(*this, &DebtagsEditor::on_request_tagcoll_change));
	panels[1]->signal_request_tagcoll_change().connect(SigC::slot(*this, &DebtagsEditor::on_request_tagcoll_change));
	panels[0]->signal_request_tagset_merge().connect(SigC::slot(*this, &DebtagsEditor::on_merge));
	panels[1]->signal_request_tagset_merge().connect(SigC::slot(*this, &DebtagsEditor::on_merge));
	panels[0]->signal_request_tagset_intersect().connect(SigC::slot(*this, &DebtagsEditor::on_intersect));
	panels[1]->signal_request_tagset_intersect().connect(SigC::slot(*this, &DebtagsEditor::on_intersect));
	panels[0]->signal_request_item_copy().connect(SigC::slot(*this, &DebtagsEditor::on_copy_to_other));
	panels[1]->signal_request_item_copy().connect(SigC::slot(*this, &DebtagsEditor::on_copy_to_other));
	panels[0]->signal_request_item_move().connect(SigC::slot(*this, &DebtagsEditor::on_move_to_other));
	panels[1]->signal_request_item_move().connect(SigC::slot(*this, &DebtagsEditor::on_move_to_other));
	panels[0]->signal_select_tagset().connect(SigC::slot(*this, &DebtagsEditor::on_select_tagset_panel1));
	panels[1]->signal_select_tagset().connect(SigC::slot(*this, &DebtagsEditor::on_select_tagset_panel2));
	panels[0]->signal_select_tagset_other_panel().connect(SigC::slot(*this, &DebtagsEditor::on_select_tagset_panel2));
	panels[1]->signal_select_tagset_other_panel().connect(SigC::slot(*this, &DebtagsEditor::on_select_tagset_panel1));
*/

	menuBar.items().push_back(Gtk::Menu_Helpers::MenuElem("_File", fileMenu));
	menuBar.items().push_back(Gtk::Menu_Helpers::MenuElem("_Edit", editMenu));
	menuBar.items().push_back(Gtk::Menu_Helpers::MenuElem("_Options", optionsMenu));

	/*
	fileMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("Load _Debtags",
				SigC::slot(*this, &DebtagsEditor::on_open_debtags)));
	fileMenu.items().push_back(Gtk::Menu_Helpers::SeparatorElem());
	*/

	fileMenu.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::SAVE,
				sigc::mem_fun(*this, &DebtagsEditor::on_save)));
	
	fileMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("_Mail changes to central database",
				sigc::mem_fun(*this, &DebtagsEditor::on_send)));
	
	/*
	saveMenuItem = &(fileMenu.items().back());
	saveMenuItem->set_sensitive(false);
	fileMenu.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::SAVE_AS,
				SigC::slot(*this, &DebtagsEditor::on_save_as)));
	saveasMenuItem = &(fileMenu.items().back());
	fileMenu.items().push_back(Gtk::Menu_Helpers::SeparatorElem());
	*/

	fileMenu.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::QUIT,
				sigc::mem_fun(*this, &DebtagsEditor::on_quit)));


	editMenu.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::UNDO,
				sigc::mem_fun(doc, &DOC::undo)));
	undoMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::REDO,
				sigc::mem_fun(doc, &DOC::redo)));
	redoMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("_Repeat last change",
				sigc::mem_fun(doc, &DOC::reapplyToCurrent)));
	reapplyMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::SeparatorElem());

	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("_TODO dialog",
				sigc::mem_fun(fpanel, &FilterPanel<DOC>::do_todo_dialog)));
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("_Facet dialog",
				sigc::mem_fun(fpanel, &FilterPanel<DOC>::do_facets_dialog)));

	optionsMenu.items().push_back(Gtk::Menu_Helpers::CheckMenuElem("_Disable slow experimental algorithms",
				sigc::mem_fun(*this, &DebtagsEditor::on_compute_intensive_data)));
	computeIntensiveMenuItem = dynamic_cast<Gtk::CheckMenuItem*>(&(optionsMenu.items().back()));
	computeIntensiveMenuItem->set_active(doc.getComputeIntensive());

	/*
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("_Merge",
				SigC::slot(*this, &DebtagsEditor::on_merge)));
	mergeMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("_Intersect",
				SigC::slot(*this, &DebtagsEditor::on_intersect)));
	intersectMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("Co_py to other panel",
				SigC::slot(*this, &DebtagsEditor::on_copy_to_other)));
	copyToOtherMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("Mo_ve to other panel",
				SigC::slot(*this, &DebtagsEditor::on_move_to_other)));
	moveToOtherMenuItem = &(editMenu.items().back());
	editMenu.items().push_back(Gtk::Menu_Helpers::MenuElem("Delete _unselected tags",
				SigC::slot(*this, &DebtagsEditor::on_delete_unselected)));
	deleteUnselectedMenuItem = &(editMenu.items().back());
	*/

	//menuBar.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::HELP, helpMenu));
	/*
	checkUndo();
	checkReapply();
	*/
	//setChanged(false);
	//on_filename_change();

	on_changed();

	doc.signal_changed().connect(sigc::mem_fun(*this, &DebtagsEditor<DOC>::on_changed));
	doc.signal_reselected().connect(sigc::mem_fun(*this, &DebtagsEditor<DOC>::on_reselected));
#endif
	updatePackages();

	show_all_children();
}

template<class DOC>
void PatchReview<DOC>::on_patchList_selection_changed()
{
	Glib::RefPtr<Gtk::TreeSelection> sel = patchList.get_selection();
	Gtk::TreeModel::iterator iter = sel->get_selected();
	if (iter)
	{
		Gtk::TreeModel::Row row = *iter;
		//Debtags::Package p = doc.packageDB().getPackage(row[itemListModelColumns.pkg]);
		//fprintf(stderr, "Selected %.*s\n", PFSTR(p.name()));
		Package up = row[patchListModelColumns.pkg];
		doc.setCurrent(up);
	}
}

template<class DOC>
void PatchReview<DOC>::updatePackages()
{
	typedef tagcoll::PatchList<Package, Tag> patch_t;
	const patch_t& patch = doc.getPatch();

	patchListModel->clear();

	for (typename patch_t::const_iterator i = patch.begin();
			i != patch.end(); i++)
	{
		if (i->first != Package())
		{
			Gtk::TreeModel::Row row;
			row = *(patchListModel->append());
			row[patchListModelColumns.pkg] = i->first;
			row[patchListModelColumns.name] = i->first;
			const std::set<Tag>& added = i->second.added;
			const std::set<Tag>& removed = i->second.removed;
			string p;
			for (typename std::set<Tag>::const_iterator j = added.begin(); j != added.end(); j++)
				if (p.empty())
					p += "+" + j->fullname();
				else
					p += ", +" + j->fullname();
			for (typename std::set<Tag>::const_iterator j = removed.begin(); j != removed.end(); j++)
				if (p.empty())
					p += "-" + j->fullname();
				else
					p += ", -" + j->fullname();
			row[patchListModelColumns.patch] = p;
		}
	}

	updateCurrent();
}

template<class DOC>
void PatchReview<DOC>::updateCurrent()
{
	typedef tagcoll::PatchList<Package, Tag> patch_t;
	const patch_t& patch = doc.getPatch();
	typename patch_t::const_iterator p = patch.find(doc.current());
	Glib::RefPtr<Gtk::TreeSelection> sel = patchList.get_selection();

	tagListModel->clear();
	sel->unselect_all();

	if (p != patch.end())
	{
		// Update description
		try {
			descrBuf->set_text(doc.apt().rawRecord(doc.current()));
		} catch (std::out_of_range& e) {
			descrBuf->set_text("Unable to access package informations");
		}

		const std::set<Tag>& added = p->second.added;
		const std::set<Tag>& removed = p->second.removed;

		for (typename std::set<Tag>::const_iterator i = added.begin();
				i != added.end(); i++)
		{
			Gtk::TreeModel::Row row;
			row = *(tagListModel->append());
			row[tagListModelColumns.tag] = *i;
			row[tagListModelColumns.name] = "+" + i->fullname();
			row[tagListModelColumns.sdesc] = i->shortDescription();
		}

		for (typename std::set<Tag>::const_iterator i = removed.begin();
				i != removed.end(); i++)
		{
			Gtk::TreeModel::Row row;
			row = *(tagListModel->append());
			row[tagListModelColumns.tag] = *i;
			row[tagListModelColumns.name] = "-" + i->fullname();
			row[tagListModelColumns.sdesc] = i->shortDescription();
		}

		for (Gtk::ListStore::const_iterator i = patchListModel->children().begin();
				i != patchListModel->children().end(); i++)
		{
			Package thisPkg = (*i)[patchListModelColumns.pkg];
			if (thisPkg == doc.current())
			{
				sel->select(patchListModel->get_path(i));
				patchList.scroll_to_row(patchListModel->get_path(i));
				break;
			}
		}
	} else {
		descrBuf->set_text("No patch is currently selected");
	}
}

#if 0

template<class DOC>
void DebtagsEditor<DOC>::on_changed()
{
	checkUndo();
	on_reselected();
}

template<class DOC>
void DebtagsEditor<DOC>::on_reselected()
{
	checkReapply();
	if (doc.current() == typename DOC::package())
		descrBuf->set_text("No packages are currently selected");
	else
		descrBuf->set_text(doc.current().candidateVersion().completeRecord());
}
#endif

#if 0
template<class DOC>
void DebtagsEditor<DOC>::on_package_selected(typename DOC::package pkg) throw ()
{
	doc.setCurrent(pkg);
	/*
	current = pkg;
	descrBuf->set_text(pkg.candidateVersion().completeRecord());
	tagEditor.setSelected(doc.tagdb().getTags(pkg));
	checkReapply();
	*/
}
#endif

/*
template<class DOC>
void DebtagsEditor<DOC>::on_tag_change() throw ()
{
	TagSet newTags = tagEditor.selected();

	// Make the change
	PatchList<typename DOC::package, Tag> change;
	TagSet oldTags = doc.tagdb().getTags(current);
	change.addPatch(Patch<typename DOC::package, Tag>(current, newTags - oldTags, oldTags - newTags));
	doc.applyChange(change);

	// TODO: farlo da solo quando cambia il doc
	rpanel.do_pivot_change(current);
}
*/

/*
template<class DOC>
void DebtagsEditor<DOC>::setChanged(bool val)
{
	changed = val;
	//on_filename_change();
}
*/

/*
template<class DOC>
void DebtagsEditor<DOC>::on_doc_change()
{
	checkUndo();
	checkReapply();
	setChanged(true);
}
*/

/*
template<class DOC>
void DebtagsEditor<DOC>::on_filename_change()
{
	if (doc.fileName().empty())
	{
		set_title(string("Tagged Collection Editor - debtags Database") + (changed ? " [*]" : ""));
		saveMenuItem->set_sensitive(false);
	}
	else
	{
		set_title("Tagged Collection Editor - " + doc.fileName() + (changed ? " [*]" : ""));
		saveMenuItem->set_sensitive(changed);
	}
}
*/

#if 0
template<class DOC>
void DebtagsEditor<DOC>::checkUndo()
{
	undoMenuItem->set_sensitive(doc.canUndo());
	redoMenuItem->set_sensitive(doc.canRedo());
}

template<class DOC>
void DebtagsEditor<DOC>::checkReapply()
{
	reapplyMenuItem->set_sensitive(doc.canReapply(doc.current()));
}
#endif

/*
template<class DOC>
void DebtagsEditor<DOC>::on_open_debtags()
{
	try {
		doc.load();
	} catch (Exception& e) {
		warning("%s: %.*s", e.type(), PFSTR(e.desc()));
	}
}
*/

#if 0
template<class DOC>
void DebtagsEditor<DOC>::on_save()
{
	//if (!doc.fileName().empty())
	//{
		//doc.save(doc.fileName());
		//setChanged(false);
	//}
	try {
		doc.save();
		//setChanged(false);
	} catch (Exception& e) {
		Gtk::MessageDialog err(string("Save failed: ") + e.desc() + " (" + e.type() + ")",
				false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
		err.run();
	}
}

template<class DOC>
void DebtagsEditor<DOC>::on_send()
{
	//if (!doc.fileName().empty())
	//{
		//doc.save(doc.fileName());
		//setChanged(false);
	//}
	try {
		doc.send();
		Gtk::MessageDialog oki("Mail sent.", false, Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true);
		oki.run();
	} catch (Exception& e) {
		Gtk::MessageDialog err(string("Send failed: ") + e.desc() + " (" + e.type() + ")",
				false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
		err.run();
	}
}

/*
template<class DOC>
void DebtagsEditor<DOC>::on_save_as()
{
	Gtk::FileSelection dialog("Please select the file name to save as");
	dialog.set_transient_for(*this);
	//dialog.get_file_list()->get_parent()->hide(); //Prevent the user from selecting a file.

	int result = dialog.run();

	//Handle the response:
	switch (result)
	{
		case Gtk::RESPONSE_OK:
		{
			try {
				doc.save(dialog.get_filename());
			} catch (Exception& e) {
				warning("%s: %.*s", e.type(), PFSTR(e.desc()));
			}
			setChanged(false);
			break;
		}
		case Gtk::RESPONSE_CANCEL:
		{
			break;
		}
		default:
		{
			warning("Unexpected button clicked in save as... file selection dialog");
			break;
		}
	}
}
*/

template<class DOC>
void DebtagsEditor<DOC>::on_quit()
{
	hide();
}

template<class DOC>
void DebtagsEditor<DOC>::on_compute_intensive_data()
{
	doc.setComputeIntensive(!computeIntensiveMenuItem->get_active());
}
#endif

template class PatchReview<DebtagsDocument>;

// vim:set ts=4 sw=4:
