#ifndef RELATED_PANEL_H
#define RELATED_PANEL_H

/*
 * The panel for viewing and editing the package filter
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <sigc++/sigc++.h>
#include <gtkmm/box.h>
#include <gtkmm/entry.h>
#include <gtkmm/frame.h>
#include <gtkmm/paned.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/optionmenu.h>


template<class DOC>
class RelatedPanel : public Gtk::VBox
{
protected:
	typedef typename DOC::Package Package;
	typedef typename DOC::Facet Facet;
	typedef typename DOC::Tag Tag;

public:
	typedef SigC::Signal1<void, Package> type_signal_selected;

protected:
	DOC& doc;
	Gtk::Label foundStats;
	Gtk::TreeView itemList;
	Gtk::ScrolledWindow scrolledItemList;
	Glib::RefPtr<Gtk::ListStore> itemListModel;

	Package pivot;
	//PackageBuffer pkgs;

	// Tree model columns
	class ItemListModelColumns : public Gtk::TreeModel::ColumnRecord
	{
	public:
		ItemListModelColumns() { add(pkg); add(name); add(desc); }

		Gtk::TreeModelColumn<Package> pkg;
		Gtk::TreeModelColumn<Glib::ustring> name;
		Gtk::TreeModelColumn<Glib::ustring> desc;
	};

	ItemListModelColumns itemListModelColumns;

	type_signal_selected _signal_selected;

	void on_selection_changed() throw ();

	void updateList() throw ();
	
public:
	RelatedPanel(DOC& doc);
	virtual ~RelatedPanel() {}

	void do_pivot_change(const Package& _pivot) throw ()
	{
		if (doc.getComputeIntensive())
		{
			pivot = _pivot;
			updateList();
		} else {
			itemListModel->clear();
		}
	}

	// Signals
	type_signal_selected signal_selected() throw () { return _signal_selected; }
};

// vim:set ts=4 sw=4:
#endif
