/*
 * Tag list and selector widget
 *
 * Copyright (C) 2003--2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "TagEditor.h"
#include "TagMenu.h"
#include "DebtagsDocument.h"
#include "AddButtons.h"

#include "Environment.h"

#include <wibble/operators.h>
#include <gtkmm/eventbox.h>

using namespace std;
using namespace wibble::operators;

template<class DOC>
bool TagEditor<DOC>::TagList::fillMenu(const Tag& tag, const std::set<Tag>& selected)
{
	if (tag == Tag())
		return false;

	if (selected.size() < 2)
	{
#if 0
		this->itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Select this tag",
					sigc::bind< Tag >(
						sigc::mem_fun(*this, &TagEditor<DOC>::do_signal_select_tag), tag)));
#endif
		this->itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Delete this tag",
					sigc::bind< Tag >(
						sigc::mem_fun(te, &TagEditor<DOC>::on_del_from_selection), tag)));
	}
	else
	{
#if 0
		// TODO: build the tag set with all the selected tags
		this->itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Merge",
					sigc::mem_fun(*this, &ItemList::do_signal_request_tagset_merge)));
		this->itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Intersect",
					sigc::mem_fun(*this, &ItemList::do_signal_request_tagset_intersect)));
#endif
	}
#if 0
	this->itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Copy to other panel",
				sigc::mem_fun(*this, &ItemList::do_signal_request_item_copy)));
	this->itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Move to other panel",
				sigc::mem_fun(*this, &ItemList::do_signal_request_item_move)));
#endif

#if 0
	TagMenu<TagcollDocument<string> >* addMenu = new TagMenu<TagcollDocument<string> >();
	addMenu->set_manage();
	addMenu->populateUnselected(doc, ts);
	string stag = tag;
	addMenu->signal_selected().connect(
				sigc::mem_fun(*this, &ItemList::on_add_tag));
	itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("_Add...", *addMenu));
#endif	

#if 0
	if (!ts.empty())
	{
		itemPopup.items().push_back(Gtk::Menu_Helpers::SeparatorElem());
		for (TagSet::const_iterator i = ts.begin();
				i != ts.end(); i++)
			itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Remove " + i->fullname(),
				sigc::bind<Tag>(
					sigc::mem_fun(*this, &ItemList::on_remove_tag), *i)));
	}
#endif

	return true;
}

template<class DOC>
void TagEditor<DOC>::do_add_tag(Tag tag)
{
	_signal_add_tag.emit(tag);
}

template<class DOC>
void TagEditor<DOC>::do_remove_tag(Tag tag)
{
	_signal_remove_tag.emit(tag);
}

template<class DOC>
void TagEditor<DOC>::on_add_to_selection(Tag tag)
{
	//printf("Add to sel: %.*s\n", PFSTR(tag));
	std::set<Tag> tags;
	tags |= tag;

	doc.applyChange(
			tagcoll::Patch<typename DOC::Package, Tag>(
				doc.current(),
				tags,
				std::set<Tag>()));
			
	/*
	TagSet _selected = doc.currentTags();
	unsigned int count_pre = _selected.size();
	_selected += tag;
	if (count_pre != _selected.size())
	{
		updateView();
		do_changed();
	}
	*/
}

template<class DOC>
void TagEditor<DOC>::on_del_from_selection(Tag tag)
{
	//printf("Del from sel: %.*s\n", PFSTR(tag));
	std::set<Tag> tags;
	tags |= tag;

	doc.applyChange(
			tagcoll::Patch<typename DOC::Package, Tag>(
				doc.current(),
				std::set<Tag>(),
				tags));

	/*
	unsigned int count_pre = _selected.size();
	_selected -= tag;
	if (count_pre != _selected.size())
	{
		updateView();
		do_changed();
	}
	*/
}

template<class DOC>
void TagEditor<DOC>::on_changed()
{
	time_t start = time(NULL);
	//TagSet allTags = doc.vocabulary().getTags();
	//_selected = _selected ^ allTags;

	updateView();
	time_t end = time(NULL);
	if (end != start)
		fprintf(stderr, "TagEditor<DOC>::on_document_changed: %ld seconds\n", (end-start));
}

template<class DOC>
TagEditor<DOC>::TagEditor(DOC& doc)
	: doc(doc), itemList(doc, *this)
{
	// Add the TreeView, inside a ScrolledWindow
	scrolledItemList.add(itemList);
	// Only show the scrollbars when they are necessary:
	scrolledItemList.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	pack_start(scrolledItemList, true, true);

	Gtk::HBox* hbox = manage(new Gtk::HBox());
	pack_start(*hbox, false, false);

	AddButton<DOC>* add = newAddAllButton(doc, doc, "Add");
	buttonAdd = manage(add);
	hbox->pack_start(*add, true, true);
	add->signal_selected().connect(sigc::mem_fun(*this, &TagEditor<DOC>::on_add_to_selection));

	AddButton<DOC>* addD = newAddDiscriminantButton(doc, doc, "Add discriminant");
	buttonAddD = manage(addD);
	hbox->pack_start(*addD, true, true);
	addD->signal_selected().connect(sigc::mem_fun(*this, &TagEditor<DOC>::on_add_to_selection));

	AddButton<DOC>* addR = newAddRelevantButton(doc, doc, "Add relevant");
	buttonAddR = manage(addR);
	hbox->pack_start(*addR, true, true);
	addR->signal_selected().connect(sigc::mem_fun(*this, &TagEditor<DOC>::on_add_to_selection));

	updateView();

	//Only show the scrollbars when they are necessary
	//set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

	doc.signal_changed().connect(sigc::mem_fun(*this, &TagEditor<DOC>::on_changed));
	doc.signal_reselected().connect(sigc::mem_fun(*this, &TagEditor<DOC>::on_changed));
}

template<class DOC>
void TagEditor<DOC>::on_selectedTagList_drag_data_get(
		const Glib::RefPtr<Gdk::DragContext>&, Gtk::SelectionData& selection_data, guint, guint, Tag tag)
{
	string fullname = tag.fullname();
	selection_data.set(selection_data.get_target(), 8, (const guchar*)fullname.data(), fullname.size());
}

template<class DOC>
void TagEditor<DOC>::updateView()
{
	time_t start = time(NULL);

	std::set<Tag> _selected = doc.currentTags();

	itemList.display(_selected);

	buttonAdd->set_sensitive(doc.current() != Package());
	buttonAddD->set_sensitive(doc.current() != Package());
	buttonAddR->set_sensitive(doc.current() != Package());

	time_t end = time(NULL);
	if (end != start)
		fprintf(stderr, "TagEditor<DOC>::updateList: %ld seconds\n", (end-start));
}



template class TagEditor<DebtagsDocument>;

#include <tagcoll/coll/fast.tcc>
#include <tagcoll/coll/patched.tcc>

// vim:set ts=4 sw=4:
