#ifndef TAG_EDITOR_H
#define TAG_EDITOR_H

/*
 * Tag list and selector widget
 *
 * Copyright (C) 2003--2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gtkmm/scrolledwindow.h>
#include <gtkmm/box.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include "TagsetList.h"

template<class DOC>
class TagEditor : public Gtk::VBox
{
protected:
	typedef typename DOC::Facet Facet;
	typedef typename DOC::Tag Tag;
	typedef typename DOC::Package Package;

public:
	//typedef SigC::Signal0<void> type_signal_changed;
	typedef SigC::Signal1<void, Tag> type_signal_add_tag;
	typedef SigC::Signal1<void, Tag> type_signal_remove_tag;

protected:
	class TagList : public TagsetList<DOC>
	{
	protected:
		// Format the tag description from a tag
		virtual std::string format(const Tag& tag)
		{
			return "[" + tag.fullname() + "] " +
					tag.facet().shortDescription() + " :: " + tag.shortDescription();
		}

		virtual bool fillMenu(const Tag& tag, const std::set<Tag>& selected);

		DOC& doc;
		TagEditor<DOC>& te;

	public:
		TagList(DOC& doc, TagEditor<DOC>& te) : doc(doc), te(te) {}
	};

	DOC& doc;
	
	TagList itemList;
	Gtk::ScrolledWindow scrolledItemList;

	Gtk::Widget* buttonAdd;
	Gtk::Widget* buttonAddR;
	Gtk::Widget* buttonAddD;

	//type_signal_changed _signal_changed;
	type_signal_add_tag _signal_add_tag;
	type_signal_remove_tag _signal_remove_tag;

	void updateView();

	void on_add_to_selection(Tag tag);
	void on_del_from_selection(Tag tag);

	void on_changed();

	void on_selectedTagList_drag_data_get(
		        const Glib::RefPtr<Gdk::DragContext>&, Gtk::SelectionData& selection_data, guint, guint, Tag tag);

public:
	TagEditor(DOC& doc);
	virtual ~TagEditor() {}

	//type_signal_changed signal_changed() throw () { return _signal_changed; }
	type_signal_add_tag signal_add_tag() throw () { return _signal_add_tag; }
	type_signal_remove_tag signal_remove_tag() throw () { return _signal_remove_tag; }

	//void do_changed();
	void do_add_tag(Tag tag);
	void do_remove_tag(Tag tag);
};

// vim:set ts=4 sw=4:
#endif
