/*
 * Tag menu
 *
 * Copyright (C) 2003--2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "TagMenu.h"

#include "Environment.h"
#include "DebtagsDocument.h"

#include <wibble/operators.h>
#if 0
#include <tagcoll/SmartHierarchy.h>
#include <apt-front/cache/component/debtags/utils.h>
#include <tagcoll/CardinalityStore.h>
#endif

#include <map>
#include <vector>
#include <string>

using namespace std;
using namespace wibble::operators;
//using namespace Tagcoll;
//using namespace aptFront::cache::component::debtags;

//template class TagMenu<DebtagsDocument>;

template<class DOC>
void TagMenu<DOC>::do_selected(Tag tag)
{
	_signal_selected.emit(tag);
}

template<class DOC>
void TagMenu<DOC>::populateWith(const std::set<Tag>& tags) throw ()
{
	// Needs std:: not to be confused with some other map in gtkmm
	std::map<Facet, vector<Tag> > contents;
	for (typename std::set<Tag>::const_iterator i = tags.begin(); i != tags.end(); i++)
		contents[i->facet()].push_back(*i);

	for (typename std::map<Facet, vector<Tag> >::const_iterator i = contents.begin(); i != contents.end(); i++)
	{
		Gtk::Menu* submenu = manage(new Gtk::Menu);
		for (typename vector<Tag>::const_iterator j = i->second.begin(); j != i->second.end(); j++)
		{
			submenu->items().push_back(Gtk::Menu_Helpers::MenuElem(
						"[" + j->name() + "] " + j->shortDescription(),
						sigc::bind<Tag>(
							sigc::mem_fun(*this, &TagMenu::do_selected), *j)));
			//printf("Adding %.*s::%.*s\n", PFSTR(i->first), PFSTR(*j));
		}
		if (i->first.name().empty())
			items().push_back(Gtk::Menu_Helpers::MenuElem("(legacy)", *submenu));
		else
			items().push_back(Gtk::Menu_Helpers::MenuElem("[" + i->first.name() + "] " + i->first.shortDescription(), *submenu));
	}
}

template<class DOC>
void TagMenu<DOC>::populateWith(const std::set<Tag>& tags, const Facet& facet) throw ()
{
	for (typename std::set<Tag>::const_iterator i = tags.begin(); i != tags.end(); i++)
	{
		//printf("Facet: %.*s, tag: %.*s\n", PFSTR(f), PFSTR(t));
		if (i->facet() == facet)
		{
			//printf("Adding %.*s\n", PFSTR(*i));
			items().push_back(Gtk::Menu_Helpers::MenuElem(
						i->name(),
						sigc::bind<Tag>(
							sigc::mem_fun(*this, &TagMenu::do_selected), *i)));
		}
	}
}

template<class DOC>
void TagMenu<DOC>::populateWith(const std::set<Tag>& tags, const std::set<Facet>& toplevelFacets) throw ()
{
	// Needs std:: not to be confused with some other map
	std::map<Facet, vector<Tag> > contents;
    for (typename std::set<Tag>::const_iterator i = tags.begin(); i != tags.end(); i++)
	{
		// Filter out non-toplevel facets
		if (! (i->facet() <= toplevelFacets))
			continue;

		typename std::map<Facet, vector<Tag> >::iterator j = contents.find(i->facet());
		if (j != contents.end())
			j->second.push_back(*i);
		else
		{
			std::vector<Tag> v;
			v.push_back(*i);
			contents.insert(pair<Facet, vector<Tag> >(i->facet(), v));
		}
	}

	for (typename std::map<Facet, vector<Tag> >::const_iterator i = contents.begin(); i != contents.end(); i++)
	{
		Gtk::Menu* submenu = manage(new Gtk::Menu);
		for (typename vector<Tag>::const_iterator j = i->second.begin(); j != i->second.end(); j++)
		{
			submenu->items().push_back(Gtk::Menu_Helpers::MenuElem(
						j->name(),
						sigc::bind<Tag>(
							sigc::mem_fun(*this, &TagMenu::do_selected), *j)));
			//printf("Adding %.*s::%.*s\n", PFSTR(i->first), PFSTR(*j));
		}
		if (i->first.name().empty())
			items().push_back(Gtk::Menu_Helpers::MenuElem("(legacy)", *submenu));
		else
			items().push_back(Gtk::Menu_Helpers::MenuElem(i->first.name(), *submenu));
	}
}


template<class DOC>
void TagMenu<DOC>::populateAll(const DOC& doc) throw ()
{
	populateWith(doc.vocabulary().tags());
}

template<class DOC>
void TagMenu<DOC>::populateAvailable(const DOC& doc, const std::set<Tag>& selectedTags) throw ()
{
	std::set<Tag> tags = selectedTags.empty() ?
		  doc.debtags().getAllTags()
		: doc.debtags().getCompanionTags(selectedTags);
	//OpSet<Tag> tags = Debtags::Environment::get().tagdb().getCompanionTags(selectedTags);
	populateWith(tags);
}

template<class DOC>
void TagMenu<DOC>::populateAvailable(const DOC& doc, const std::set<Tag>& selectedTags, const Facet& facet) throw ()
{
	std::set<Tag> tags = doc.debtags().getCompanionTags(selectedTags);
	populateWith(tags, facet);
}

template<class DOC>
void TagMenu<DOC>::populateUnselected(const DOC& doc, const std::set<Tag>& selectedTags) throw ()
{
	std::set<Tag> tags = doc.vocabulary().tags() - selectedTags;
	//for (OpSet<string>::const_iterator i = tags.begin(); i != tags.end(); i++)
		//printf("Sel: %.*s\n", PFSTR(*i));
	populateWith(tags);
}

template<class DOC>
void TagMenu<DOC>::populateUnselected(const DOC& doc, const std::set<Tag>& selectedTags, const Facet& facet) throw ()
{
	std::set<Tag> tags = doc.vocabulary().tags() - selectedTags;
	//for (OpSet<string>::const_iterator i = tags.begin(); i != tags.end(); i++)
		//printf("Sel: %.*s\n", PFSTR(*i));
	populateWith(tags, facet);
}



#include "TagMenu.tcc"

template class TagMenu<DebtagsDocument>;

#include <ept/debtags/debtags.tcc>

// vim:set ts=4 sw=4:
