/*
 * Tag menu
 *
 * Copyright (C) 2003--2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef TAG_MENU_TCC
#define TAG_MENU_TCC

#include "TagMenu.h"

#include <wibble/operators.h>
#include <tagcoll/SmartHierarchy.h>
#include <ept/debtags/utils.h>

using namespace wibble::operators;

template<class DOC> template<typename ROCOLL>
void TagMenu<DOC>::populateAvailable(const DOC& doc, const std::set<Tag>& selectedTags, const ROCOLL& items) throw ()
{
	/*
	OpSet<Tag> merged;
	OpSet<Tag> inters;

	// Create merged tagset
	// Create intersected tagset
	for (PackageSet::const_iterator i = items.begin(); i != items.end(); i++)
	{
		OpSet<Tag> tags = (*i).tags();
		if (i == items.begin())
			inters = tags;
		else
			inters ^= tags;
		merged += tags;
	}

	// Use merged - intersected
	populateWith(merged - inters);
	*/
	populateWith(items.getAllTags() - selectedTags);
}

template<class DOC> template<typename ROCOLL>
void TagMenu<DOC>::populateAvailableSmart(
		const DOC& doc,
		const std::set<Tag>& selectedTags,
		const ROCOLL& items) throw ()
{
	// Compute the minimum set of toplevel facets that can be used to select
	// all items in `items'
	typedef tagcoll::HierarchyNode< tagcoll::coll::Fast<Package, Facet> > Node;

	tagcoll::coll::Fast<Package, Facet> coll;
	std::set<Facet> toplevelFacets;

	// Make a new collection tagged with facets instead of tags
	items.output(ept::debtags::tagToFacet(inserter(coll)));

	Facet f;
	auto_ptr<Node> node(tagcoll::smartHierarchyNode(f, coll, 0));
	for (typename Node::iterator i = node->begin(); i != node->end(); ++i)
		toplevelFacets |= (*i)->tag();

	if (toplevelFacets.size() > 5)
		populateWith(items.getAllTags() - selectedTags, toplevelFacets);
	else
		populateWith(items.getAllTags() - selectedTags);
}

#include <tagcoll/coll/fast.tcc>
#include <tagcoll/SmartHierarchy.tcc>

#endif

// vim:set ts=4 sw=4:
