#ifndef TAG_SELECTOR_H
#define TAG_SELECTOR_H

/*
 * Tag list and selector widget
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gtkmm/scrolledwindow.h>
#include <gtkmm/box.h>
#include "DebtagsDocument.h"
#include "TagsetList.h"

class TagSelector : public Gtk::VBox
{
protected:
	typedef DebtagsDocument::Facet Facet;
	typedef DebtagsDocument::Tag Tag;
	typedef DebtagsDocument::Package Package;

public:
	typedef SigC::Signal0<void> type_signal_changed;

protected:
	class TagList : public TagsetList<DebtagsDocument>
	{
	protected:
		// Format the tag description from a tag
		virtual std::string format(const Tag& tag)
		{
			return tag.fullname();
		}

		virtual bool fillMenu(const Tag& tag, const std::set<Tag>& selected);

		DebtagsDocument& doc;
		TagSelector& ts;

	public:
		TagList(DebtagsDocument& doc, TagSelector& ts) : doc(doc), ts(ts) {}
	};

	DebtagsDocument& doc;

	std::set<DebtagsDocument::Tag> _selected;
	
	TagList itemList;
	Gtk::ScrolledWindow scrolledItemList;

	type_signal_changed _signal_changed;

	void updateView();

	void on_add_to_selection(Tag tag);
	void on_del_from_selection(Tag tag);

	void on_document_changed();

	void on_selectedTagList_drag_data_get(
		        const Glib::RefPtr<Gdk::DragContext>&, Gtk::SelectionData& selection_data, guint, guint, DebtagsDocument::Tag tag);

public:
	TagSelector(DebtagsDocument& doc);
	virtual ~TagSelector() {}

	type_signal_changed signal_changed() throw () { return _signal_changed; }

	std::set<Tag> currentTags() const { return _selected; }
	virtual void do_changed();

	const std::set<DebtagsDocument::Tag>& selected() const throw () { return _selected; }
	const std::set<DebtagsDocument::Tag>& selected(const std::set<DebtagsDocument::Tag>& tagset) throw ()
	{
		_selected = tagset;
		updateView();
		do_changed();
		return _selected;
	}
};

// vim:set ts=4 sw=4:
#endif
