/*
 * tagcolledit - GUI for editing tagged collections
 *
 * Copyright (C) 2003--2006  Enrico Zini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#define APPNAME PACKAGE_NAME
#else
#warning No config.h found: using fallback values
#define APPNAME __FILE__
#define PACKAGE_VERSION "unknown"
#endif

#include <wibble/exception.h>
#include <ept/debtags/debtags.h>

#include "Environment.h"
#include "DebtagsEditOptions.h"

#include "DebtagsDocument.h"
#include "DebtagsEditor.h"

#include <gtkmm/main.h>

using namespace std;

int main(int argc, char* argv[])
{
	try {
		// Install the handler for unexpected exceptions
		wibble::exception::InstallUnexpected installUnexpected;

		wibble::commandline::DebtagsEditOptions opts;

		if (opts.parse(argc, (const char**)argv))
			return 0;

		if (opts.out_verbose->boolValue())
			::Environment::get().verbose(true);

		if (opts.out_debug->boolValue())
			::Environment::get().debug(true);

		/*
		if (!pkg::debtags::Debtags::hasTagDatabase())
		{
			fprintf(stderr, "Debtags database has not been found.  Please run debtags update and try again\n");
			return 1;
		}
		*/

		//ept::init();

		//Debtags::Environment::init(true);
		//printf("State dir is %.*s\n", PFSTR(Debtags::TagDB<Debtags::Package>::statedir()));

		// Read the full collection
		//try {
			DebtagsDocument document;
		//} catch (std::exception& e) {
			//fprintf(stderr, "Failed to initialise access to a data source.\n");
			//fprintf(stderr, "Please run debtags update and try again\n");
			//return 1;
		//}

		// Check for the existance of a database
		/* it's now done by debtags' postinst anyway
		if (!document.hasTagDatabase())
			warning("The tag database has not yet been generated: you need to run \"debtags update\" (as root) before using Package Tags\n");
		*/

		//document.load();

		Gtk::Main app(&argc, &argv);
		
		DebtagsEditor<DebtagsDocument> debtagsEditor(document);

		/*
		Debtags::Tag tag = document.vocabulary().getTag("accessibility::TODO");
		Tagcoll::OpSet<DebtagsDocument::package> pkgs = document.tagdb().getItems(tag);
		fprintf(stderr, "%d items\n", pkgs.size());
		*/

		Gtk::Main::run(debtagsEditor);

		//if (document.changed())
		//{
			printf("Please want: autosaving on exit...\n");
			document.save();
		//}
		
		return 0;
	}
	catch (std::exception& e)
	{
		fatal_error("%s\n", e.what());
		return 1;
	}
}

// vim:set ts=4 sw=4:
