#!/usr/bin/env python
#
# Written by Henry 'Pi' James and Loring Holden
# modified for multitracker display by John Hoffman
# Modified by Cameron Dale
# see LICENSE.txt for license information
#
# $Id: btshowmetainfo.py 266 2007-08-18 02:06:35Z camrdale-guest $

"""Display a summary of the information in a metainfo or Packages file."""

from sys import *
from os.path import *
from sha import *
from DebTorrent.bencode import *
from DebTorrent.download_bt1 import get_packages

assert version_info >= (2,3), 'Requires Python 2.3 or better'

NAME, EXT = splitext(basename(argv[0]))
VERSION = '20030621'

print '%s %s - decode DebTorrent metainfo files' % (NAME, VERSION)
print

if len(argv) == 1:
    print '%s file1.dtorrent file2.dtorrent file3.dtorrent ...' % argv[0]
    print
    exit(2) # common exit code for syntax error

for metainfo_name in argv[1:]:
    if len(metainfo_name) >= 8 and metainfo_name[-8:] == 'Packages':
        (metainfo, temp) = get_packages(metainfo_name, '', 0)
    else:
        metainfo_file = open(metainfo_name, 'rb')
        metainfo = bdecode(metainfo_file.read())
        
#    print metainfo
    info = metainfo['info']
    info_hash = sha(bencode(info))

    print 'metainfo file.: %s' % basename(metainfo_name)
    print 'info hash.....: %s' % info_hash.hexdigest()
    piece_lengths = info['piece lengths']
    print 'directory name: %s' % metainfo['name']
    print 'files.........: '
    file_length = 0;
    for file in info['files']:
        path = ''
        for item in file['path']:
            if (path != ''):
                path = path + "/"
            path = path + item
        print '   %s (%d)' % (path, file['length'])
        file_length += file['length']
        name ='archive size..:'
    print '%s %i bytes (%i pieces)' \
          % (name,file_length, len(piece_lengths))
    print 'announce url..: %s' % metainfo['announce']
    if metainfo.has_key('announce-list'):
        list = []
        for tier in metainfo['announce-list']:
            for tracker in tier:
                list+=[tracker,',']
            del list[-1]
            list+=['|']
        del list[-1]
        liststring = ''
        for i in list:
            liststring+=i
        print 'announce-list.: %s' % liststring
    if metainfo.has_key('deb_mirrors'):
        list = []
        for seed in metainfo['deb_mirrors']:
            list += [seed,'|']
        del list[-1]
        liststring = ''
        for i in list:
            liststring+=i
        print 'mirror URLs....: %s' % liststring
    if metainfo.has_key('comment'):
        print 'comment.......: %s' % metainfo['comment']
