/*
 * This file is licensed under the terms of the GNU General Public License,
 * version 2. See the file COPYING in the main directory for details.
 * 
 *  Copyright (C) 2000-2002  Florian Lohoff <flo@rfc822.org>
 *  Copyright (C) 2002,2003  Thiemo Seufer <seufer@csv.ica.uni-stuttgart.de>
 */
#ifndef DELO_H
#define DELO_H

#include "dec_prom.h"

#define SECTOR_SIZE		512

#ifndef NULL
#define NULL ((void *)0)
#endif

#ifndef SIZE_T_DEFINED
typedef unsigned long int size_t;
# define SIZE_T_DEFINED
#endif

#define MIN(a, b) ((a) < (b)) ? (a) : (b)

#define UNUSED __attribute__((unused))

/* Max. number of kernel parameters. */
#define PARM_LIMIT	32

#define PAGE_SIZE	4096

#define printf callv->_printf
#define puts callv->_puts

static inline int bootinit(char *fname)
{
	int ret = callv->_bootinit(fname);
	return (BROKEN_BOOTINIT(dec_sysid)) ? 0 : ret;
}

static inline int bootread(int b, void *buffer, int n)
{
	int ret = callv->_bootread(b, buffer, n);
	return (BROKEN_BOOTREAD(dec_sysid)) ? n : ret;
}

static inline int clearcache(void)
{
	return callv->_clearcache();
}

static inline int getsysid(void)
{
	return callv->_getsysid();
}

static inline void halt(int a, int b)
{
	callv->_halt(a, b);
}

#ifdef DEBUG
#define dprintf(fmt, arg...) do { printf(fmt , ##arg); } while (0)
#else
#define dprintf(fmt, arg...) do { } while (0)
#endif

extern void *malloc_aligned(size_t size, size_t align);
extern void *malloc(size_t size);
extern void free(void *m);
extern void *realloc(void *p, size_t size);

struct extentlist {
	struct extentlist *next;
	unsigned int extent;
	unsigned int count;
};

extern void extentlist_clear(void);
extern int extentlist_add_tail(unsigned int extent, unsigned int count);
extern unsigned int extentlist_size(void);
extern void extentlist_dump(void);

extern int delo_open(char *partition, char *file);
extern int delo_read(void *dest, unsigned int offset, unsigned int len, int progress);
extern int readfile(void **dest, char *partition, char *file, size_t align);

extern int readext2blocks(char *partition, char *file);
extern int readisoblocks(char *file);
extern void *loadelf(void);
extern void *loadecoff(void);
extern unsigned int getpartoffset(char *partition);
extern char **getconfig(char *partition, char *file, char *config);

#endif /* DELO_H */
