/*
 * This file is licensed under the terms of the GNU General Public License,
 * version 2. See the file COPYING in the main directory for details.
 * 
 *  Copyright (C) 2002,2003  Thiemo Seufer <seufer@csv.ica.uni-stuttgart.de>
 */

#include <ecoff.h>

#include "delo.h"
#include "stringops.h"

void *loadecoff(void)
{
	struct ecoff_file_start ef;

	if (delo_read(&ef, 0, sizeof(ef), 0))
		return NULL;

	if (!(ef.efh.f_magic == MIPSELMAGIC
	      && ef.efh.f_opthdr == sizeof(struct aouthdr)
	      && ef.efh.f_flags == 0x100f
	      && ef.eah.magic == OMAGIC
	      && ef.eah.vstamp == 200
	      && !strncmp(ef.esecs[0].s_name, ".text", 5)
	      && !strncmp(ef.esecs[1].s_name, ".data", 5)))
		return NULL;

	/* .text */
	if (delo_read((void *)ef.esecs[0].s_vaddr, ef.esecs[0].s_scnptr,
		      ef.esecs[0].s_size, 1))
		return NULL;

	/* .data */
	if (delo_read((void *)ef.esecs[1].s_vaddr, ef.esecs[1].s_scnptr,
		      ef.esecs[1].s_size, 1))
		return NULL;

	return (void *)ef.eah.entry;
}
