/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/logging_config_exception.cpp
 * $Id: logging_config_exception.cpp,v 1.6 2005/06/23 09:54:19 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] Implementation of @ref diagnostics::Logging_Config_Exception
 */

#include <diagnostics/frame/logging_config_exception.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

Logging_Config_Exception::Logging_Config_Exception(::std::string const & what) 
	: Super(what)
{
}

Logging_Config_Exception::Logging_Config_Exception(Self const & other) 
	: Super(other)
{
}



Logging_Config_Exception::~Logging_Config_Exception() DIAGNOSTICS_EXCEPTIONS_THROW_DECL
{
}


char const * Logging_Config_Exception::name() const 
{
    return "Logging_Config_Exception";
}

DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
