/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_exception.hpp
 *
 * @brief [LEVEL: beta] @ref diagnostics::unittest::Test_Exception
 *
 * $Id: test_exception.hpp,v 1.11 2005/06/23 09:54:24 esdentem Exp $
 * 
 * @author Christian Schallhart
 *
 * @test none
 */

#ifndef DIAGNOSTICS__UNITTEST__TEST_EXCEPTION_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UNITTEST__TEST_EXCEPTION_HPP__INCLUDE_GUARD

#include <diagnostics/unittest/namespace.hpp>

// used as base class
#include <diagnostics/frame/std_exception.hpp>


DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

/**
 * @class Test_Exception diagnostics/unittest/test_exception.hpp 
 *
 * @brief Thrown if the test system detects an error of a @ref
 * Test_Case. USe this exception for errors which are detected by the
 * test-driver.
 *
 * For example, if a @ref Test_Case tries to get a string from @ref
 * Test_Data which does not exist, @ref Test_Data will throw a
 * Test_Exception. 
 *
 * Or, as another example, @ref TEST_ASSERT throws a Test_Exception.
 *
 * @nosubgrouping 
 */
class Test_Exception :
    public Std_Exception
{
public:
    /**
     * @throw never
     */
    inline Test_Exception(::std::string const & what) :
	Std_Exception(what)
    {
    }

    /**
     * @throw never
     */
    virtual ~Test_Exception() DIAGNOSTICS_EXCEPTIONS_THROW_DECL;
    
    /**
     * @throw never
     */
    virtual char const * name() const;
};

UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
