/*
 *========================================================================
 * $Id: dieharder.c 127 2004-11-20 18:17:55Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 *  run_sts_runs()
 *========================================================================
 */

#include "dieharder.h"

void run_sts_runs()
{


 /*
  * Declare the results struct.
  */
 Test **sts_runs_test;

 /*
  * First we create the test (to set some values displayed in test header
  * correctly).
  */
 sts_runs_test = create_test(&sts_runs_dtest,tsamples,psamples,&sts_runs);

 /*
  * Set any GLOBAL data used by the test.
  */
 sts_runs_rand_int = (uint *)malloc(sts_runs_test[0]->tsamples*sizeof(uint));

 /*
  * Show the standard test header for this test.
  */
 show_test_header(&sts_runs_dtest,sts_runs_test);

 /*
  * This is where we can output any test-specific information.
  */

 /*
  * Set any GLOBAL data used by the test.  Then call the test itself
  * This fills in the results in the Test struct.
  */
 std_test(&sts_runs_dtest,sts_runs_test);

 /*
  * This almost certainly belongs in the show_test_results section,
  * possibly with additional conditionals rejecting test results involving
  * rewinds, period.
  */
 if(strncmp("file_input",gsl_rng_name(rng),10) == 0){
   printf("# %u rands were used in this test\n",file_input_get_rtot(rng));
   printf("# The file %s was rewound %u times\n",gsl_rng_name(rng),file_input_get_rewind_cnt(rng));
 }

 /*
  * Show standard test results, for all statistics generated by a single run.
  */
 show_test_results(&sts_runs_dtest,sts_runs_test);

 free(sts_runs_rand_int);

}
