#!/usr/bin/perl

use CGI;
use Image::Magick;

my $album_dir="/mp3/album_covers";

my $cgi=new CGI;

my $disc_id=$cgi->param('disc_id');
my $width=$cgi->param('width');
my $height=$cgi->param('height');

my $image=Image::Magick->new;
open(IMAGE,"<$album_dir/$disc_id.jpg");
$image->Read(file=>\*IMAGE);
close(IMAGE);

ScaleImage($image,$width,$height);

my $data=$image->ImageToBlob();

print "Content-type: image/jpeg\nPragma: nocache\n\n";

print $data;

sub ScaleImage {
  my ($image,$scale_width,$scale_height)=@_;

  my ($width,$height)=$image->Get('width','height');

  my $aspect=$width/$height;
  my $scale_aspect=$scale_width/$scale_height;

  if($aspect>$scale_aspect) {
    $scale_height=int($scale_width/$aspect);
  }
  else {
    $scale_width=int($scale_height*$aspect);
  }

  $image->Scale(width=>$scale_width,height=>$scale_height);
}
