/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Translatrix {
    private static ResourceBundle langResources;
    private static String bundleName;

    public Translatrix(String string) {
        bundleName = string;
        try {
            langResources = ResourceBundle.getBundle(bundleName);
        }
        catch (MissingResourceException missingResourceException) {
            Translatrix.logException("MissingResourceException while loading language file", missingResourceException);
        }
    }

    public static void setBundleName(String string) {
        bundleName = string;
    }

    public static void setLocale(Locale locale) {
        if (bundleName == null) {
            return;
        }
        if (locale != null) {
            try {
                langResources = ResourceBundle.getBundle(bundleName, locale);
            }
            catch (MissingResourceException missingResourceException) {
                try {
                    langResources = ResourceBundle.getBundle(bundleName);
                }
                catch (MissingResourceException missingResourceException2) {
                    Translatrix.logException("MissingResourceException while loading language file", missingResourceException2);
                }
            }
        } else {
            try {
                langResources = ResourceBundle.getBundle(bundleName);
            }
            catch (MissingResourceException missingResourceException) {
                Translatrix.logException("MissingResourceException while loading language file", missingResourceException);
            }
        }
    }

    public static void setLocale(String string, String string2) {
        if (string != null && string2 != null) {
            Translatrix.setLocale(new Locale(string, string2));
        }
    }

    public static String getTranslationString(String string) {
        if (bundleName == null) {
            return string;
        }
        return langResources.getString(string);
    }

    private static void logException(String string, Exception exception) {
        System.err.println(string);
        exception.printStackTrace(System.err);
    }
}

