#include "cache.h"

CacheItem::CacheItem(QString p, int b, int l)
{
	path=p;
	bpm=b;
	length=l;
}

CacheItem::CacheItem()
{
}

CacheItem::CacheItem(const CacheItem& source)
{
	*this=source;
}

CacheItem& CacheItem::operator= (const CacheItem& source)
{
	path=source.path;
	bpm=source.bpm;
	length=source.length;
	return *this;
}

CacheItem::~CacheItem()
{
}

Cache::Cache()
{
}

Cache::~Cache()
{
}

CacheItem Cache::find(QString p)
{
	QValueList<CacheItem>::Iterator it;

	for(it=list.begin();it!=list.end();++it)
	{
		if((*it).path == p)
			return (*it);
	}
	return CacheItem(QString::null, -1, -1);
}

void Cache::add(QString p, int b, int l)
{
	CacheItem it=find(p);
	if(it.path != QString::null)
		return;
	it.path=p;
	it.bpm=b;
	it.length=l;
	list.append(it);
}

void Cache::remove(QString p)
{
	QValueList<CacheItem>::Iterator it;

	for(it=list.begin();it!=list.end();++it)
	{
		if((*it).path == p)
		{
			list.remove(it);
			return;
		}
	}
}
