#include "cfgfile.h"
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

Config::Config()
{
}

Config::Config(QString app, bool i_save)
{
	appName=app;
	load();
	s_save=i_save;
}

Config::Config(Config& src)
{
	items=src.items;
	s_save=false;
}

Config::~Config()
{
	save();
}

QString Config::getValue(QString key, QString def)
{
	QValueList<ConfigItem>::Iterator it=findItem(key);

	if(it == items.end())
		return def;

	ConfigItem i=(*it);

	return i.value;
}

void Config::setValue(QString key, QString val)
{
	QValueList<ConfigItem>::Iterator it=findItem(key);

	if(it != items.end())
		items.remove(it);
	
	ConfigItem i;
	i.key=key;
	i.value=val;

	items.append(i);
	save();
}

QValueList<ConfigItem>::Iterator Config::findItem(QString key)
{
	QValueList<ConfigItem>::Iterator it;

	for(it=items.begin();it!=items.end();++it)
	{
		if((*it).key == key)
			return it;
	}
	return items.end();
}

void Config::save()
{
	if(!s_save)
		return;

	QString strFile;
	strFile.sprintf("%s/.%s", getenv("HOME"), (const char *)appName);

	FILE *fp=fopen(strFile, "w");

	if(!fp)
		return;

	QValueList<ConfigItem>::Iterator it;

	for(it=items.begin();it!=items.end();++it)
	{
		fprintf(fp, "%s=%s\n", (const char *)(*it).key, (const char *)(*it).value);
	}
	fclose(fp);
}

void Config::load()
{
	QString strFile;
	strFile.sprintf("%s/.%s", getenv("HOME"), (const char *)appName);

	FILE *fp=fopen(strFile, "r");
	if(!fp)
		return;
	
	char line[1024];

	while(fgets(line, sizeof(line)-1, fp) && !feof(fp))
	{
		QString strLine=line;
		strLine=strLine.stripWhiteSpace();
		int idx=strLine.find('=');
		if(idx == -1)
			continue;
		ConfigItem i;
		i.key=strLine.mid(0, idx);
		i.value=strLine.mid(idx+1);
		if(i.value == QString::null)
			i.value="";
		
		items.append(i);
	}
	fclose(fp);
}

Config& Config::operator = (Config& src)
{
	items=src.items;
	return *this;
}

void Config::setSave(bool i_save)
{
	s_save=i_save;
}

void Config::setName(const char *i_name)
{
	appName=i_name;
	load();
}

QString Config::name()
{
	return appName;
}
