#ifndef _FRAME_H_INCLUDED
#define _FRAME_H_INCLUDED

#include <qwidget.h>
#include <qthread.h>
#include "mainwnd.h"
#include "jacklow.h"
#include "config.h"
#include "vthread.h"
#include "djconsole.h"

#ifdef HAVE_LIBSDL
extern "C" {
#include <SDL.h>
}
#endif

#define PLAY_LED 1
#define CUE_LED 2
#define PFL_LED 3
#define FX_LED 4
#define LOOP_LED 5
#define CUE_FX_LED 6
#define AUTO_BEAT_LED 7
#define MASTER_TEMPO_LED 8
class QSocketNotifier;
class QTimer;
class Mixer;
class Playlist;
class VThread;
class StreamSource;
class Metatracker;

class Frame : public QWidget
{
Q_OBJECT
public:
	Frame(QWidget *parent, const char *name, WFlags f);
	~Frame();

	void setFrames(MainWnd *f1, MainWnd *f2);
	MainWnd *left();
	MainWnd *right();
	MainWnd *player(int p);
	Metatracker *metatracker;
	Mixer *mixer();
	Client *client();
	Port *pfl_left;
	Port *pfl_right;
	void setMixer(Mixer *mixer);
	Playlist *playlist();
	void setPlaylist(Playlist *p);
	unsigned char **get_frame_buffer(int player);
	void enableLeftVideo(bool on);
	void enableRightVideo(bool on);
	void new_track(int player_number);
	void setVideoMode();
	void set_led(int, int, int);
	void consoleEvent(int code, int value);
	void startConsole();

	unsigned char **left_buffer;
	unsigned char **right_buffer;
	unsigned char **blank_buffer;

	QMutex clear_lock;
protected:
#ifdef HAVE_LIBSDL
	SDL_Surface *display;
	VThread *vthread;
	void *wm_info;
	unsigned long sdl_frame;
#endif
	DJConsole dj;
	Playlist *s_playlist;
	Mixer *s_mixer;
	Client *j_client;
	int joy_fd;
	QSocketNotifier *sn_read;
	MainWnd *frame1, *frame2;
	QTimer *key_timer;
	QTimer *blink_timer;
	QWidget *video;
	float left_factor;
	float right_factor;
	bool lv_on;
	bool rv_on;
	bool video_mode_on;
	StreamSource *left_source;
	StreamSource *right_source;
	int event_fd;
	bool blink_on;
	int mouse_flag;
	MainWnd *mouse_seek;

public slots:
	void VideoXFader_valueChanged(int v);
protected slots:
	void key_timeout();
	void closeEvent(QCloseEvent *e);
	void blink_timeout();
signals:
	void windowClosed();
friend class VThread;
};
#endif
