#ifndef _MIXEFFECT_H_INCLUDED
#define _MIXEFFECT_H_INCLUDED

#include "effect.h"

class MixEffect;
class Port;
class Client;

class MixEffectChannel : public EffectChannel
{
public:
	MixEffectChannel(MixEffect *e, unsigned long in_port, unsigned long out_port);

	virtual ~MixEffectChannel();

	void setControl(unsigned long port, float data);
	float control(unsigned long port);
	virtual void setBuffer(float *buffer);

	void setPort(Port *p);
	Port *port();
protected:
	virtual void process(unsigned long nsamples);
	Port *e_port;
	float e_gain[4];
	float *e_buffer;

	friend class MixEffect;
};

class MixEffect : public Effect
{
public:
	MixEffect();
	~MixEffect();

	void setControl(unsigned long port, float data);
	float control(unsigned long port);
	MixEffectChannel *left();
	MixEffectChannel *right();
	unsigned long ports();
protected:

	friend class MixEffectChannel;
};


#endif
