#ifndef _MPEG_STREAM_SOURCE_H_INCLUDED
#define _MPEG_STREAM_SOURCE_H_INCLUDED

#include "config.h"

#ifdef HAVE_LIBMPEG3

#include "jack.h"
#include <libmpeg3.h>
#include <qthread.h>

class QImage;

class MpegStreamSource : public StreamSource
{
Q_OBJECT

public:
	MpegStreamSource(QWidget *dest);
	~MpegStreamSource();

	int attach(QString name);
	int attach(QString name, bool vid);
	int get_buffer(char *, int);
	int play(unsigned long start_frame, unsigned long samples, bool loop=false);
	int stop(void);
	StreamSource *get_source(void);
	unsigned char **get_frame();
	void lock_frame();
	void unlock_frame();
	void exit_loop(void);
	bool has_video();
	void set_preview_framebuffer(int width, int height, unsigned char **ext_framebuf);
protected:
	void prefetch();
	void decode_video();
private:
	bool s_has_video;
	QMutex frame_mutex;
	QMutex preview_lock;
	bool new_frame;
	bool do_video;
	mpeg3_t *fp;
	mpeg3_t *fpv;
	unsigned long file_pos;
	int vwidth;
	int vheight;
	float vrate;
	long vframes;
	unsigned char **framebuf;
	int fbheight;
	int fbwidth;
	long curframe;
	long vframe;
	int s_ext_fbwidth;
	int s_ext_fbheight;
	unsigned char **s_ext_framebuf;
	QImage *im;
};
#endif /* HAVE_LIBMPEG3 */
#endif
