#include "bitmapbuttonplugin.h"
#include "bitmapbutton.h"
#include "bitmapbutton.xpm"

BitmapButtonPlugin::BitmapButtonPlugin()
{
}

QStringList BitmapButtonPlugin::keys() const
{
	QStringList list;
	list << "BitmapButton";
	return list;
}

QWidget *BitmapButtonPlugin::create(const QString& key, QWidget *parent, const char *name)
{
	if(key == "BitmapButton")
		return new BitmapButton(parent, name);
	return 0;
}

QString BitmapButtonPlugin::includeFile( const QString& feature ) const
{
	if(feature == "BitmapButton")
		return "bitmapbutton.h";
	return QString::null;
}

QString BitmapButtonPlugin::group( const QString& feature ) const
{
	if(feature == "BitmapButton")
		return "Input";
	return QString::null;
}

QIconSet BitmapButtonPlugin::iconSet( const QString& ) const
{
	return QIconSet(QPixmap((const char **)bitmapbutton_xpm));
}

QString BitmapButtonPlugin::toolTip( const QString& feature ) const
{
	if(feature == "BitmapButton")
		return "Bitmap Button";
	return QString::null;
}

QString BitmapButtonPlugin::whatsThis( const QString& feature ) const
{
	if(feature == "BitmapButton")
		return "A Button consisting of bitmap images";
	return QString::null;
}

bool BitmapButtonPlugin::isContainer( const QString& ) const
{
	return false;
}

Q_EXPORT_PLUGIN(BitmapButtonPlugin)
