/* string.c - Some string manipulation functions for dnotify
 *
 * Copyright (C) 2002  Oskar Liljeblad
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <string.h>
#include <stdint.h>
#include <limits.h>
#include <errno.h>
#include "dnotify.h"
#include "gettext.h"
#define _(s) gettext(s)
#define N_(s) gettext_noop(s)

char *expand_braces(char *spec, const char *repl)
{
	int count = 0;
	char *b1;
	char *b2;

	for (b1 = spec; (b2 = strstr(b1, "{}")) != NULL; b1 = b2+2)
		count++;

	if (count > 0) {
		char *out;
		size_t start = 0;
		size_t repllen = strlen(repl);

		/* this is freed when child process terminates */
		out = malloc(strlen(spec) + repllen*count - 2*count + 1);
		if (out == NULL)
			die("%s", errstr);

		for (b1 = spec; (b2 = strstr(b1, "{}")) != NULL; b1 = b2+2) {
			strncpy(out+start, b1, b2-b1);
			start += b2-b1;
			strcpy(out+start, repl);
			start += repllen;
		}

		strcat(out+start, b1);
		return out;
	}

	return spec;
}

char *concat_dirname(const char *file1, char *file2)
{
	int len;
	char *outfile;

	len = strlen(file1);
	outfile = malloc(len+1+strlen(file2)+1);
	if (outfile == NULL)
		die("%s", errstr);

	strcpy(outfile, file1);
	if (file1[len-1] != '/')
		strcat(outfile, "/");
	strcat(outfile, file2);

	return outfile;
}

int
parse_int32(const char *instr, int32_t *outint)
{
	int32_t value = 0;

	if (*instr == '-') {
		if (instr[1] == '\0')		/* XXX: this should be done on all!!! */
			return 0;
		for (instr++; *instr != '\0'; instr++) {
			int8_t c = *instr - '0';
			if (c < 0 || c > 9)
				return 0;
			if (value < INT32_MIN/10L || (value == INT32_MIN/10L && c > -(INT32_MIN%10L)))
				return 0;
			value = value*10L - c;
		}
	} else {
		if (*instr == '\0')			/* XXX: this should be done on all!!! */
			return 0;
		for (; *instr != '\0'; instr++) {
			int8_t c = *instr - '0';
			if (c < 0 || c > 9)
				return 0;
			if (value > INT32_MAX/10L || (value == INT32_MAX/10L && c > INT32_MAX%10L))
				return 0;
			value = value*10L + c;
		}
	}
	*outint = value;

	return 1;
}
