
import java.util.*;


/**
  * This class is for exceptions thrown when an attempt is made to access
  * nonexistant configuration variables or to improperly set those variables.
  *
  * @version $Id: IllegalVariableException.java,v 1.7 2002/08/30 02:27:06 blsecres Exp $
  * @author Ben Secrest &lt;blsecres@users.sourceforge.net&gt;
  */
public class IllegalVariableException extends Exception {
    /**
      * The error message
      */
    private String message;


    /**
      * The constructor for nonexistant variable type exceptions
      * @param locale The current locale
      * @param variable The invalid variable
      */
    public IllegalVariableException(Locale locale, String variable) {
	ResourceBundle rb = ResourceBundle.getBundle("Exceptions",
							  locale);

	message = rb.getString("NO_SUCH_SETTING") + ":  " + variable;
    }


    /**
      * The constructor for invalid variable value exceptions
      * @param locale The current locale
      * @param variable The improperly set variable
      * @param value The erroneous value
      */
    public IllegalVariableException(Locale locale, String variable,
				    String value) {
	ResourceBundle rb = ResourceBundle.getBundle("Exceptions",
							  locale);
	message = rb.getString("SETTING") + ' ' + variable + ' ' +
	    rb.getString("BAD_VALUE") + ' ' + value;
    }


    /**
      * The constructor for variable type mismatch exceptions
      * @param locale The current locale
      * @param variable The varible with the wrong type
      * @param type The correct type for the variable
      */
    public IllegalVariableException(Locale locale, String variable, byte type) {
	ResourceBundle rb = ResourceBundle.getBundle("Exceptions",
							  locale);
	message = rb.getString("SETTING") + ' ' + variable + ' ' +
	      rb.getString("IS_NOT_TYPE") + ' ';
	      
	switch (type) {
	case Settings.BOOLEAN :
	    message += "Boolean";
	    break;
	case Settings.INTEGER :
	    message += "Integer";
	    break;
	case Settings.STRING :
	    message += "String";
	    break;
	case Settings.ARRAY :
	    message += "Vector";
	    break;
	case Settings.ENUM :
	    message += "Enumeration";
	    break;
	case Settings.DNE :
	    message += rb.getString("NO_SUCH_SETTING");
	    break;
	}
    }


    /**
      * Override the toString method of Exception
      * @return The name of this exception and the error message
      * @see java.lang.Exception
      */
    public String toString() {
	return "IllegalVariableException: " + message;
    }


    /**
      * Override the getMessage method of Exception
      * @return The error message for the exception
      * @see java.lang.Exception
      */
    public String getMessage() {
	return message;
    }
}
