#tested for catchup about 5 deep, the ctrl-c out. 06/03/05 `ns`

import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class KeenSpot(BasicComicModule):
    imageUrl = 'd/%s.html'
    imageSearch = re.compile(r'<img[^>]+?src="([^"]*?comics/.+?)"', re.IGNORECASE)
    prevSearch = re.compile(r'<a href="([^"]*?d/\d{8}\.html)"[^>]*>(?:<img[^>]+?(?:name="previous_day"|alt="Previous"|src="[^"]*back[^"]*")|Previous comic)', re.IGNORECASE)
    help = 'Index format: yyyymmdd'

    submodules = {
#  Strips currently updating according to KeenSpot 2006/03/05
        'AbbysAgency': 'http://www.abbysagency.us/',
        'Adventurers': 'http://www.adventurers-comic.com/',
        'Alice': 'http://www.alicecomics.com/',
        'AlienDice': 'http://www.aliendice.com/',
        'AntiHeroForHire': 'http://www.antiheroforhire.com/',
        'Banished': 'http://www.banishedonline.com/',
#       'BonusStage': 'http://www.bonusstages.com/', not working
        'BoxJamsDoodle': 'http://boxjamsdoodle.com/',
        'BrunoTheBandit': 'http://www.brunothebandit.com/',
        'Candi': 'http://www.candicomics.com/',
        'ClanOfTheCats': 'http://www.clanofthecats.com/',
        'CollegeRoomiesFromHell': 'http://www.crfh.net/',
        'CountYourSheep': 'http://www.countyoursheep.com/',
        'DevilsPanties':'http://devilspanties.keenspot.com/',
        'DownToEarth': 'http://www.downtoearthcomic.com/',
        'ElGoonishShive': 'http://elgoonishshive.com/',
        'ElGoonishShiveFiller': 'http://www.egscomics.com/Filler/',
        'ElGoonishShiveNP': 'http://www.egscomics.com/egsnp/',
        'EverythingJake': 'http://www.everythingjake.com/',
#       'EvilJoshAndBilly': 'http://eviljoshandbilly.keentoons.com/', not working
        'FriendlyHostility': 'http://friendlyhostility.com/',
        'FunnyFarm': 'http://www.funnyfarmcomics.com/',
        'GamingGuardians': 'http://gamingguardians.com/',
        'GeebasOnParade': 'http://geebasonparade.keenspot.com/',
        'GeneCatlow': 'http://www.genecatlow.com/',
        'GeneralProtectionFault': 'http://www.gpf-comics.com/',
        'GodMode': 'http://www.godmodeonline.com/',
        'InsideTheBox': 'http://boxcomics.com/',
#        'KeenToons': ' http://www.keentoons.com/', not working
        'Landis': 'http://elisalandis.com/',
        'LostAndFound': 'http://www.lostandfoundcomic.com/',
#       'Manifestations': 'http://www.newshounds.com/manifestations/index.html', won't work pay site
        'NoRoomForMagic': 'http://noroomformagic.com/',
        'PennyAndAggie': 'http://pennyandaggie.com/',
        'QueenOfWands': 'http://www.queenofwands.net/',
#        'RoadWaffles': 'http://roadwaffles.com/', # not working
        'SinFest': 'http://www.sinfest.net/',
        'SoapOnARope': 'http://www.soaprope.com/',
        'SoreThumbs': 'http://www.sorethumbsonline.com/',
#       'SpaceTree': 'http://spacetree.com/', not working
        'SSDD': 'http://poisonedminds.com/',
        'Striptease': 'http://www.stripteasecomic.com/',
        'SuburbanJungle': 'http://www.suburbanjungle.com/',
        'TakingUpSpace': 'http://takingupspace.keenspot.com/',
        'ToddAndPenguin': 'http://www.toddandpenguin.com/',
        'TwoLumps': 'http://www.twolumps.net/',
        'UberSoft': 'http://www.ubersoft.net/',
        'WanderingOnes': 'http://wanderingones.com/',
#        'YouDamnKid': 'http://www.youdamnkid.com/', not working
        'Zap': 'http://www.zapinspace.com/',
        'ZebraGirl': 'http://zebragirl.keenspot.com/',
        'Zortic': 'http://www.zortic.com/',

# miniseries strips
        'BasilFlintMiniseries': 'http://basilflint.keenspot.com/',
        'BlackPlague': 'http://blackplague.keenspot.com/',
        'CruelFate': 'http://cruelfate.keenspot.com/',
        'IllegalElian': 'http://illegalelian.keenspot.com/',
        'KeenonballRun': 'http://keenonballrun.keenspot.com/',
        'PCsDayOut': 'http://pc.keenspot.com/',
        'Sam': 'http://sam.keenspot.com/',
        'TheScrantonvilleKids': 'http://scrantonvillekids.keenspot.com/',
        'TheSilveryCentipede': 'http://silverycentipede.keenspot.com/',
        'Timmy': 'http://timmy.keenspot.com/',
        'TreasureHunters': 'http://treasurehunters.keenspot.com/',
        'UltimateAsshole': 'http://ultimateasshole.keenspot.com/',

# Strips ended according to KeenSpot 2006/03/05
        'Andiewear': 'http://andiewear.com/',
        'Avalon': 'http://www.avalonhigh.com/',
        'AwesomeGamerz': 'http://awesomegamerz.com/',
#        'BasilFlint': 'http://www.basilflint.com/', not working
        'Bobbins': 'http://bobbins.org/',
        'BoyMeetsBoy': 'http://boymeetsboy.keenspot.com/',
        'CoolCatStudios': 'http://www.coolcatstudio.com/',
        'ExploitationNow': 'http://www.exploitationnow.com/',
#       'Frankenstudent': 'http://frankenstudent.com/', not working
        'JoeAverage': 'http://www.joeaverage.org/',
#        'LimitedSpace': 'http://www.limitedspace.org/', note not working
        'Lizard': 'http://www.lizardcomics.com/',
#       'Melpomene': 'http://clanofthecats.com/Melpomene/',  pay site
        'MenInHats': 'http://www.meninhats.com/',
        'PurplePussy': 'http://www.purplepussy.net/',
        'SillyConeV': 'http://www.sillyconev.com/',
        'Shmorky': 'http://www.shmorky.com/',
        'SporkMan': 'http://www.sporkman.com/',
        'TheClassMenagerie': 'http://www.theclassm.com/',

# Strips on hiatus or sporadic updates (keenspot 2006/03/05)
        'Ashfield': 'http://ashfieldonline.com/',
        'ChoppingBlock': 'http://choppingblock.org/',
        'EatTheRoses': 'http://eattheroses.com/',
#        'ElfLife': 'http://www.elflife.com/', not working
        'ElfOnlyInn': 'http://www.elfonlyinn.net/',
        'FatJesus': 'http://fat-jesus.com/',
        'FelicityFlint': 'http://www.secretagentgirl.org/',
        'FilthyLies': 'http://www.filthylies.net/',
#        'HoundsHome': 'http://houndshome.com/',  dead, archives offline
#        'JustAnotherVice': 'http://justanothervice.com/', one image
        'LookWhatIBroughtHome': 'http://lookwhatibroughthome.com/',
        'MadAboutU': 'http://madaboutu.keenspot.com/',
#        'MrChuckShow': 'http://mrchuckshow.com/', not working (no image match)
        'NaughtFramed': 'http://www.damonk.com/',
        'Owlie': 'http://owliecomics.com/',
        'RPGWorld': 'http://www.rpgworldcomic.com/',
        'SexAndViolence': 'http://mrbang.net/',
        'SkirtingDanger': 'http://www.skirtingdanger.com/',
        'VigilanteHo': 'http://www.vigilanteho.com/',

# Strips not mentioned anywhere (KeenSpot 2006/03/05)
#        'BadlyDrawnKitties': 'http://www.badlydrawnkitties.com/', not mentioned or working
        'Flem': 'http://www.flemcomics.com/',
        'TheShadows': 'http://www.alicecomics.com/',

# ComicGenesis comics
        '1007': 'http://loot.comicgenesis.com/',
        '13thLabour': 'http://the13labour.comicgen.com/',
        '1StComing': 'http://toon.comicgenesis.com/',
        '1StGradeArt': 'http://art.comicgenesis.com/',
        '21stCenturyFox': 'http://techfox.keenspace.com/',
        '24fps': 'http://filmbuff.comicgenesis.com/',
        '2DormsDown': 'http://mindflenzing.comicgenesis.com/',
        '2WayMirror': 'http://tande.comicgenesis.com/',
        '3RdEstate': 'http://tasch.comicgenesis.com/',
        '5Universe': 'http://fiveu.comicgen.com/',
        '6GUYSInMyHead': 'http://www.6guys.com/',
        '6X9College': 'http://sixbyninecollege.comicgenesis.com/',
        '72Bunnies': 'http://seventy2bunnies.comicgenesis.com/',
        '8to1': 'http://yeahduff.comicgen.com/',
        'AGeekTragedy': 'http://geektragedy.comicgenesis.com/',
        'ANT': 'http://ant.comicgenesis.com/',
        'AOMP': 'http://aomp.comicgenesis.com/',
        'ARtificialTIme': 'http://artificialtime.comicgenesis.com/',
        'AThinLine': 'http://thinline.comicgenesis.com/',
        'AU': 'http://auie.comicgenesis.com/',
        'AberdawnKnights': 'http://aberdawnknights.comicgenesis.com/',
        'AbsoluteZero': 'http://absolutezero.comicgenesis.com/',
        'AbyssalGate': 'http://abyssalgate.comicgenesis.com/',
        'Academy': 'http://theacademy.comicgenesis.com/',
        'Ace147': 'http://ace147.comicgenesis.com/',
        'AceProductions': 'http://aceproductions.comicgenesis.com/',
        'ActiveStuporHeroes': 'http://stuporheroes.comicgenesis.com/',
        'AdiosAngel86': 'http://aa86.comicgenesis.com/',
        'AdventuresInVastia': 'http://aiv.comicgenesis.com/',
        'AdventuresOfGotty': 'http://gotty.comicgenesis.com/',
        'AdventuresOfKeystone': 'http://keystonecomic.comicgenesis.com/',
        'AdventuresOfMattAndChris': 'http://matthewabel.comicgenesis.com/',
        'AdventuresOfPie': 'http://loonybin.comicgenesis.com/',
        'AdventuresOfPopsicleman': 'http://popsicleman.comicgenesis.com/',
        'AdventuresOfSpaceDevil': 'http://spacedevil.comicgenesis.com/',
        'AdventuresOfTheOffenders': 'http://jmsnooks.comicgenesis.com/',
        'AdventuresOfUs': 'http://adventuresofus.comicgenesis.com/',
        'AfterTheEndOfTheWorld': 'http://endoftheworld.comicgenesis.com/',
        'AlexHigh': 'http://alexhigh.comicgenesis.com/',
        'AllRosesHaveThorns': 'http://allroses.comicgen.com/',
        'AlphaLuna': 'http://alphaluna.comicgenesis.com/',
        'AltaModaMetro': 'http://metro.comicgenesis.com/',
        'AlternateDelusions': 'http://altdelusions.comicgen.com/',
        'AmazingNewWorlds': 'http://anw.comicgenesis.com/',
        'AmbersLife': 'http://amberslife.comicgenesis.com/',
        'Amerika': 'http://amerika.comicgenesis.com/',
        'Amethyst': 'http://amethyst.comicgenesis.com/',
        'AmhelakiMisadventures': 'http://amhelaki.comicgenesis.com/',
        'AnarchyAndAnthros': 'http://creepylilgothkids.comicgenesis.com/',
        'AndShineHeavenNow': 'http://hellsing.comicgenesis.com/',
        'Andellon': 'http://andellon.comicgenesis.com/',
        'AngelBlood': 'http://angelblood.comicgenesis.com/',
        'AngelTheDemoness': 'http://angelthedemoness.comicgenesis.com/',
        'AngryAidenSComic': 'http://angryaidenscomic.comicgenesis.com/',
        'AngryArtwerks': 'http://angrydwarf.comicgenesis.com/',
        'AngryDMonkey': 'http://www.angrydmonkey.com/',
        'AngrySoul': 'http://angrysoul.comicgen.com/',
        'AngstMedieval': 'http://gothiccomic.comicgenesis.com/',
        'AnimalTesting': 'http://animaltesting.comicgenesis.com/',
        'AnimeMomentsInHistory': 'http://animehistory.comicgenesis.com/',
        'Animi': 'http://animi.comicgenesis.com/',
        'Anna': 'http://anna.comicgen.com/',
        'AnotherNormalDay': 'http://super2goten.comicgen.com/',
        'AnthropomorphicHardware': 'http://hardware.comicgen.com/',
        'AntiChristDaiji': 'http://clad.comicgenesis.com/',
        'AntiFeline': 'http://antifeline.comicgenesis.com/',
        'Antics': 'http://antics.comicgenesis.com/',
        'AnywhereButHere': 'http://www.abh-comic.com/',
        'ApocalypseWow': 'http://endofdayspress.comicgenesis.com/',
        'Apotheosis': 'http://apotheosis.comicgenesis.com/',
        'Aquatica': 'http://aquatica.comicgenesis.com/',
        'Arbitrator': 'http://arbitrator.comicgenesis.com/',
        'Arcanetimes': 'http://arcanetimes.comicgen.com/',
        'Area15': 'http://area15.comicgenesis.com/',
        'Armz': 'http://armz.comicgenesis.com/',
        'ArnieGattonGalleryOfComics': 'http://agallery.comicgenesis.com/',
        'ArtistsBlock': 'http://artblock.comicgen.com/',
        'Asianosity': 'http://asianosity.comicgenesis.com/',
        'AskillWar': 'http://askillwar.comicgenesis.com/',
        'AssO9Tails': 'http://asso9tails.comicgenesis.com/',
        'Aszure': 'http://aszure.comicgenesis.com/',
        'AtaraxiaTheatre': 'http://ataraxia.comicgenesis.com/',
        'Atavism': 'http://atavism.comicgenesis.com/',
        'Atlantis': 'http://atlantis.comicgen.com/',
        'Avalon2': 'http://avalon.comicgenesis.com/',
        'Avatar': 'http://theavatar.comicgenesis.com/',
        'AwfullyGeneric': 'http://awfullygeneric.comicgenesis.com/',
        'AwolAdventures': 'http://awol.comicgenesis.com/',
        'BARAKA': 'http://baraka.comicgenesis.com/',
        'Backroads': 'http://backroads.comicgenesis.com/',
        'BadAssMuthas': 'http://mrdaveryan.comicgenesis.com/',
        'BadassBrat': 'http://badassbrat.comicgenesis.com/',
        'BakaKun': 'http://bakakun.comicgenesis.com/',
        'BanTheBasics': 'http://banthebasics.comicgenesis.com/',
        'Bastion': 'http://bastion.comicgenesis.com/',
        'BathathonHeled': 'http://bathathonheled.comicgenesis.com/',
        'BeastOfEden': 'http://beast.comicgenesis.com/',
        'BeautifulSkies': 'http://bskies.comicgenesis.com/',
        'BecauseOfMathClass': 'http://mathclass.comicgenesis.com/',
        'Beerkada': 'http://beerkada.comicgenesis.com/',
        'BeforeDawn': 'http://beforedawn.comicgenesis.com/',
        'BetterLifeThanThis': 'http://abetterlifethanthis.comicgenesis.com/',
        'BetweenRealities': 'http://realities.comicgenesis.com/',
        'BeyondHalo': 'http://beyondhalo.comicgen.com/',
        'BeyondReality': 'http://orion.comicgenesis.com/',
        'BeyondTheRadiator': 'http://radiator.comicgenesis.com/',
        'Bikou': 'http://bikou.comicgenesis.com/',
        'BillyThePervertedWonderBoy': 'http://billyisapervert.comicgen.com/',
        'BinOfInsanity': 'http://boi.comicgenesis.com/',
        'Bing': 'http://caitlinf.comicgenesis.com/',
        'BirthOfGenesis': 'http://birthofgenesis.comicgenesis.com/',
        'BiscuitsForBreakfast': 'http://valuedan.comicgenesis.com/',
        'BiteTheWaxTadpole': 'http://bitethewaxtadpole.comicgenesis.com/',
        'BitterSweetBS': 'http://bsbs.comicgenesis.com/',
        'BlackHoleBlues': 'http://blackholeblues.comicgenesis.com/',
        'BlackTapestries': 'http://blacktapestries.comicgen.com/',
        'Blackaby': 'http://blackaby.comicgenesis.com/',
        'Blackbird27': 'http://blackbird27.comicgenesis.com/',
        'BlacklightTwilight': 'http://nekkoxiii.comicgenesis.com/',
        'Blatah': 'http://blatah.comicgenesis.com/',
        'BlindPath': 'http://skyline.comicgenesis.com/',
        'Blindworks': 'http://blindworks.comicgenesis.com/',
        'BloodOfTheDragon': 'http://bdragon.comicgenesis.com/',
        'BloodWing': 'http://bloodwing.comicgenesis.com/',
        'BlueAndOrange': 'http://blueandorange.comicgenesis.com/',
        'BlueBalled': 'http://sunder.comicgenesis.com/',
        'BlueCollarCleanup': 'http://franko.comicgenesis.com/',
        'BlueEyedDevil': 'http://blueeyeddevil.comicgenesis.com/',
        'BlueZombie': 'http://entity.comicgen.com/',
        'Blunderclod': 'http://blunderclod.comicgenesis.com/',
        'BobTheBlock': 'http://bobtheblock.comicgenesis.com/',
        'BobsSpiffORama': 'http://spifforama.comicgenesis.com/',
        'Bobville': 'http://mekryd.comicgenesis.com/',
        'BoobsAhoy': 'http://boobsahoy.comicgenesis.com/',
        'Bookwyrms': 'http://bookwyrms.comicgenesis.com/',
        'BoomerExpress': 'http://www.boomerexpress.com/',
        'BootCamp': 'http://bootcamp.comicgen.com/',
        'Borderline': 'http://chinookpictures.comicgenesis.com/',
        'BradleyDrawn': 'http://bradleydrawn.comicgenesis.com/',
        'BrainCramp': 'http://braincramp.comicgen.com/',
        'BrainDamage': 'http://braindamageauthor.comicgenesis.com/',
        'BreckenChronicles': 'http://brecken.comicgenesis.com/',
        'BridgettesBelly': 'http://bridgette.comicgenesis.com/',
        'BrightSideOfLife': 'http://deadbeat135.comicgenesis.com/',
        'BringYourOwnController': 'http://byoc.comicgenesis.com/',
        'Brinkerhoff': 'http://brinkerhoff.comicgenesis.com/',
        'BrokenCompass': 'http://brokencompass.comicgenesis.com/',
        'BrokenGlass': 'http://brokenglass.comicgenesis.com/',
        'BrokenWorlds': 'http://brokenworlds.comicgenesis.com/',
        'Brunswick': 'http://brunswick.comicgenesis.com/',
        'Burgundycomics': 'http://bci.stripspace.com/',
        'BusterAndFriends': 'http://busterandfriends.comicgenesis.com/',
        'ButtonsTooHyperToThink': 'http://buttonscrew.comicgenesis.com/',
        'CAGE': 'http://cage.comicgenesis.com/',
        'CMD': 'http://cmd.comicgenesis.com/',
        'CallToDestiny': 'http://madgoblin.comicgenesis.com/',
        'CamiXAlex': 'http://camixalex.comicgenesis.com/',
        'CampAlaska': 'http://campalaska.comicgenesis.com/',
        'Candidate': 'http://kennystrife.comicgenesis.com/',
        'Candy': 'http://candy.comicgenesis.com/',
        'CanisLupus': 'http://cheetahfox.comicgenesis.com/',
        'CannedHam': 'http://cannedham.comicgenesis.com/',
        'CaptainMike': 'http://captainmike.comicgenesis.com/',
        'CaptainMortua': 'http://captainmortua.comicgenesis.com/',
        'Carnivores': 'http://carnivores.comicgenesis.com/',
        'CarrotsAndCheese': 'http://cnc.comicgen.com/',
        'CascadeFailure': 'http://cascadefailure.comicgenesis.com/',
        'CasualtiesOfWar': 'http://casualtiesofwar.comicgenesis.com/',
        'CatLegend': 'http://catlegend.comicgenesis.com/',
        'CatScratch': 'http://catscratch.comicgenesis.com/',
        'CatboyAtTheCon': 'http://trades.comicgenesis.com/',
        'Chair': 'http://chair.comicgen.com/',
        'Chalkdust': 'http://chalkdustcomic.comicgenesis.com/',
        'ChaosGeorge': 'http://kawzkaos.comicgenesis.com/',
        'ChaosTheory': 'http://chaostheory.comicgen.com/',
        'ChaoticNeutral': 'http://chaoticneutral.comicgenesis.com/',
        'ChatRouge': 'http://chatrouge.stripspace.com/',
        'ChildrenAtPlay': 'http://childrenatplay.comicgenesis.com/',
        'ChildrenOfMoloch': 'http://moloch.comicgenesis.com/',
        'ChimeraQuest': 'http://doggirl.comicgenesis.com/',
        'ChrisVPresents': 'http://chrisvpresents.comicgenesis.com/',
        'ChronicMisadventures': 'http://chronic.comicgenesis.com/',
        'ChrusherComix': 'http://chrusher.comicgenesis.com/',
        'Chu': 'http://chu.comicgenesis.com/',
        'ChubbyAndNot': 'http://chubbyandnot.comicgen.com/',
        'Cimmerian': 'http://cimmerian.comicgenesis.com/',
        'CircleArcadiaKnightsOfTheGoddess': 'http://arcadia.comicgenesis.com/',
        'Citron': 'http://citron.comicgenesis.com/',
        'CityOfFlukes': 'http://diabloii.comicgenesis.com/',
        'CityStreets': 'http://poisondusk.comicgenesis.com/',
        'ClearwaterClan': 'http://clearwaterclan.comicgenesis.com/',
        'Clematis': 'http://clematis.comicgenesis.com/',
        'Cliche': 'http://blaedlocke.comicgenesis.com/',
        'ClippedAndUnstoppable': 'http://www.unstoppablecomic.com/',
        'ClippedWings': 'http://clippedwings.comicgenesis.com/',
        'ClownsInABlender': 'http://clownsinablender.comicgenesis.com/',
        'Cnetr': 'http://cnetr.comicgenesis.com/',
        'Cody': 'http://cody.comicgenesis.com/',
        'CoilingSpine': 'http://www.coilingspine.com/',
        'ColdFeet': 'http://coldfeet.comicgenesis.com/',
        'ColdServings': 'http://www.coldservings.com/',
        'ColdWhiteNorth': 'http://coldwhitenorth.comicgenesis.com/',
        'CollidingWorlds': 'http://fearunianadv.comicgenesis.com/',
        'ColossalComcs': 'http://resolutes.comicgen.com/',
        'ComfortablyNumb': 'http://comfortablynumb.comicgenesis.com/',
        'ComicCreatorz': 'http://creatorz.comicgenesis.com/',
        'ComicGraveyard': 'http://comicgraveyard.comicgenesis.com/',
        'ComicMischief': 'http://foxdemon.comicgenesis.com/',
        'CommonDays': 'http://commondays.comicgenesis.com/',
        'CommonSense': 'http://commonsense.comicgenesis.com/',
        'ComputerGameAddicts': 'http://cgaddicts.comicgenesis.com/',
        'ConfessionsOfAnEnglishCatburglar': 'http://catburglars.comicgenesis.com/',
        'Confuzzled': 'http://confuzzled.comicgenesis.com/',
        'Conned': 'http://con.comicgenesis.com/',
        'ConstantFlux': 'http://constantflux.comicgenesis.com/',
        'CookieWorld': 'http://cookie.comicgenesis.com/',
        'CornerAlley13': 'http://corneralley.comicgenesis.com/',
        'CorridorZ': 'http://billybones.comicgenesis.com/',
        'Cortland': 'http://www.cortlandcomic.com/',
        'CosmicAwareness': 'http://cosmicawareness.comicgenesis.com/',
        'CosmicDesign': 'http://cosmicdesign.comicgenesis.com/',
        'CoyoteDance': 'http://cdance.comicgenesis.com/',
        'CracklingSilence': 'http://crackling.comicgenesis.com/',
        'Crackwalker': 'http://crackwalker.comicgenesis.com/',
        'CreativityShack': 'http://creativityshack.comicgen.com/',
        'CreatureKeeper': 'http://creature.comicgenesis.com/',
        'CreepyHead': 'http://creepyhead.comicgen.com/',
        'CrookedHalo': 'http://chaoscricket.comicgenesis.com/',
        'CrossStreetBlues': 'http://crossstreet.comicgenesis.com/',
        'CrossToBear': 'http://crosstobear.comicgenesis.com/',
        'Crossroads': 'http://anivasion.comicgenesis.com/',
        'CrossroadsOfBoogerCounty': 'http://cobc.comicgenesis.com/',
        'CrowAlicesynaege': 'http://fourmages.comicgen.com/',
        'CrowsScrapbook': 'http://crowsscrapbook.comicgenesis.com/',
        'CrystalHearts': 'http://chs.comicgenesis.com/',
        'Cube30': 'http://cube30.comicgenesis.com/',
        'Cutethulhu': 'http://cutethulhu.comicgenesis.com/',
        'DATAROM': 'http://datarom.comicgen.com/',
        'DDiary': 'http://ddiary.comicgenesis.com/',
        'DNPIO': 'http://dnpio.comicgenesis.com/',
        'DRAW': 'http://draw.comicgenesis.com/',
        'DanskFolly': 'http://danskfolly.comicgenesis.com/',
        'DarkDays': 'http://darkdays.comicgenesis.com/',
        'DarkForests': 'http://darkforests.comicgenesis.com/',
        'DarkJediAndFriends': 'http://darkjedi.comicgenesis.com/',
        'Darken': 'http://www.darkencomic.com/',
        'DarkestShadow': 'http://morgan.comicgenesis.com/',
        'DarknessVersusLight': 'http://dvsl.comicgenesis.com/',
        'Darksided': 'http://darksided.comicgenesis.com/',
        'DasienSuperheroWebcomic': 'http://www.dasiencomic.com/',
        'Davin': 'http://davin.comicgenesis.com/',
        'DayDream': 'http://manganese.comicgenesis.com/',
        'Daydreamer': 'http://daydreamer.comicgenesis.com/',
        'DeadBeats': 'http://deadbeats.comicgenesis.com/',
        'DearBrotherMine': 'http://lancha.comicgenesis.com/',
        'DearDiary': 'http://deardiary.comicgenesis.com/',
        'DecadentAndDepraved': 'http://depraved.comicgenesis.com/',
        'DedEnd': 'http://dedend.comicgenesis.com/',
        'DefectiveChineseGirl': 'http://eclipsearikado.comicgenesis.com/',
        'Defectivity': 'http://defectivity.comicgenesis.com/',
        'DefinitelyNotAnotherWebcomicWhere': 'http://dna2w.comicgen.com/',
        'DelusionsOfAdequacy': 'http://dofa.comicgen.com/',
        'DementedEmu': 'http://dementedemu.comicgenesis.com/',
        'DemonChroniclesOfKyo': 'http://demonchronicles.comicgenesis.com/',
        'DemonSlayers': 'http://demonslayers.comicgenesis.com/',
        'DemonWing': 'http://demonwing.comicgen.com/',
        'Demonic': 'http://alyafenume.comicgen.com/',
        'DemonicBoppu': 'http://demonicboppu.comicgenesis.com/',
        'DemonicPoint': 'http://demonicpoint.comicgenesis.com/',
        'Demonocity': 'http://demonocity.comicgenesis.com/',
        'DemoralizedLogic': 'http://lostmind.comicgenesis.com/',
        'Deo': 'http://deo.comicgenesis.com/',
        'DetFemteEss': 'http://haykay.comicgenesis.com/',
        'Detalitum': 'http://abaddon.comicgenesis.com/',
        'DetalitumPl': 'http://detalitum.comicgenesis.com/',
        'DeusExMinineko': 'http://dem.comicgenesis.com/',
        'DeviantProphets': 'http://deviantprophets.comicgenesis.com/',
        'DevilsPlayground': 'http://devilsplayground.comicgenesis.com/',
        'DexLives': 'http://dexlives.comicgenesis.com/',
        'DigitalAge': 'http://digitalage.comicgenesis.com/',
        'DigitalWar': 'http://www.digitalwar.co.uk/',
        'DimBulbComics': 'http://dimbulbcomics.comicgenesis.com/',
        'DimensionHopping': 'http://dimensionhopping.comicgenesis.com/',
        'Dindsneys': 'http://xxxx.comicgenesis.com/',
        'DistantScreaming': 'http://distantscreaming.comicgenesis.com/',
        'DoTheBearcat': 'http://dtbc.comicgen.com/',
        'DocHyperion': 'http://dochyperion.comicgenesis.com/',
        'DoctorPepperShow': 'http://doctorpepper.comicgenesis.com/',
        'DogAndPony': 'http://dogandpony.comicgen.com/',
        'DogBomb': 'http://dogbomb.comicgenesis.com/',
        'DogDays': 'http://dogdays.comicgen.com/',
        'DonAndDoll': 'http://donanddoll.comicgenesis.com/',
        'DoomArmy': 'http://experimental.comicgenesis.com/',
        'DoomCheese': 'http://doomcheese.comicgenesis.com/',
        'DownwardBound': 'http://downwardbound.comicgenesis.com/',
        'DragonBallTm': 'http://dragonballtm.comicgenesis.com/',
        'DragonBoy': 'http://dragonboy.comicgenesis.com/',
        'DragonInTheCourtyard': 'http://ditc.comicgenesis.com/',
        'DragonKingdoms': 'http://dragonkingdoms.comicgenesis.com/',
        'DragonMail': 'http://dragonmail.comicgenesis.com/',
        'DragonSchoolAndStuff': 'http://dragonss.comicgenesis.com/',
        'Dragonaur': 'http://dragonaur.comicgen.com/',
        'DrawnAndQuartered': 'http://drawnandquartered.comicgenesis.com/',
        'DreamCatcher': 'http://dreamcatcher.comicgenesis.com/',
        'DreamLikeDestiny': 'http://dreamlikedestiny.comicgenesis.com/',
        'DreamOfAWorld': 'http://doaw.comicgenesis.com/',
        'DreamWay': 'http://dreamway.comicgenesis.com/',
        'DreamersDynasty': 'http://kidneo66.comicgenesis.com/',
        'DreamwaltzerZera': 'http://dwz.comicgenesis.com/',
        'DriveThruBlues': 'http://drivethrublues.comicgenesis.com/',
        'DrowNazi': 'http://drownazi.comicgenesis.com/',
        'Drunkenkite': 'http://drunkenkite.comicgen.com/',
        'DualHorizon': 'http://dualhorizon.comicgenesis.com/',
        'DuchessMew': 'http://duchessmew.comicgenesis.com/',
        'Dugger': 'http://dugger.comicgenesis.com/',
        'DumbAngel': 'http://dumbangel.comicgenesis.com/',
        'DungeonDamage': 'http://dungeondamage.comicgenesis.com/',
        'DysfunctionJunction': 'http://dysfunctionjunction.comicgenesis.com/',
        'DysonsCreek': 'http://dysonscreek.comicgen.com/',
        'E2e': 'http://e2e.comicgenesis.com/',
        'EMotel': 'http://emotel.comicgenesis.com/',
        'ESAndD': 'http://esnd.comicgenesis.com/',
        'EarlAndMyrtle': 'http://earlandmyrtle.comicgenesis.com/',
        'EarthBound': 'http://earthbound2.comicgenesis.com/',
        'EarthRiser': 'http://jscomix.comicgenesis.com/',
        'EatingTheInternet': 'http://eating.comicgenesis.com/',
        'Echzeon': 'http://echzeon.comicgenesis.com/',
        'EdensChronicle': 'http://blackeden.comicgenesis.com/',
        'EdgeTheDevilhunter': 'http://edgeknight.comicgen.com/',
        'EdibleDirt': 'http://catmydog.comicgenesis.com/',
        'EgoTrip': 'http://egotrip.comicgen.com/',
        'EinstiensDesk': 'http://einstiensdesk.comicgenesis.com/',
        'EitherWay': 'http://deadspace.comicgenesis.com/',
        'ElSuenoDeLaRazonProduceMonstruos': 'http://cubanaloca.comicgenesis.com/',
        'Eldritch': 'http://eldritch.comicgen.com/',
        'ElleAndAllTheOthers': 'http://elle.comicgenesis.com/',
        'ElvenExploration': 'http://www.theelven.com/',
        'EmSquaredACartoon': 'http://emacartoon.comicgenesis.com/',
        'EmergencyExit': 'http://www.eecomics.net/',
        'Emma': 'http://miruku.comicgenesis.com/',
        'Emo': 'http://emo.comicgenesis.com/',
        'EmperorOfOrphans': 'http://emperoroforphans.comicgenesis.com/',
        'EmptyTheater': 'http://mttheater.comicgenesis.com/',
        'EndOfThings': 'http://endofthings.comicgen.com/',
        'Ensuing': 'http://ensuing.comicgenesis.com/',
        'EnterTheStory': 'http://savedgames.comicgenesis.com/',
        'Envoy': 'http://envoy.comicgenesis.com/',
        'EpicTalesOfLaminir': 'http://jideiro.toonspace.com/',
        'EpitomeTheLifeOfGregAndSarah': 'http://logas.comicgenesis.com/',
        'ErrantVenture': 'http://errantventure.comicgenesis.com/',
        'EternalQuest': 'http://luniara.comicgenesis.com/',
        'EtherealEuphoriaTheSweetestEscape': 'http://beccat.comicgenesis.com/',
        'EveOfCloves': 'http://eveofcloves.comicgenesis.com/',
        'EverscapeNet': 'http://everscape.comicgenesis.com/',
        'EverydaySam': 'http://everydaysam.comicgenesis.com/',
        'EvilThatMenDo': 'http://theevilthatmendo.comicgenesis.com/',
        'EvilWenchesIncorporated': 'http://evilwenchesinc.comicgenesis.com/',
        'ExpeditionQuest': 'http://expeditionquest.comicgenesis.com/',
        'ExterminatusNow': 'http://exterminatusnow.comicgenesis.com/',
        'EyeForAnEye': 'http://spirat.comicgenesis.com/',
        'EyeOfTheMonkey': 'http://eyeofthemonkey.comicgenesis.com/',
        'FAIL': 'http://fail.comicgenesis.com/',
        'FERAL': 'http://feral.comicgenesis.com/',
        'FLATLINE': 'http://loadobject.comicgenesis.com/',
        'Faces': 'http://faces.comicgenesis.com/',
        'FadeToBlack': 'http://fadetoblack.comicgenesis.com/',
        'FadedBrightness': 'http://faebs.comicgenesis.com/',
        'FadingInnocence': 'http://fadinginnocence.comicgenesis.com/',
        'FaerieTales': 'http://faerietales.comicgenesis.com/',
        'Fagz': 'http://fagz.comicgenesis.com/',
        'FallenAngelsUsedBooks': 'http://www.faubcomic.com/',
        'FalseGods': 'http://falsegod.comicgenesis.com/',
        'FamiliarBlue': 'http://familiarblue.comicgen.com/',
        'FamiliarMagic': 'http://familiarmagic.comicgenesis.com/',
        'FantasticalBestiary': 'http://fantasticalbestiary.comicgenesis.com/',
        'FantasyQwest': 'http://creatorauthorman.comicgenesis.com/',
        'Fated': 'http://thefated.comicgenesis.com/',
        'Feathers': 'http://feathers.comicgenesis.com/',
        'FellowFreaks': 'http://fellowfreaks.comicgen.com/',
        'FemmeFatale': 'http://femmefatale.comicgen.com/',
        'Feyenne': 'http://feyenne.comicgen.com/',
        'FightCastOrEvade': 'http://fightcastorevade.comicgenesis.com/',
        'Filler': 'http://filler.comicgenesis.com/',
        'FinalDraft': 'http://finaldraft.comicgenesis.com/',
        'FireflyCross': 'http://fireflycross.comicgenesis.com/',
        'Fish': 'http://fish.comicgenesis.com/',
        'FishFry': 'http://fishfry.comicgenesis.com/',
        'Fishy': 'http://fishy.toonspace.com/',
        'FistofTheSarariman': 'http://fots.comicgenesis.com/',
        'Fizzle': 'http://fizzle.comicgenesis.com/',
        'FletcherApts': 'http://fletcherapts.comicgenesis.com/',
        'FlinchAndFriends': 'http://flinch.comicgen.com/',
        'FloatingFloorsOfProfessorZ': 'http://ratballista.comicgenesis.com/',
        'FlowfieldUnity': 'http://unityflow.comicgenesis.com/',
        'FluffyAndMervin': 'http://debbieann.comicgenesis.com/',
        'Flunkies': 'http://flunkies.comicgenesis.com/',
        'Flux': 'http://flux.comicgenesis.com/',
        'FlyingHighAndLow': 'http://highandlow.comicgenesis.com/',
        'Foma': 'http://foma.comicgenesis.com/',
        'FoolsGold': 'http://foolsgold.comicgenesis.com/',
        'ForcesOfGoodAndEvil': 'http://goodandevil.comicgenesis.com/',
        'ForestOfIllusion': 'http://angelizland.comicgenesis.com/',
        'FourthWall': 'http://fourthwall.comicgenesis.com/',
        'FoxTails': 'http://foxtails.comicgenesis.com/',
        'FoxfireChronicles': 'http://foxfire.comicgenesis.com/',
        'FoxsFreakyAdventures': 'http://basa.comicgenesis.com/',
        'Fr33St0FfPlz': 'http://fr33st0ffplz.comicgenesis.com/',
        'FramedArtOnTheRun': 'http://artontherun.comicgenesis.com/',
        'FreakU': 'http://freaku.comicgenesis.com/',
        'FreakzTheComic': 'http://freakzcomic.comicgenesis.com/',
        'FredBarlowe': 'http://fredbarlowe.comicgenesis.com/',
        'FreedomFries': 'http://freedomfries.comicgenesis.com/',
        'FromTheDeskOf': 'http://fromthedeskof.comicgenesis.com/',
        'FromTheMargin': 'http://fromthemargin.comicgenesis.com/',
        'FromTheSouthToTheStars': 'http://south.comicgenesis.com/',
        'FromThenOnForth': 'http://fromthenonforth.comicgenesis.com/',
        'FullCircle': 'http://fullcircle.comicgenesis.com/',
        'FunWithPants': 'http://funwithpants.comicgenesis.com/',
        'Furmentation': 'http://xodin.comicgenesis.com/',
        'FurthiaHigh': 'http://furthiahigh.comicgen.com/',
        'GTC': 'http://gtc.comicgen.com/',
        'GalacticAcademy': 'http://galacticacademy.comicgenesis.com/',
        'GambitAsBishounen': 'http://snigepippi.comicgenesis.com/',
        'GameOver': 'http://gameover.comicgenesis.com/',
        'GameJumpers': 'http://gamejumpers.comicgenesis.com/',
        'GameMisconduct': 'http://gmhockey.comicgenesis.com/',
        'GameScreenInvestigators': 'http://gsi.comicgenesis.com/',
        'GamerKingSenshi': 'http://minion.comicgenesis.com/',
        'GamerPsychotica': 'http://gp.comicgenesis.com/',
        'GamingAlive': 'http://gamingalive.comicgenesis.com/',
        'Gamingreality': 'http://gamingreality.comicgenesis.com/',
        'Garasade': 'http://garasade.comicgenesis.com/',
        'GeekWay': 'http://geekway.comicgen.com/',
        'GeeksTryingToBeFunny': 'http://geekstryingtobefunny.comicgen.com/',
        'Gemini': 'http://gemini.comicgen.com/',
        'GenerationDumb': 'http://generationdumb.comicgenesis.com/',
        'GenericGamers': 'http://shadestoneuniverse.comicgenesis.com/',
        'Ghastly': 'http://www.ghastlycomic.com/',
        'GhostHunter': 'http://ghosthunter.comicgenesis.com/',
        'Ghoul': 'http://ghoul.comicgenesis.com/',
        'GirlFromBOLT.': 'http://bolt.comicgenesis.com/',
        'Gnerds2000': 'http://gnerds.comicgenesis.com/',
        'Gnomes': 'http://gnomes.comicgenesis.com/',
        'GoFish': 'http://gofish.comicgenesis.com/',
        'GoForIt': 'http://goforit.comicgen.com/',
        'GoblinHollow': 'http://utlt.comicgenesis.com/',
        'Goblins': 'http://thunt.comicgen.com/',
        'Godlike': 'http://godlike.comicgenesis.com/',
        'Godsboxers': 'http://godsboxers.comicgenesis.com/',
        'GoldenAge': 'http://goldenage.comicgenesis.com/',
        'GoneAstray': 'http://goneastray.comicgenesis.com/',
        'GoodTimingNoRhythm': 'http://gtnr.comicgenesis.com/',
        'GorgeousPrincessCreamyBeamy': 'http://creamybeamy.comicgenesis.com/',
        'GrandTheftAuto': 'http://gtaweb.comicgenesis.com/',
        'GreatTree': 'http://tgt.comicgen.com/',
        'GreaterOfTwoEvils': 'http://g2e.comicgenesis.com/',
        'GreenAvenger': 'http://www.green-avenger.com/',
        'GreenLightGo': 'http://glg.comicgenesis.com/',
        'GreenTea': 'http://greentea.comicgenesis.com/',
        'Greymatters': 'http://greymatters.comicgenesis.com/',
        'Grit': 'http://grit.comicgenesis.com/',
        'Gropesville': 'http://gropesville.toonspace.com/',
        'GunmetalAnnie': 'http://mercuryhat.comicgenesis.com/',
        'HagsPoint': 'http://hagspoint.comicgenesis.com/',
        'HalloweenMonsters': 'http://holloweenmonsters.comicgenesis.com/',
        'HaloParty': 'http://haloparty.comicgenesis.com/',
        'HamstaPowah': 'http://hamstapowah.comicgenesis.com/',
        'HauntedByMoonlight': 'http://hauntedbymoonlight.comicgenesis.com/',
        'HaveANiceDay': 'http://yellowsnow.comicgenesis.com/',
        'Hazardswake': 'http://hazardswake.comicgen.com/',
        'HbombsBrandNewComic': 'http://hbombshow.comicgenesis.com/',
        'HeadDoctorProductions': 'http://headdoctor.comicgen.com/',
        'Hellbenders': 'http://hellbenders.comicgenesis.com/',
        'Hellroy': 'http://hellroy.comicgen.com/',
        'HelpIsOnThe Way': 'http://openwound.comicgenesis.com/',
        'HerbieAndJeff': 'http://haj.comicgenesis.com/',
        'HereAfter': 'http://keath.comicgenesis.com/',
        'Hereafter': 'http://hereafter.comicgenesis.com/',
        'HeroInTraining': 'http://thereisnosaurus.comicgen.com/',
        'HerosHandbook': 'http://theheroshandbook.comicgenesis.com/',
        'HeyFox': 'http://heyfox.comicgenesis.com/',
        'Hiakuma': 'http://hiakuma.comicgenesis.com/',
        'HiddenCakeMagic': 'http://hiddencakemagic.comicgenesis.com/',
        'HilariousHenry': 'http://hilarioushenry.comicgenesis.com/',
        'Hiro': 'http://hiro.comicgenesis.com/',
        'Hiruko': 'http://happypuke.comicgenesis.com/',
        'HomeFries': 'http://friedgreencomics.comicgenesis.com/',
        'HopeAndLaurie': 'http://hopeandlaurie.comicgenesis.com/',
        'Hopscotch': 'http://hopscotch.comicgenesis.com/',
        'HotChocolateIceCream': 'http://hotchocolate.comicgenesis.com/',
        'HouseOfBob': 'http://dustbunny.comicgen.com/',
        'HouseOfLSD': 'http://houseoflsd.comicgenesis.com/',
        'HowISeeIt': 'http://toasterpip.comicgenesis.com/',
        'Humans': 'http://humans.comicgen.com/',
        'HuntersBlade': 'http://huntersblade.comicgenesis.com/',
        'Hyperboy': 'http://hyperboycomics.comicgenesis.com/',
        'HypothesisNo': 'http://hypothesisno.comicgenesis.com/',
        'IAlwaysWakeUpLazy': 'http://www.alwayslazy.com/',
        'IAmMacdoogle': 'http://americana.comicgen.com/',
        'ICanFeelARatScratchingMyBrain': 'http://lowkianseong.comicgenesis.com/',
        'IEatFood': 'http://ieatfood.comicgen.com/',
        'IMO': 'http://imo.comicgenesis.com/',
        'ITalkToTheWind': 'http://talk.comicgenesis.com/',
        'IcarusDreams': 'http://icarusdreams.comicgenesis.com/',
        'Idget': 'http://idget.comicgenesis.com/',
        'Idiots': 'http://idiots.comicgenesis.com/',
        'IfThenElse': 'http://ifthenelse.comicgenesis.com/',
        'ImAlwaysRight': 'http://alwaysright.comicgenesis.com/',
        'InAPerfectWorld': 'http://iapw.comicgenesis.com/',
        'InMyPants': 'http://ilpalazzo.comicgenesis.com/',
        'InSanity': 'http://deviantyouth.comicgenesis.com/',
        'Incomplete': 'http://incomplete.comicgenesis.com/',
        'Indavo': 'http://indavo.comicgenesis.com/',
        'IndefensiblePositions': 'http://indepos.comicgenesis.com/',
        'Industry': 'http://twelfthgecko.comicgenesis.com/',
        'Infamous': 'http://theinfamous.comicgenesis.com/',
        'InfinityClub': 'http://infinityclub.comicgenesis.com/',
        'InsaneUndertakings': 'http://insaneundertakings.comicgenesis.com/',
        'IntermittentTangents': 'http://manekochan.comicgenesis.com/',
        'InternetFriends': 'http://internetfriends.comicgen.com/',
        'Interns': 'http://theinterns.comicgenesis.com/',
        'Irlhell': 'http://irlhell.comicgenesis.com/',
        'IslameyOrientalFantasy': 'http://islamey.comicgenesis.com/',
          'ItSAMadMadMadMadDucksWorld': 'http://doctorzaius.comicgenesis.com/',
        'JRockShellShock': 'http://jrock.comicgenesis.com/',
        'JWalkin': 'http://jwalkin.comicgenesis.com/',
        'JackDaftIII': 'http://jackdaftiii.comicgenesis.com/',
        'JackiesFridge': 'http://jackiesfridge.comicgenesis.com/',
        'Jaded': 'http://www.thejaded.co.uk/',
        'JagerRising': 'http://jinoku.comicgen.com/',
        'JannaCom': 'http://janna.comicgenesis.com/',
        'JerryLittle': 'http://suits.comicgen.com/',
        'JesusX': 'http://jesusx.comicgen.com/',
        'JimBobComics': 'http://falos.comicgenesis.com/',
        'Jitterati': 'http://jitterati.comicgenesis.com/',
        'JonesAvenue': 'http://jonesave.comicgenesis.com/',
        'JoshInTheGhetto': 'http://joshintheghetto.comicgenesis.com/',
        'Joyride': 'http://joyride.comicgenesis.com/',
        'JudeTheUnsure': 'http://jude.comicgen.com/',
        'JulyStreet': 'http://julystreet.comicgenesis.com/',
        'Jump': 'http://jump.comicgen.com/',
        'JunkRIOT': 'http://junkriot.comicgen.com/',
        'JustAnEscape': 'http://justanescape.comicgenesis.com/',
        'JustTheLifeOfShoe': 'http://justshoe.comicgenesis.com/',
        'JustWarmAndFuzzy': 'http://jwaf.comicgenesis.com/',
        'JustWeird': 'http://justweird.comicgenesis.com/',
        'JusticeMan': 'http://justiceman.comicgenesis.com/',
        'JuvenileDiversion': 'http://juvenilediversion.comicgen.com/',
        'KageToOdoru': 'http://kagetoodoru.comicgenesis.com/',
        'KariAndDoug': 'http://karindoug.comicgenesis.com/',
        'KarmaSlave': 'http://karmaslave.comicgenesis.com/',
        'Keisarinna': 'http://keisarinna.comicgenesis.com/',
        'KhaosKomic': 'http://komix.comicgenesis.com/',
        'KillingMonday': 'http://killingmonday.comicgenesis.com/',
        'KillingMoon': 'http://thekillingmoon.comicgenesis.com/',
        'KindaLikeReality': 'http://klr.comicgenesis.com/',
        'KirbyAndSambo': 'http://kirbyandsambo.comicgenesis.com/',
        'KissingKerie': 'http://kissingkerie.toonspace.com/',
        'KitNKayBoodle': 'http://kitnkayboodle.comicgenesis.com/',
        'KitchenSink': 'http://kitchensink.comicgenesis.com/',
        'KitsuneKomics': 'http://kitmehsu.comicgen.com/',
        'Kizmet': 'http://kizmet.comicgenesis.com/',
        'KnightsOfTheNexus': 'http://kotn.comicgenesis.com/',
        'KodamaNoNikki': 'http://www.skimlines.com/',
        'Kokiro': 'http://kokiro.comicgenesis.com/',
        'KomikalFrenzy': 'http://akomikalfrenzy.comicgenesis.com/',
        'KottaKokoro': 'http://kottakokoro.comicgenesis.com/',
        'KungFuPandas': 'http://kungfupandas.comicgenesis.com/',
        'KurenaiMashin': 'http://km.comicgen.com/',
        'LOGO': 'http://kikbuttpanda.comicgenesis.com/',
        'LabBratz': 'http://labbratz.comicgenesis.com/',
        'LandOfGreed': 'http://zarrillo.comicgenesis.com/',
        'LangLang': 'http://langlang.comicgenesis.com/',
        'LarryAndOliver': 'http://lao.comicgenesis.com/',
        'LastManStanding': 'http://www.lms-comic.com/',
        'LastWorld': 'http://lastworld.comicgen.com/',
        'LauraSeabrooksWebComix': 'http://lauraseabrook.comicgenesis.com/',
        'LawOfPurple': 'http://dragongirl.comicgenesis.com/',
        'LeanOnMe': 'http://jadaze.comicgenesis.com/',
        'LeapingWizards': 'http://leapingwizards.comicgenesis.com/',
        'LecheBotte': 'http://rastopopolus.comicgenesis.com/',
        'LeftAngle': 'http://theleftangle.comicgenesis.com/',
        'LegallyDeadMan': 'http://penultima.comicgenesis.com/',
        'LegendOfTheFour': 'http://legendoffour.comicgen.com/',
        'LegendOfThyme': 'http://midnightcat.comicgen.com/',
        'LegendOfTrinity': 'http://legendoftrinity.comicgenesis.com/',
        'LegionInc': 'http://legion.comicgenesis.com/',
        'LegostarGalactica': 'http://legostargalactica.comicgen.com/',
        'LeuAndYar': 'http://leunam12.comicgenesis.com/',
        'LibertysJewells': 'http://makdaddymizark.comicgenesis.com/',
        'LieToMe': 'http://lietome.comicgenesis.com/',
        'LifeAsSheKnowsIt': 'http://laski.comicgenesis.com/',
        'LifeIsUnfair': 'http://lifeisunfair.comicgen.com/',
        'LifeOfBuddha': 'http://lifeofbuddha.comicgenesis.com/',
        'LifeOnForbez': 'http://cdc.comicgen.com/',
        'LifeSuchAsItIs': 'http://lifesuchasitis.comicgenesis.com/',
        'LikeItIs': 'http://likeitis.comicgenesis.com/',
        'LilFas': 'http://lilfas.comicgenesis.com/',
        'LilFreddyVsMiniJason': 'http://fredvsjay.comicgenesis.com/',
        'LilianeBiDyke': 'http://liliane.comicgenesis.com/',
        'LindleyHallProjectMk2': 'http://tlhp.comicgenesis.com/',
        'Living': 'http://living.comicgenesis.com/',
        'LivingGallery': 'http://livinggallery.comicgenesis.com/',
        'Lola': 'http://lola.comicgen.com/',
        'LongestSojourn': 'http://longestsojourn.comicgenesis.com/',
        'LongestWalk': 'http://tlw.comicgenesis.com/',
        'LordWhatFoolsTheseMortalsBe': 'http://lordwhatfools.comicgenesis.com/',
        'Lounge': 'http://thelounge.comicgenesis.com/',
        'LoveFoolish': 'http://lovefoolish.comicgenesis.com/',
        'LoveMeNot': 'http://lovemenot.comicgen.com/',
        'LovesRequiem': 'http://lovesrequiem.comicgenesis.com/',
        'Lowroad75': 'http://lowroad75.comicgenesis.com/',
        'LoxieAndZoot': 'http://loxieandzoot.comicgenesis.com/',
        'LucidDelirium': 'http://luciddelirium.comicgen.com/',
        'LucyTheGhost': 'http://lucytheghost.comicgenesis.com/',
        'Luna': 'http://www.lunacomic.com/',
        'LunaticChaos': 'http://lunaticchaos.comicgenesis.com/',
        'LustForFreelance': 'http://imabubble.comicgenesis.com/',
        'MANTIS': 'http://mantis.comicgenesis.com/',
        'MARYSTATUES': 'http://marystatues.comicgenesis.com/',
        'MS': 'http://pcms.comicgenesis.com/',
        'MTheory': 'http://mtheory.comicgen.com/',
        'MadBrothers': 'http://madbrothers.comicgenesis.com/',
        'MadWorld': 'http://madworld.comicgenesis.com/',
        'MadeInHeaven': 'http://mih.comicgenesis.com/',
        'MagusFerox': 'http://magusferox.comicgenesis.com/',
        'MakeshiftTheatreBrigade': 'http://makeshift.comicgen.com/',
        'Malcolm': 'http://www.malcolmcomics.com/',
        'Malefactor': 'http://malefactor.comicgenesis.com/',
        'ManWhoHatesFun': 'http://mwhf.comicgenesis.com/',
        'ManicGraffiti': 'http://manic.comicgenesis.com/',
        'MansionOfE': 'http://mansionofe.comicgen.com/',
        'ManyTidingsGrim': 'http://grimtidings.comicgen.com/',
        'ManyWorlds': 'http://manyworlds.comicgenesis.com/',
        'Maq041': 'http://maq041.comicgenesis.com/',
        'MaraChan': 'http://marachan.comicgenesis.com/',
        'MarchingToADifferentAccordion': 'http://accordion.comicgenesis.com/',
        'MariposaRevelation': 'http://mariposa.comicgenesis.com/',
        'MaryComic': 'http://themarycomic.comicgenesis.com/',
        'MaxSloan': 'http://maxsloan.comicgen.com/',
        'McDuffies': 'http://mcduffies.comicgenesis.com/',
        'Medialia': 'http://www.medialia-comic.com/',
        'MediocreGothBoi': 'http://gothboi.comicgenesis.com/',
        'Mediocres': 'http://mediocres.comicgenesis.com/',
        'MegaCrap': 'http://megacrap.comicgenesis.com/',
        'MelEveryman': 'http://everyman.comicgenesis.com/',
        'MelfTheElf': 'http://melf.comicgenesis.com/',
        'Memories': 'http://squaz.comicgen.com/',
        'Menagerie': 'http://menagerie.comicgenesis.com/',
        'MichikoMonagatari': 'http://isukiyomi.comicgenesis.com/',
        'Midcentral': 'http://midcentral.comicgenesis.com/',
        'MidnightDetectives': 'http://midnightdetectives.comicgenesis.com/',
        'MidnorthFlourCo': 'http://mnflourco.comicgen.com/',
        'MindingMyOwnBusiness': 'http://mmob.comicgenesis.com/',
        'MiniatureAlley': 'http://noctology.comicgenesis.com/',
        'MinionsForHire': 'http://www.minionsforhire.com/',
        'MintWhelpSaga': 'http://mintwhelp.comicgenesis.com/',
        'Mirrors': 'http://mirrors.comicgenesis.com/',
        'MiryokutekiMonogatari': 'http://miryomono.comicgenesis.com/',
        'MisadventuresInPhysics': 'http://mip.comicgenesis.com/',
        'MisadventuresOfOkk': 'http://okk.comicgen.com/',
        'Misanthropes': 'http://misanthropes.comicgenesis.com/',
        'MixedBagComics': 'http://lowresatari.comicgenesis.com/',
        'ModernDayWitchdoctor': 'http://witchdoctor.comicgenesis.com/',
        'ModernLove': 'http://modernlove.comicgenesis.com/',
        'MolesHole': 'http://l33tgamerz.comicgenesis.com/',
        'Monkey': 'http://monkey.comicgenesis.com/',
        'MonopolyOfTruth': 'http://monopolyoftruth.comicgenesis.com/',
        'MonsterAffen': 'http://monsteraffen.comicgenesis.com/',
        'MonsterVsTheWorld': 'http://monsterworld.comicgenesis.com/',
        'MooneyTheTurtle': 'http://jwcornelius.comicgenesis.com/',
        'MoonlightFeathers': 'http://moonfea.comicgenesis.com/',
        'Morningstar': 'http://morningstar.comicgenesis.com/',
        'MortalitysEnd': 'http://mortalitysend.comicgenesis.com/',
        'MouseOfTime': 'http://mouseoftime.comicgenesis.com/',
        'MousesTail': 'http://mouse.comicgenesis.com/',
        'Mp4C': 'http://mp4c.comicgenesis.com/',
        'Muertitos': 'http://muertitos.comicgenesis.com/',
        'MundaneNirvana': 'http://mundanenirvana.comicgenesis.com/',
        'MusicOfTheWoods': 'http://sumimasen.comicgenesis.com/',
        'Mutant59': 'http://wrathofautumn.comicgenesis.com/',
        'MyAngelYouAreAngel': 'http://angel.comicgenesis.com/',
        'MyBrainHurts': 'http://mybrainhurts.comicgenesis.com/',
        'MyLifeAsATeenageElvenMaid': 'http://mlaatem.comicgenesis.com/',
        'MyLifeInBlue': 'http://mylifeinblue.comicgenesis.com/',
        'MyLifeInRecords': 'http://mylifeinrecords.comicgenesis.com/',
        'MyRegards': 'http://myregards.comicgenesis.com/',
        'MySoCalledKnife': 'http://radewagon.comicgenesis.com/',
        'MysteriousDrX': 'http://obeydrx.comicgen.com/',
        'MysticFantasy': 'http://mysticfantasy.comicgenesis.com/',
        'MysticRevolution': 'http://mysticrevolution.comicgen.com/',
        'MythChild': 'http://mysya.comicgenesis.com/',
        'NEWPORTGRL55': 'http://newportgrl55.comicgenesis.com/',
        'NUCD': 'http://nucd.comicgenesis.com/',
        'NahastLandsOfStrife': 'http://nahast.comicgenesis.com/',
        'NakedElf': 'http://nakedelf.comicgenesis.com/',
        'NamelessStory': 'http://klest.comicgenesis.com/',
        'Necronomicomics': 'http://necronomicomics.comicgenesis.com/',
        'Neighborhood': 'http://neighborhood.comicgenesis.com/',
        'Nekotime': 'http://nekotime.comicgenesis.com/',
        'NemutionJewel': 'http://nemution.comicgenesis.com/',
        'NerdRage': 'http://nerdrage.comicgenesis.com/',
        'NewAndImproved': 'http://nai.comicgenesis.com/',
        'NewHazelTiramisu': 'http://ledeggs.comicgenesis.com/',
        'Newgirl': 'http://newgirl.comicgenesis.com/',
        'Newscast': 'http://newscast.comicgenesis.com/',
        'NewtonsTheory': 'http://stevestacy.comicgenesis.com/',
        'NextDoor': 'http://nextdoor.comicgenesis.com/',
        'NickMaticPrivateEye': 'http://nickmatic.comicgenesis.com/',
        'NieceWeb': 'http://www.nieceweb.com/',
        'NileIncarnate': 'http://nileincarnate.comicgenesis.com/',
        'NinjaJohn': 'http://dangerchair.comicgen.com/',
        'NinjaVerses': 'http://www.ninjaverses.net/',
        'Ninjatopia': 'http://whiteninja.comicgenesis.com/',
        'NipAndTuck': 'http://nipandtuck.comicgenesis.com/',
        'NoCrap': 'http://nocrap.comicgen.com/',
        'NoPinkPonies': 'http://nopinkponies.comicgenesis.com/',
        'NoSoapRadio': 'http://nosoapradio.comicgenesis.com/',
        'NobTheBlob': 'http://nobtheblob.comicgen.com/',
        'Nocturnia': 'http://nocturnia.comicgenesis.com/',
        'NosesOptional': 'http://nosesoptional.comicgenesis.com/',
        'NosveRelease': 'http://nosve.comicgen.com/',
        'NotQuiteHeroes': 'http://notquiteheroes.comicgenesis.com/',
        'NothingLikeSanity': 'http://nothinglikesanity.comicgenesis.com/',
        'NothingSpecial': 'http://nothingspecial.comicgenesis.com/',
        'NowhereUniversity': 'http://nowhereu.comicgenesis.com/',
        'NthDimension': 'http://nthdimension.comicgenesis.com/',
        'NucleolusSuperheroCell': 'http://nucleolus.comicgen.com/',
        'NurseryRhymes': 'http://nrnm.comicgenesis.com/',
        'Nutcracker': 'http://nutcracker.comicgenesis.com/',
        'NyteFlyte': 'http://flyte.comicgen.com/',
        'NyuterranChronicles': 'http://www.nyuterra.com/',
        'ODARKCITY': 'http://odark.comicgenesis.com/',
        'ObscuredBySpecies': 'http://www.obscuredbyspecies.com/',
        'OddsAndEnds': 'http://oddends.comicgen.com/',
        'OffCampus': 'http://theoc.comicgenesis.com/',
        'OfficeBitch': 'http://picklejuice.comicgenesis.com/',
        'OhPanda': 'http://ohpanda.comicgenesis.com/',
        'OkayComics': 'http://okaycomics.comicgenesis.com/',
        'OnHiatus': 'http://onhiatus.comicgenesis.com/',
        'OnTheNose': 'http://lemonbar77.comicgenesis.com/',
        'OnceUponAStar': 'http://lonestar.comicgenesis.com/',
        'OnceUponATable': 'http://onatable.comicgenesis.com/',
        'OneOverZero': 'http://oneoverzero.comicgenesis.com/',
        'OopsNevermind': 'http://www.nevermindcomic.com/',
        'OpenArtServer': 'http://openartserver.comicgen.com/',
        'OpenMinded': 'http://openminded.comicgenesis.com/',
        'OperationNEKO': 'http://operationneko.comicgen.com/',
        'OrangeArrow': 'http://orangearrow.comicgenesis.com/',
        'OrcishSpam': 'http://orcishspam.comicgenesis.com/',
        'Origins': 'http://origins.comicgenesis.com/',
        'OurOddWorld': 'http://oddworld.comicgen.com/',
        'OutOfCharacterComics': 'http://ooccomic.comicgenesis.com/',
        'OutOfOrder': 'http://outoforder.comicgenesis.com/',
        'OutOfTheBlueRedux': 'http://outblue.comicgen.com/',
        'OutOfTheLoops': 'http://theloops.comicgenesis.com/',
        'Overclocked': 'http://overclocked.comicgenesis.com/',
        'PANDECT': 'http://pandect.comicgenesis.com/',
        'PANDORA': 'http://pandoranohako.comicgenesis.com/',
        'PET': 'http://petcomic.comicgenesis.com/',
        'PILL': 'http://nurseangel.comicgenesis.com/',
        'Palestra': 'http://palestra.comicgenesis.com/',
        'Pals': 'http://pals.comicgen.com/',
        'Pandala': 'http://pandala.comicgen.com/',
        'Panic7': 'http://panic7.comicgenesis.com/',
        'PanicHighSchool': 'http://panichighschool.comicgenesis.com/',
        'Pantheon': 'http://www.pantheoncomic.com/',
        'PantsOfDeath': 'http://pantsofdeath.comicgenesis.com/',
        'Papercut': 'http://cdrake.comicgenesis.com/',
        'ParallelDementia': 'http://paralleldementia.comicgenesis.com/',
        'Patchwork': 'http://patchwork.comicgenesis.com/',
        'PatchworkChampions': 'http://yeti.comicgenesis.com/',
        'Patheticity': 'http://patheticity.comicgenesis.com/',
        'PeabodyComics': 'http://peabody.comicgenesis.com/',
        'PeaceKeeperForce': 'http://thepkf.comicgen.com/',
        'Peno': 'http://peno.comicgen.com/',
        'PeopleIHate': 'http://peopleihate.toonspace.com/',
        'PerfectRoll': 'http://morbidfreak.comicgenesis.com/',
        'Perjury': 'http://perjury.comicgenesis.com/',
        'PestProductions': 'http://pestproductions.comicgenesis.com/',
        'PhatypusProductions': 'http://random.comicgenesis.com/',
        'PhilLikesTacos': 'http://philtaco.comicgen.com/',
        'PhillerSpace': 'http://phillerspace.comicgen.com/',
        'PhilosophyMonkey': 'http://philosophymonkey.comicgen.com/',
        'Picatrix': 'http://picatrix.comicgen.com/',
        'PictureDiary': 'http://picturediary.comicgenesis.com/',
        'Pineys': 'http://pineys.comicgenesis.com/',
        'PinkyTa': 'http://ozoneocean.comicgen.com/',
        'PiratesVsVikings': 'http://piratesvsvikings.comicgenesis.com/',
        'Pixelman': 'http://pixelman.comicgenesis.com/',
        'PlagueGround': 'http://plagueground.comicgenesis.com/',
        'PlayingWithKnives': 'http://pwk.comicgenesis.com/',
        'PlotlessViolence': 'http://plotlessviolence.comicgenesis.com/',
        'PluggedNickel': 'http://pluggednickel.comicgen.com/',
        'PocketkittenCom': 'http://www.pocketkitten.com/',
        'PockyOfJustice': 'http://poj.comicgenesis.com/',
        'Poesy': 'http://poesy.comicgenesis.com/',
        'PointGuardian': 'http://www.pointguardian.com/',
        'Pointless': 'http://pointless.comicgenesis.com/',
        'PointsAtRandom': 'http://clubpar.comicgenesis.com/',
        'PokemonX': 'http://pokemonx.comicgenesis.com/',
        'PoorlyDrawn': 'http://poorlydrawn.comicgenesis.com/',
        'PostScript': 'http://postscript.comicgenesis.com/',
        'PowerStalkers': 'http://powerstalkers.comicgenesis.com/',
        'PrimeOfAmbition': 'http://jaadrih.comicgenesis.com/',
        'PrimordialChaos': 'http://shianra.comicgenesis.com/',
        'PrinceOfCastles': 'http://princeofcastles.comicgenesis.com/',
        'Prismatic': 'http://prismatic.comicgenesis.com/',
        'PrivateSchoolBoys': 'http://ethancerin.comicgenesis.com/',
        'ProbabilityOfStupidity': 'http://nutpos.comicgenesis.com/',
        'ProfessionalThievery': 'http://pthievery.comicgenesis.com/',
        'Project5': 'http://project5.comicgenesis.com/',
        'ProjectWhatever': 'http://projectwhatever.comicgenesis.com/',
        'PropertyOfGwen': 'http://propertyofgwen.comicgenesis.com/',
        'ProtectMyBalls': 'http://protectmyballs.toonspace.com/',
        'Psiotechniqa': 'http://psitech.comicgen.com/',
        'PsychoticDesires': 'http://psychoticdesires.comicgenesis.com/',
        'PsychoticKiss': 'http://psychotickiss.comicgenesis.com/',
        'PulpHeroes': 'http://pulpheroes.comicgenesis.com/',
        'Puppetry': 'http://wordsandpictures.comicgenesis.com/',
        'Purgatory': 'http://cocytuz.comicgenesis.com/',
        'PursuitOfThePast': 'http://pursuit.comicgenesis.com/',
        'Pylon': 'http://pylon.comicgen.com/',
        'Queer': 'http://queer.comicgenesis.com/',
        'Quest': 'http://quest.comicgenesis.com/',
        'QuestForTheHolyStrawberry': 'http://bart.comicgenesis.com/',
        'RTPM': 'http://rtpm.comicgenesis.com/',
        'RabidsmileyRampage': 'http://rabidsmileyrampage.comicgenesis.com/',
        'RagingChinchilla': 'http://rcch.comicgenesis.com/',
        'RagnarokOnlife': 'http://ragnarokonlife.comicgenesis.com/',
        'Ragtag': 'http://ragtag.comicgenesis.com/',
        'RallyHippo': 'http://annie.comicgenesis.com/',
        'RandomAssembly': 'http://randomassembly.comicgenesis.com/',
        'RandomReality': 'http://randomreality.comicgenesis.com/',
        'RandomThoughts': 'http://randomthoughtscomics.comicgenesis.com/',
        'Randomity': 'http://bandoffour.comicgenesis.com/',
        'RandyTheCat': 'http://randythecat.comicgenesis.com/',
        'Rangers': 'http://rangers.comicgenesis.com/',
        'RapidEyeMovement': 'http://rem.comicgenesis.com/',
        'RauchVorFeuer': 'http://rauchvorfeuer.comicgenesis.com/',
        'RaveKitty': 'http://ravekitty.comicgenesis.com/',
        'ReadyOrNot': 'http://ron.comicgen.com/',
        'ReadyWit': 'http://witsend.comicgenesis.com/',
        'RealFantasy': 'http://realfantasy.comicgenesis.com/',
        'ReasonImEverythingYouWant': 'http://everythingyouwant.comicgenesis.com/',
        'ReasonedCognition': 'http://www.reasonedcognition.com/',
        'RecklessYouth': 'http://recklessyouth.comicgen.com/',
        'Reclamation': 'http://reclamation.comicgenesis.com/',
        'RedLexi': 'http://redlexi.webcomicspace.com/',
        'RedTape': 'http://redtape.comicgenesis.com/',
        'ReflectionsThroughAWarpedMind': 'http://rtwm.comicgenesis.com/',
        'Remembrance': 'http://remembrance.comicgenesis.com/',
        'Reporterz': 'http://reporterz.comicgenesis.com/',
        'RetrogressiveIndexingAndFiling': 'http://spools.comicgen.com/',
        'ReturnToDonnelly': 'http://returntodonnelly.comicgen.com/',
        'ReturnToEden': 'http://returntoeden.comicgenesis.com/',
        'Reveillerie': 'http://hootoo.comicgenesis.com/',
        'RidingTheMediumBus': 'http://pencilears.comicgenesis.com/',
        'RingsOfFate': 'http://angelzash.comicgenesis.com/',
        'Riot': 'http://riotoffee.comicgenesis.com/',
        'RitasComic': 'http://ritascomic.comicgenesis.com/',
        'RobmanShow': 'http://therobmanshow.comicgenesis.com/',
        'RogerAndDominic': 'http://roganddom.comicgenesis.com/',
        'RoguesOfClwydRhan': 'http://rocr.comicgenesis.com/',
        'RoleOfTheDie': 'http://www.roleofthedie.com/',
        'Roughies': 'http://www.roughies.com/',
        'RowAndBee': 'http://rowbee.comicgenesis.com/',
        'RoxxorUniversity': 'http://roxxoru.comicgen.com/',
        'RoxyComicBookSuperhero': 'http://roxycomic.comicgenesis.com/',
        'RoyalBlue': 'http://royalblue.comicgenesis.com/',
        'RubyPearl': 'http://rubypearl.comicgenesis.com/',
        'RueTheDay': 'http://ruetheday.comicgenesis.com/',
        'Ruination': 'http://ruination.comicgenesis.com/',
        'SLAYERSREWIND': 'http://wyldcherry.comicgen.com/',
        'SPUG': 'http://spug.comicgenesis.com/',
        'STFU': 'http://stfu.comicgen.com/',
        'SagaOfGager': 'http://gager.comicgenesis.com/',
        'SaigoNoDensetsuLastLegend': 'http://saigo.comicgenesis.com/',
        'SamAndElisAdventures': 'http://sameliadv.comicgenesis.com/',
        'SamuraiMushroom': 'http://samuraimushroom.comicgenesis.com/',
        'SandwichWorld': 'http://sandwichworld.webcomicspace.com/',
        'SaturdayMorningBreakfastCereal': 'http://smbc.comicgenesis.com/',
        'Saturnalia': 'http://saturnalia.comicgenesis.com/',
        'SavannDuh': 'http://savannduh.comicgenesis.com/',
        'SaveUsProcrastinatron': 'http://procrastinatron.comicgenesis.com/',
        'SaveVsMagic': 'http://svmagic.comicgenesis.com/',
        'ScandalSheet': 'http://scandalsheet.comicgenesis.com/',
        'Scarecrow': 'http://scarecrow.comicgen.com/',
        'Scatterplot': 'http://scatterplot.comicgenesis.com/',
        'ScentOfASong': 'http://scentofasong.comicgenesis.com/',
        'SchoolSpirit': 'http://www.schoolspiritcomic.com/',
        'Scratch': 'http://rene.comicgenesis.com/',
        'ScrollDynasty': 'http://scrolldynasty.comicgenesis.com/',
        'Scrued': 'http://www.scrued.com/',
        'Seagate': 'http://seatgate.comicgenesis.com/',
        'SecondStage': 'http://secondstage.comicgenesis.com/',
        'SemiRealTales': 'http://semirealtales.comicgenesis.com/',
        'Senioritis': 'http://senioritis.comicgenesis.com/',
        'SeriesOfFortunateEvents': 'http://fortunateevents.comicgenesis.com/',
        'SerifFearTheDot': 'http://fearthedot.comicgenesis.com/',
        'SeriouslySuzy': 'http://suzy.comicgen.com/',
        'Seven': 'http://eris.comicgenesis.com/',
        'SevenOfSpades': 'http://sevenofspades.comicgenesis.com/',
        'SeventhSoldier': 'http://kirbythestampede.comicgenesis.com/',
        'SexLiesAndFord': 'http://slaf.comicgenesis.com/',
        'SexPercussions': 'http://sexpercussions.comicgenesis.com/',
        'ShadowPlanet': 'http://shadowplanet.comicgenesis.com/',
        'SharingAUniverse': 'http://sharingauniverse.comicgen.com/',
        'Sharper': 'http://sharper.comicgenesis.com/',
        'Shifters': 'http://shifters.comicgen.com/',
        'Shijin': 'http://gutterflower.comicgenesis.com/',
        'ShineGetDumplingsGoGoTower': 'http://shinegotower.comicgen.com/',
        'Shinpad': 'http://shinpad.comicgen.com/',
        'ShitsugenFightingAcademy': 'http://shitsugen.comicgenesis.com/',
        'ShonenAiKudasai!': 'http://kudasai.stripspace.com/',
        'ShortEnd': 'http://theshortend.comicgenesis.com/',
        'Shrooms': 'http://shrooms.comicgenesis.com/',
        'Shy': 'http://shy.comicgenesis.com/',
        'Sidenote': 'http://ntc.comicgenesis.com/',
        'SiegelDerDoppelseele': 'http://siegel.comicgenesis.com/',
        'SilverBirchForest': 'http://tsbf.comicgenesis.com/',
        'Silvette': 'http://silvette.comicgenesis.com/',
        'SimpleMinded': 'http://simpleminded.comicgenesis.com/',
        'SinPerspectiva': 'http://mysp.comicgenesis.com/',
        'SinisterBedfellows': 'http://mckenzee.comicgenesis.com/',
        'SinkOrDrown': 'http://sinkordrown.comicgenesis.com/',
        'SinsAgainstNature': 'http://sane.comicgen.com/',
        'SippansSerie': 'http://sippan.comicgenesis.com/',
        'SixDragons': 'http://sixdragons.comicgenesis.com/',
        'SixSeconds': 'http://sixseconds.comicgenesis.com/',
        'SkardOneInc': 'http://skardoneinc.comicgenesis.com/',
        'Sketchbook': 'http://sss.comicgen.com/',
        'SkewedReality': 'http://skewedreality.comicgenesis.com/',
        'Skunk': 'http://www.skunkcomic.com/',
        'Skunkadoo': 'http://skunkadoo.comicgenesis.com/',
        'SnowflakeStudios': 'http://snowflakestudios.comicgenesis.com/',
        'SoKeiItHurts': 'http://sokeiithurts.comicgenesis.com/',
        'SoWhat': 'http://sowhat.comicgenesis.com/',
        'SoccerIsFullOfCheese': 'http://soccercheese.comicgenesis.com/',
        'SocializedMedicine': 'http://socializedmedicine.comicgenesis.com/',
        'SodapopJunkies': 'http://sodapopjunkies.comicgenesis.com/',
        'SoilentIndustriesInc': 'http://soilent.comicgenesis.com/',
        'SomeplaceElse': 'http://someplace.comicgen.com/',
        'SomethingStrange': 'http://somethingstrange.comicgen.com/',
        'SomewhereCalledHemel': 'http://hemel.comicgenesis.com/',
        'Sorcery101': 'http://sorcery101.comicgenesis.com/',
        'SouthSprings': 'http://southsprings.comicgenesis.com/',
        'Spacial': 'http://spacial.comicgenesis.com/',
        'SpareChange': 'http://sparechange.comicgenesis.com/',
        'Special': 'http://special.comicgenesis.com/',
        'SpellBinder': 'http://wizard.comicgenesis.com/',
        'SpiderBubblegum': 'http://spiderbubblegum.comicgenesis.com/',
        'SplendiforousEscapades': 'http://splendiforous.comicgenesis.com/',
        'SpritescapeFantasy': 'http://spritescape.comicgenesis.com/',
        'SpritevilleUSA': 'http://spriteville.comicgen.com/',
        'Squid': 'http://squid.comicgenesis.com/',
        'SquidGideon': 'http://silus.comicgenesis.com/',
        'SquidNinja': 'http://www.squidninja.com/',
        'StagnantWaters': 'http://stagnantwaters.comicgenesis.com/',
        'Stalag99': 'http://www.stalag99.net/',
        'StaleChocolates': 'http://stalechocolates.comicgen.com/',
        'StalkingMillionaries': 'http://packrat.comicgenesis.com/',
        'StalkingSnape': 'http://snape.comicgenesis.com/',
        'StandardDeviation': 'http://codered.comicgenesis.com/',
        'StarBored': 'http://oosterwijk.comicgenesis.com/',
        'StartWreck': 'http://startwreck.comicgenesis.com/',
        'StepTooFar': 'http://asoftercore.comicgenesis.com/',
        'SteveAndMac': 'http://steveandmac.comicgenesis.com/',
        'StickFigureDragons': 'http://feychild.comicgenesis.com/',
        'StickmenFromHell': 'http://hellstick.comicgenesis.com/',
        'StraightAhead': 'http://straightahead.comicgenesis.com/',
        'StraightJacketFreedomForce': 'http://tsjff.comicgenesis.com/',
        'StrangeCandy': 'http://www.strangecandy.net/',
        'StrangeDaze': 'http://strangedaze.comicgenesis.com/',
        'StrangeHappenings': 'http://strangehappenings.toonspace.com/',
        'StripErs': 'http://stripers.comicgenesis.com/',
        'StrippedAgain': 'http://strippedagain.comicgenesis.com/',
        'StubbsComics': 'http://stubbscomics.comicgenesis.com/',
        'Styx': 'http://ziggys.comicgenesis.com/',
        'SubliminalObsession': 'http://subliminalobsession.comicgenesis.com/',
        'SuicidalKillers': 'http://suicidalkillers.comicgen.com/',
        'SuicideForHire': 'http://suicideforhire.comicgenesis.com/',
        'Summoners': 'http://summoners.comicgenesis.com/',
        'SundaeConnection': 'http://sundaeconnection.comicgen.com/',
        'SunlessMorning': 'http://allegory42.comicgenesis.com/',
        'SuperChibiDeathBots': 'http://scdb.comicgenesis.com/',
        'SuperPeoples': 'http://superpeoples.comicgenesis.com/',
        'SuperTemps': 'http://megaskunjii.comicgenesis.com/',
        'Superfightfight': 'http://superfightfight.comicgenesis.com/',
        'SuperheroSportsBar': 'http://superbar.comicgenesis.com/',
        'Superzero': 'http://superzerocomic.comicgenesis.com/',
        'SurrealKins': 'http://www.surreal-kins.com/',
        'SushiComics': 'http://sushi.comicgenesis.com/',
        'SushiDatabase': 'http://sushidatabase.comicgenesis.com/',
        'TABU': 'http://tabu.comicgen.com/',
        'TAVision': 'http://tav.comicgenesis.com/',
        'TORMENT': 'http://torment.comicgenesis.com/',
        'TacoTuesday': 'http://tacotuesdays.comicgenesis.com/',
        'TacosGoHere': 'http://thetacosgohere.comicgen.com/',
        'Taffyhat': 'http://taffyhat.comicgen.com/',
        'TailsOfIxinia': 'http://nalkari.comicgenesis.com/',
        'Tainted': 'http://tainted.comicgenesis.com/',
        'TakeSteveToSchool': 'http://takestevetoschool.comicgenesis.com/',
        'TalesOfAReceptionist': 'http://toar.comicgenesis.com/',
        'TalesOfEpicProportion': 'http://linzmerica.comicgenesis.com/',
        'TalesOfPylea': 'http://talesofpylea.comicgenesis.com/',
        'TalesOfTheQuestor': 'http://npc.comicgenesis.com/',
        'TangsWeeklyComic': 'http://tang.comicgenesis.com/',
        'Tankd': 'http://tanked.comicgenesis.com/',
        'Tansocks': 'http://tansocks.comicgenesis.com/',
        'Tari': 'http://tari.comicgenesis.com/',
        'Tartarus': 'http://tartarus.comicgen.com/',
        'TeaCastle': 'http://teacastle.comicgenesis.com/',
        'TeacosiesWithIrony': 'http://teacosieswithirony.comicgenesis.com/',
        'TeacosiesWithIronyLP': 'http://teacosieswithironylargeprint.comicgenesis.com/',
        'TeamZodiak': 'http://teamzodiak.comicgenesis.com/',
        'TeddyBearAntiChrist': 'http://tbac.comicgenesis.com/',
        'Tehuti': 'http://tehuti.comicgenesis.com/',
        'TeriyakiSavior': 'http://lunaticrage.comicgenesis.com/',
        'TexAndJenny': 'http://texandjenny.comicgen.com/',
        'Thatguy': 'http://thatguy.comicgenesis.com/',
        'ThereIsNoCheese': 'http://nocheese.comicgenesis.com/',
        'TheriThere': 'http://therithere.comicgenesis.com/',
        'Thespiphobia': 'http://thespiphobia.comicgenesis.com/',
        'ThingInTheGrass': 'http://thinginthegrass.comicgenesis.com/',
        'ThinginessOfChaos': 'http://thinginess.comicgenesis.com/',
        'ThirdCity': 'http://cityonedge.comicgen.com/',
        'ThirdDementia': 'http://thirddementia.comicgenesis.com/',
        'ThirteenthMonth': 'http://thethirteenthmonth.comicgenesis.com/',
        'ThisISLife': 'http://thisislife.comicgenesis.com/',
        'Thoughts': 'http://thoughts.comicgenesis.com/',
        'TieGuy': 'http://tieguy.comicgenesis.com/',
        'Tightsight': 'http://tightsight.comicgenesis.com/',
        'TimePig': 'http://timepig.comicgenesis.com/',
        'TipOfTheSword': 'http://tipofthesword.comicgenesis.com/',
        'TitlePending': 'http://titlepend.comicgen.com/',
        'ToLightYourWay': 'http://badlydubbed.comicgen.com/',
        'Tofustyle': 'http://tofustyle.comicgenesis.com/',
        'TomorrowIsJustAnotherDay': 'http://inagasaki.comicgenesis.com/',
        'TonjaSteele': 'http://tonjasteele.comicgenesis.com/',
        'Toolshed': 'http://toolshed.comicgenesis.com/',
        'Torio': 'http://torio.comicgen.com/',
        'Tove': 'http://tove.comicgenesis.com/',
        'Towner': 'http://towner.comicgenesis.com/',
        'ToyDivision': 'http://toydivision.comicgenesis.com/',
        'TracyAndTristan': 'http://tandt.comicgenesis.com/',
        'TransformationComplication': 'http://cfmorph.comicgenesis.com/',
        'Transplant': 'http://transplant.comicgenesis.com/',
        'TreadingGround': 'http://treadingground.comicgenesis.com/',
        'TreeSprocket': 'http://treesprocket.comicgenesis.com/',
        'TrentTheEmogoth': 'http://lifeispain.comicgenesis.com/',
        'TrialAndError': 'http://trialanderror.comicgenesis.com/',
        'TrikeEpoch': 'http://trikeepoch.comicgenesis.com/',
        'TrilinkSaga': 'http://trilink.comicgenesis.com/',
        'TripleTrouble': 'http://tripletrouble.comicgen.com/',
        'TriquetraCats': 'http://triquetracats.comicgenesis.com/',
        'TriumphantLosers': 'http://triumphantlosers.comicgenesis.com/',
        'Trout': 'http://www.troutcomic.com/',
        'TrueBums': 'http://truebums.comicgenesis.com/',
        'TrueGroove': 'http://truegroove.comicgen.com/',
        'Tsukiyo': 'http://tsukiyo.comicgenesis.com/',
        'TupmansTheater': 'http://tupmans.comicgenesis.com/',
        'TurboNinjaBastard': 'http://tnb.comicgen.com/',
        'TurboTrak': 'http://turbotrak.comicgen.com/',
        'TwiceDestined': 'http://twicedestined.comicgenesis.com/',
        'Twilight': 'http://zilelabelle.comicgen.com/',
        'TwilightOfASorceress': 'http://kenjiandmokoto.comicgenesis.com/',
        'TwistedTales': 'http://www.jastiv.com/',
        'Twitchgenius': 'http://twitchgenius.comicgenesis.com/',
        'TwoEvilScientists': 'http://twoevilscientists.comicgenesis.com/',
        'TwobitHeros': 'http://twobitheros.comicgenesis.com/',
        'TypeMismatch': 'http://typemismatch.comicgenesis.com/',
        'UberBean': 'http://theuberbean.comicgenesis.com/',
        'UbergeekSpriteWorld': 'http://www.ubergeekthecomic.com/',
        'UglyGirl': 'http://nanda.comicgenesis.com/',
        'UmlautHouse': 'http://umlauthouse.comicgenesis.com/',
        'UnbreakblePromises': 'http://unbreakablepromises.comicgenesis.com/',
        'UncertaintyPrinciple': 'http://uncertaintyprinciple.comicgenesis.com/',
        'UnchronologicalChroniclesOfFrank': 'http://joelathon.comicgenesis.com/',
        'UnfunnyComputerFunnies': 'http://unfunny.comicgen.com/',
        'UnityARockstarSaga': 'http://elementalseekers.comicgenesis.com/',
        'UnlifeOnline': 'http://unlifeonline.comicgen.com/',
        'UnoTheAlien': 'http://unothealien.comicgenesis.com/',
        'UnrealityCheck': 'http://unrealitycheck.comicgenesis.com/',
        'Untitled': 'http://untitled.comicgen.com/',
        'UntitledLoveSong': 'http://west.comicgen.com/',
        'Untouchables': 'http://untouchables.comicgenesis.com/',
        'UrbanFable': 'http://urbanfable.comicgenesis.com/',
        'UsersVsUsers': 'http://usersvsusers.comicgenesis.com/',
        'VaguelyAmazing': 'http://vaguelyamazing.comicgenesis.com/',
        'VampiresCurse': 'http://vampire.comicgenesis.com/',
        'VaporLock': 'http://vaporlock.comicgenesis.com/',
        'Veena': 'http://veena.comicgenesis.com/',
        'VengeanceAndWrath': 'http://vengeanceandwrath.comicgenesis.com/',
        'VenusAscending': 'http://catgirldo.comicgen.com/',
        'VenusEnvy': 'http://venusenvy.comicgenesis.com/',
        'VermilionCage': 'http://vermilioncage.comicgen.com/',
        'VerySpaceyDrama': 'http://spaceydrama.comicgenesis.com/',
        'VicAndEdwards': 'http://vicandedwards.comicgenesis.com/',
        'Victor': 'http://victor.comicgenesis.com/',
        'VictorianTimes': 'http://victorian.comicgenesis.com/',
        'VirtualRodeo': 'http://virtualrodeo.comicgenesis.com/',
        'Void': 'http://angrypotatostudios.comicgenesis.com/',
        'VolatileMachinations': 'http://volatilemachinations.comicgenesis.com/',
        'Volet': 'http://volet.comicgenesis.com/',
        'Wacoon': 'http://wacoon.comicgenesis.com/',
        'WaistHigh': 'http://waisthigh.comicgenesis.com/',
        'Wanted': 'http://wanted.comicgenesis.com/',
        'WarOfWinds': 'http://warofwinds.comicgenesis.com/',
        'WarningBucketsOfBlood': 'http://chaoticcomics.comicgen.com/',
        'WarpedReality': 'http://warpedreality.comicgenesis.com/',
        'WastedOnGaia': 'http://wog.comicgenesis.com/',
        'WayTooRandom': 'http://waytoorandom.comicgen.com/',
        'WeGrewFur': 'http://m1nion.comicgenesis.com/',
        'WelcomeToLemonHouseApartment': 'http://llewenayah.comicgenesis.com/',
        'WelcomeToParadise': 'http://paradise.comicgenesis.com/',
        'Werechild': 'http://werechild.comicgenesis.com/',
        'Wereworld': 'http://wereworld.comicgenesis.com/',
        'WhatTheHell': 'http://whatthehell.comicgenesis.com/',
        'WhatYouDontSee': 'http://phantomlady4.comicgen.com/',
        'Whatever': 'http://whatever.comicgen.com/',
        'WhereGodsAndMortalsDance': 'http://wgmd.comicgenesis.com/',
        'WhiskeyAndMelancholy': 'http://sesquipedalophobe.comicgenesis.com/',
        'WhiteAsh': 'http://whiteash.comicgenesis.com/',
        'WhiteFeather': 'http://whitefeathermanga.comicgenesis.com/',
        'WhyNot': 'http://wynt.comicgenesis.com/',
        'WhymeComics': 'http://whymecomics.comicgenesis.com/',
        'WingsOfChange': 'http://wingsofchange.comicgen.com/',
        'WishInOneHand': 'http://wishin1hand.comicgenesis.com/',
        'Witchprickers': 'http://buxompiratewench.comicgenesis.com/',
        'Witticisma': 'http://witticisma.comicgen.com/',
        'WizardAndWarrior': 'http://wizardandwarrior.comicgenesis.com/',
        'WlcdTheNewsChicks': 'http://lcd.comicgenesis.com/',
        'Wonderflu': 'http://wonderflu.comicgenesis.com/',
        'WorldDomination': 'http://wdomination.comicgenesis.com/',
        'WorldOfFenninRo': 'http://wofr.comicgenesis.com/',
        'WorldUpsideDown': 'http://nekofan.comicgenesis.com/',
        'WorldWarp': 'http://ivstudios.comicgen.com/',
        'WouldBeAngelsWouldBeGods': 'http://nekomimi.webcomicspace.com/',
        'WrathOfHeaven': 'http://wrath.comicgenesis.com/',
        'WrongBand': 'http://thewrongband.comicgen.com/',
        'XCHOPSTICKSxNeo': 'http://chopsticksneo.comicgen.com/',
        'YOSH': 'http://yosh.comicgen.com/',
        'YUPlusME': 'http://yume.comicgen.com/',
        'YangChild': 'http://yangchild.comicgenesis.com/',
        'YellowMoon': 'http://yellowmoon.comicgenesis.com/',
        'YouDontGetItDoYou': 'http://youdontgetit.comicgen.com/',
        'YouScrewedUp': 'http://youscrewedup.comicgenesis.com/',
        'Zarla': 'http://zarla.comicgenesis.com/',
        'ZeeraTheSpacePirate': 'http://zeera.comicgenesis.com/',
        'Zelon': 'http://zelon.comicgen.com/',
        'Zeta': 'http://zetahome.comicgenesis.com/',
        'ZeuU': 'http://zeurinu.comicgenesis.com/',
        'ZilchAndSolo': 'http://zilchandsolo.comicgenesis.com/',
        'ZombieHouse': 'http://zhouse.comicgenesis.com/',
        'Zoology': 'http://thezoo.comicgenesis.com/',
        'ZorroAndEster': 'http://zorroandester.comicgenesis.com/',
    }

    latestUrls = {
        'Alice': 'http://www.alicecomics.com/today.html',
        'Bobbins': 'http://bobbins.org/d/20020603.html',
        'CoolCatStudios': 'http://www.coolcatstudio.com/d/20020415.html',
        'CruelFate': 'http://cruelfate.keenspot.com/d/20000630.html',
#        'ElfLife': 'http://www.elflife.com/today.html',
        'IllegalElian': 'http://illegalelian.keenspot.com/d/20000531.html',
        'TheSilveryCentipede': 'http://silverycentipede.keenspot.com/d/20000428.html',
        'TheShadows': 'http://www.alicecomics.com/shadows.html',
#        'YouDamnKid': 'http://www.youdamnkid.com/ydk.html',
# ComicGenesis comics
        'ToyDivision': 'http://toydivision.comicgenesis.com/index2.html',
        'Shy': 'http://shy.comicgenesis.com/welcome.htm',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        baseUrl = self.submodules[submodule]
        self.latestUrl = self.latestUrls.get(submodule, baseUrl)
        self.imageUrl = baseUrl + self.imageUrl
        self.name = 'KeenSpot' + '/' + submodule
