import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule
from dosage.util import getQueryParams

class RealLife(BasicComicModule):
    latestUrl = 'http://www.reallifecomics.com/'
    imageUrl = 'http://www.reallifecomics.com/daily.php?strip_id=%s'
    imageSearch = re.compile(r'<img src=\'(/(?:daily|index).php\?do_command=show_strip&strip_id=\d+.+?)\'', re.IGNORECASE)
    prevSearch = re.compile(r'<a href=[\'"](/?daily.php\?strip_id=\d+)[\'"]><img src=[\'"]images/nav_previous.png[\'"]', re.IGNORECASE)
    help = 'Index format: n (unpadded)'

    def getFilename(self, imageUrl, pageUrl):
        return getQueryParams(imageUrl)['strip_id'][0]
