import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class TheFray(BasicComicModule):
    baseUrl = 'http://www.funnybonecomics.com/thefray/%s.html'
    imageUrl = 'http://www.funnybonecomics.com/thefray/thefray_%s.shtml'
    imageSearch = re.compile(r'<img src="(images/archive/thefray_\d{8}\..+?)"')
    prevSearch = re.compile(r'<area href="(thefray_\d{8}\.shtml)" shape="rect" coords="[\d, ]+" alt="Previous">')
    help = 'Index format: yyyymmdd'

    submodules = {
        'ThePreface': 'thepreface',
        'TheHole': 'thehole',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        self.latestUrl = self.baseUrl % (self.submodules[submodule],)
